/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.internal;

import org.apache.felix.dm.Component;
import org.opendaylight.controller.protocol_plugin.openflow.IFlowProgrammerNotifier;
import org.opendaylight.controller.sal.connection.IPluginOutConnectionService;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.flowprogrammer.Flow;
import org.opendaylight.controller.sal.flowprogrammer.IPluginOutFlowProgrammerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowProgrammerNotifier
implements IFlowProgrammerNotifier {
    protected static final Logger logger = LoggerFactory.getLogger(FlowProgrammerNotifier.class);
    private IPluginOutFlowProgrammerService salNotifier = null;
    private IPluginOutConnectionService connectionOutService;

    void init(Component c) {
        logger.debug("INIT called!");
    }

    void destroy() {
        logger.debug("DESTROY called!");
    }

    void start() {
        logger.debug("START called!");
    }

    void stop() {
        logger.debug("STOP called!");
    }

    public void setPluginOutFlowProgrammerService(IPluginOutFlowProgrammerService s) {
        this.salNotifier = s;
    }

    public void unsetPluginOutFlowProgrammerService(IPluginOutFlowProgrammerService s) {
        if (this.salNotifier == s) {
            this.salNotifier = null;
        }
    }

    public void flowRemoved(Node node, Flow flow) {
        if (!this.connectionOutService.isLocal(node)) {
            logger.debug("flow removed will not be notified in a non-master controller for node " + node);
            return;
        }
        if (this.salNotifier != null) {
            this.salNotifier.flowRemoved(node, flow);
        } else {
            logger.warn("Unable to relay switch message to upper layer");
        }
    }

    public void flowErrorReported(Node node, long rid, Object err) {
        if (!this.connectionOutService.isLocal(node)) {
            logger.debug("flow error will not be notified in a non-master controller for node " + node);
            return;
        }
        if (this.salNotifier != null) {
            this.salNotifier.flowErrorReported(node, rid, err);
        } else {
            logger.warn("Unable to relay switch error message to upper layer");
        }
    }

    void setIPluginOutConnectionService(IPluginOutConnectionService s) {
        this.connectionOutService = s;
    }

    void unsetIPluginOutConnectionService(IPluginOutConnectionService s) {
        if (this.connectionOutService == s) {
            this.connectionOutService = null;
        }
    }
}

