/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.internal;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.controller.protocol_plugin.openflow.internal.PortConverter;
import org.opendaylight.controller.protocol_plugin.openflow.vendorextension.v6extension.V6FlowMod;
import org.opendaylight.controller.protocol_plugin.openflow.vendorextension.v6extension.V6Match;
import org.opendaylight.controller.sal.action.Action;
import org.opendaylight.controller.sal.action.ActionType;
import org.opendaylight.controller.sal.action.Controller;
import org.opendaylight.controller.sal.action.Drop;
import org.opendaylight.controller.sal.action.Enqueue;
import org.opendaylight.controller.sal.action.Flood;
import org.opendaylight.controller.sal.action.FloodAll;
import org.opendaylight.controller.sal.action.HwPath;
import org.opendaylight.controller.sal.action.Loopback;
import org.opendaylight.controller.sal.action.Output;
import org.opendaylight.controller.sal.action.PopVlan;
import org.opendaylight.controller.sal.action.SetDlDst;
import org.opendaylight.controller.sal.action.SetDlSrc;
import org.opendaylight.controller.sal.action.SetNwDst;
import org.opendaylight.controller.sal.action.SetNwSrc;
import org.opendaylight.controller.sal.action.SetNwTos;
import org.opendaylight.controller.sal.action.SetTpDst;
import org.opendaylight.controller.sal.action.SetTpSrc;
import org.opendaylight.controller.sal.action.SetVlanId;
import org.opendaylight.controller.sal.action.SetVlanPcp;
import org.opendaylight.controller.sal.action.SwPath;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.flowprogrammer.Flow;
import org.opendaylight.controller.sal.match.Match;
import org.opendaylight.controller.sal.match.MatchField;
import org.opendaylight.controller.sal.match.MatchType;
import org.opendaylight.controller.sal.utils.NetUtils;
import org.opendaylight.controller.sal.utils.NodeConnectorCreator;
import org.openflow.protocol.OFFlowMod;
import org.openflow.protocol.OFMatch;
import org.openflow.protocol.OFMessage;
import org.openflow.protocol.OFPacketOut;
import org.openflow.protocol.OFPort;
import org.openflow.protocol.OFVendor;
import org.openflow.protocol.action.OFAction;
import org.openflow.protocol.action.OFActionDataLayer;
import org.openflow.protocol.action.OFActionDataLayerDestination;
import org.openflow.protocol.action.OFActionDataLayerSource;
import org.openflow.protocol.action.OFActionEnqueue;
import org.openflow.protocol.action.OFActionNetworkLayerAddress;
import org.openflow.protocol.action.OFActionNetworkLayerDestination;
import org.openflow.protocol.action.OFActionNetworkLayerSource;
import org.openflow.protocol.action.OFActionNetworkTypeOfService;
import org.openflow.protocol.action.OFActionOutput;
import org.openflow.protocol.action.OFActionStripVirtualLan;
import org.openflow.protocol.action.OFActionTransportLayer;
import org.openflow.protocol.action.OFActionTransportLayerDestination;
import org.openflow.protocol.action.OFActionTransportLayerSource;
import org.openflow.protocol.action.OFActionVirtualLanIdentifier;
import org.openflow.protocol.action.OFActionVirtualLanPriorityCodePoint;
import org.openflow.util.U16;
import org.openflow.util.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowConverter {
    protected static final Logger logger = LoggerFactory.getLogger(FlowConverter.class);
    private static final short OFP_VLAN_NONE = -1;
    private Flow flow;
    private OFMatch ofMatch;
    private List<OFAction> actionsList;
    private int actionsLength;
    private boolean isIPv6;
    private static final Map<Integer, Class<? extends Action>> actionMap = new HashMap<Integer, Class<? extends Action>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(1, Output.class);
            this.put(2, SetVlanId.class);
            this.put(4, SetVlanPcp.class);
            this.put(8, PopVlan.class);
            this.put(16, SetDlSrc.class);
            this.put(32, SetDlDst.class);
            this.put(64, SetNwSrc.class);
            this.put(128, SetNwDst.class);
            this.put(256, SetNwTos.class);
            this.put(512, SetTpSrc.class);
            this.put(1024, SetTpDst.class);
            this.put(2048, Enqueue.class);
        }
    };

    public FlowConverter(OFMatch ofMatch, List<OFAction> actionsList) {
        this.ofMatch = ofMatch;
        this.actionsList = actionsList;
        this.actionsLength = 0;
        this.flow = null;
        this.isIPv6 = ofMatch instanceof V6Match;
    }

    public FlowConverter(Flow flow) {
        this.ofMatch = null;
        this.actionsList = null;
        this.actionsLength = 0;
        this.flow = flow;
        this.isIPv6 = flow.isIPv6();
    }

    public OFMatch getOFMatch() {
        if (this.ofMatch == null) {
            int maskLength;
            Match match = this.flow.getMatch();
            this.ofMatch = this.isIPv6 ? new V6Match() : new OFMatch();
            int wildcards = 0x3FFFFF;
            if (match.isPresent(MatchType.IN_PORT)) {
                short port = (Short)((NodeConnector)match.getField(MatchType.IN_PORT).getValue()).getID();
                if (!this.isIPv6) {
                    this.ofMatch.setInputPort(port);
                    wildcards &= 0xFFFFFFFE;
                } else {
                    ((V6Match)this.ofMatch).setInputPort(port, (short)0);
                }
            }
            if (match.isPresent(MatchType.DL_SRC)) {
                byte[] srcMac = (byte[])match.getField(MatchType.DL_SRC).getValue();
                if (!this.isIPv6) {
                    this.ofMatch.setDataLayerSource((byte[])srcMac.clone());
                    wildcards &= 0xFFFFFFFB;
                } else {
                    ((V6Match)this.ofMatch).setDataLayerSource(srcMac, null);
                }
            }
            if (match.isPresent(MatchType.DL_DST)) {
                byte[] dstMac = (byte[])match.getField(MatchType.DL_DST).getValue();
                if (!this.isIPv6) {
                    this.ofMatch.setDataLayerDestination((byte[])dstMac.clone());
                    wildcards &= 0xFFFFFFF7;
                } else {
                    ((V6Match)this.ofMatch).setDataLayerDestination(dstMac, null);
                }
            }
            if (match.isPresent(MatchType.DL_VLAN)) {
                short vlan = (Short)match.getField(MatchType.DL_VLAN).getValue();
                if (vlan == 0) {
                    vlan = -1;
                }
                if (!this.isIPv6) {
                    this.ofMatch.setDataLayerVirtualLan(vlan);
                    wildcards &= 0xFFFFFFFD;
                } else {
                    ((V6Match)this.ofMatch).setDataLayerVirtualLan(vlan, (short)0);
                }
            }
            if (match.isPresent(MatchType.DL_VLAN_PR)) {
                byte vlanPr = (Byte)match.getField(MatchType.DL_VLAN_PR).getValue();
                if (!this.isIPv6) {
                    this.ofMatch.setDataLayerVirtualLanPriorityCodePoint(vlanPr);
                    wildcards &= 0xFFEFFFFF;
                } else {
                    ((V6Match)this.ofMatch).setDataLayerVirtualLanPriorityCodePoint(vlanPr, (byte)0);
                }
            }
            if (match.isPresent(MatchType.DL_TYPE)) {
                short ethType = (Short)match.getField(MatchType.DL_TYPE).getValue();
                if (!this.isIPv6) {
                    this.ofMatch.setDataLayerType(ethType);
                    wildcards &= 0xFFFFFFEF;
                } else {
                    ((V6Match)this.ofMatch).setDataLayerType(ethType, (short)0);
                }
            }
            if (match.isPresent(MatchType.NW_TOS)) {
                byte tos = (Byte)match.getField(MatchType.NW_TOS).getValue();
                byte dscp = (byte)(tos << 2);
                if (!this.isIPv6) {
                    this.ofMatch.setNetworkTypeOfService(dscp);
                    wildcards &= 0xFFDFFFFF;
                } else {
                    ((V6Match)this.ofMatch).setNetworkTypeOfService(dscp, (byte)0);
                }
            }
            if (match.isPresent(MatchType.NW_PROTO)) {
                byte proto = (Byte)match.getField(MatchType.NW_PROTO).getValue();
                if (!this.isIPv6) {
                    this.ofMatch.setNetworkProtocol(proto);
                    wildcards &= 0xFFFFFFDF;
                } else {
                    ((V6Match)this.ofMatch).setNetworkProtocol(proto, (byte)0);
                }
            }
            if (match.isPresent(MatchType.NW_SRC)) {
                InetAddress address = (InetAddress)match.getField(MatchType.NW_SRC).getValue();
                InetAddress mask = (InetAddress)match.getField(MatchType.NW_SRC).getMask();
                if (!this.isIPv6) {
                    this.ofMatch.setNetworkSource(NetUtils.byteArray4ToInt((byte[])address.getAddress()));
                    maskLength = mask == null ? 32 : NetUtils.getSubnetMaskLength((InetAddress)mask);
                    wildcards = wildcards & 0xFFFFC0FF | 32 - maskLength << 8;
                } else {
                    ((V6Match)this.ofMatch).setNetworkSource(address, mask);
                }
            }
            if (match.isPresent(MatchType.NW_DST)) {
                InetAddress address = (InetAddress)match.getField(MatchType.NW_DST).getValue();
                InetAddress mask = (InetAddress)match.getField(MatchType.NW_DST).getMask();
                if (!this.isIPv6) {
                    this.ofMatch.setNetworkDestination(NetUtils.byteArray4ToInt((byte[])address.getAddress()));
                    maskLength = mask == null ? 32 : NetUtils.getSubnetMaskLength((InetAddress)mask);
                    wildcards = wildcards & 0xFFF03FFF | 32 - maskLength << 14;
                } else {
                    ((V6Match)this.ofMatch).setNetworkDestination(address, mask);
                }
            }
            if (match.isPresent(MatchType.TP_SRC)) {
                short port = (Short)match.getField(MatchType.TP_SRC).getValue();
                if (!this.isIPv6) {
                    this.ofMatch.setTransportSource(port);
                    wildcards &= 0xFFFFFFBF;
                } else {
                    ((V6Match)this.ofMatch).setTransportSource(port, (short)0);
                }
            }
            if (match.isPresent(MatchType.TP_DST)) {
                short port = (Short)match.getField(MatchType.TP_DST).getValue();
                if (!this.isIPv6) {
                    this.ofMatch.setTransportDestination(port);
                    wildcards &= 0xFFFFFF7F;
                } else {
                    ((V6Match)this.ofMatch).setTransportDestination(port, (short)0);
                }
            }
            if (!this.isIPv6) {
                this.ofMatch.setWildcards(U32.t((long)wildcards));
            }
        }
        logger.trace("SAL Match: {} Openflow Match: {}", (Object)this.flow.getMatch(), (Object)this.ofMatch);
        return this.ofMatch;
    }

    public List<OFAction> getOFActions() {
        if (this.actionsList == null) {
            this.actionsList = new ArrayList<OFAction>();
            for (Action action : this.flow.getActions()) {
                OFActionOutput ofAction;
                OFActionOutput ofAction2;
                Output a;
                if (action.getType() == ActionType.OUTPUT) {
                    a = (Output)action;
                    ofAction2 = new OFActionOutput();
                    ofAction2.setMaxLength((short)-1);
                    ofAction2.setPort(PortConverter.toOFPort(a.getPort()));
                    this.actionsList.add((OFAction)ofAction2);
                    this.actionsLength += OFActionOutput.MINIMUM_LENGTH;
                    continue;
                }
                if (action.getType() == ActionType.ENQUEUE) {
                    a = (Enqueue)action;
                    ofAction2 = new OFActionEnqueue();
                    ofAction2.setPort(PortConverter.toOFPort(a.getPort()));
                    ofAction2.setQueueId(a.getQueue());
                    this.actionsList.add((OFAction)ofAction2);
                    this.actionsLength += OFActionEnqueue.MINIMUM_LENGTH;
                    continue;
                }
                if (action.getType() == ActionType.DROP) continue;
                if (action.getType() == ActionType.LOOPBACK) {
                    ofAction = new OFActionOutput();
                    ofAction.setPort(OFPort.OFPP_IN_PORT.getValue());
                    this.actionsList.add((OFAction)ofAction);
                    this.actionsLength += OFActionOutput.MINIMUM_LENGTH;
                    continue;
                }
                if (action.getType() == ActionType.FLOOD) {
                    ofAction = new OFActionOutput();
                    ofAction.setPort(OFPort.OFPP_FLOOD.getValue());
                    this.actionsList.add((OFAction)ofAction);
                    this.actionsLength += OFActionOutput.MINIMUM_LENGTH;
                    continue;
                }
                if (action.getType() == ActionType.FLOOD_ALL) {
                    ofAction = new OFActionOutput();
                    ofAction.setPort(OFPort.OFPP_ALL.getValue());
                    this.actionsList.add((OFAction)ofAction);
                    this.actionsLength += OFActionOutput.MINIMUM_LENGTH;
                    continue;
                }
                if (action.getType() == ActionType.CONTROLLER) {
                    ofAction = new OFActionOutput();
                    ofAction.setPort(OFPort.OFPP_CONTROLLER.getValue());
                    ofAction.setMaxLength((short)-1);
                    this.actionsList.add((OFAction)ofAction);
                    this.actionsLength += OFActionOutput.MINIMUM_LENGTH;
                    continue;
                }
                if (action.getType() == ActionType.SW_PATH) {
                    ofAction = new OFActionOutput();
                    ofAction.setPort(OFPort.OFPP_LOCAL.getValue());
                    this.actionsList.add((OFAction)ofAction);
                    this.actionsLength += OFActionOutput.MINIMUM_LENGTH;
                    continue;
                }
                if (action.getType() == ActionType.HW_PATH) {
                    ofAction = new OFActionOutput();
                    ofAction.setPort(OFPort.OFPP_NORMAL.getValue());
                    this.actionsList.add((OFAction)ofAction);
                    this.actionsLength += OFActionOutput.MINIMUM_LENGTH;
                    continue;
                }
                if (action.getType() == ActionType.SET_VLAN_ID) {
                    a = (SetVlanId)action;
                    ofAction2 = new OFActionVirtualLanIdentifier();
                    ofAction2.setVirtualLanIdentifier((short)a.getVlanId());
                    this.actionsList.add((OFAction)ofAction2);
                    this.actionsLength += OFActionVirtualLanIdentifier.MINIMUM_LENGTH;
                    continue;
                }
                if (action.getType() == ActionType.SET_VLAN_PCP) {
                    a = (SetVlanPcp)action;
                    ofAction2 = new OFActionVirtualLanPriorityCodePoint();
                    ofAction2.setVirtualLanPriorityCodePoint(Integer.valueOf(a.getPcp()).byteValue());
                    this.actionsList.add((OFAction)ofAction2);
                    this.actionsLength += OFActionVirtualLanPriorityCodePoint.MINIMUM_LENGTH;
                    continue;
                }
                if (action.getType() == ActionType.POP_VLAN) {
                    ofAction = new OFActionStripVirtualLan();
                    this.actionsList.add((OFAction)ofAction);
                    this.actionsLength += OFActionStripVirtualLan.MINIMUM_LENGTH;
                    continue;
                }
                if (action.getType() == ActionType.SET_DL_SRC) {
                    a = (SetDlSrc)action;
                    ofAction2 = new OFActionDataLayerSource();
                    ofAction2.setDataLayerAddress(a.getDlAddress());
                    this.actionsList.add((OFAction)ofAction2);
                    this.actionsLength += OFActionDataLayer.MINIMUM_LENGTH;
                    continue;
                }
                if (action.getType() == ActionType.SET_DL_DST) {
                    a = (SetDlDst)action;
                    ofAction2 = new OFActionDataLayerDestination();
                    ofAction2.setDataLayerAddress(a.getDlAddress());
                    this.actionsList.add((OFAction)ofAction2);
                    this.actionsLength += OFActionDataLayer.MINIMUM_LENGTH;
                    continue;
                }
                if (action.getType() == ActionType.SET_NW_SRC) {
                    a = (SetNwSrc)action;
                    ofAction2 = new OFActionNetworkLayerSource();
                    ofAction2.setNetworkAddress(NetUtils.byteArray4ToInt((byte[])a.getAddress().getAddress()));
                    this.actionsList.add((OFAction)ofAction2);
                    this.actionsLength += OFActionNetworkLayerAddress.MINIMUM_LENGTH;
                    continue;
                }
                if (action.getType() == ActionType.SET_NW_DST) {
                    a = (SetNwDst)action;
                    ofAction2 = new OFActionNetworkLayerDestination();
                    ofAction2.setNetworkAddress(NetUtils.byteArray4ToInt((byte[])a.getAddress().getAddress()));
                    this.actionsList.add((OFAction)ofAction2);
                    this.actionsLength += OFActionNetworkLayerAddress.MINIMUM_LENGTH;
                    continue;
                }
                if (action.getType() == ActionType.SET_NW_TOS) {
                    a = (SetNwTos)action;
                    ofAction2 = new OFActionNetworkTypeOfService();
                    ofAction2.setNetworkTypeOfService(Integer.valueOf(a.getNwTos()).byteValue());
                    this.actionsList.add((OFAction)ofAction2);
                    this.actionsLength += OFActionNetworkTypeOfService.MINIMUM_LENGTH;
                    continue;
                }
                if (action.getType() == ActionType.SET_TP_SRC) {
                    a = (SetTpSrc)action;
                    ofAction2 = new OFActionTransportLayerSource();
                    ofAction2.setTransportPort(Integer.valueOf(a.getPort()).shortValue());
                    this.actionsList.add((OFAction)ofAction2);
                    this.actionsLength += OFActionTransportLayer.MINIMUM_LENGTH;
                    continue;
                }
                if (action.getType() == ActionType.SET_TP_DST) {
                    a = (SetTpDst)action;
                    ofAction2 = new OFActionTransportLayerDestination();
                    ofAction2.setTransportPort(Integer.valueOf(a.getPort()).shortValue());
                    this.actionsList.add((OFAction)ofAction2);
                    this.actionsLength += OFActionTransportLayer.MINIMUM_LENGTH;
                    continue;
                }
                if (action.getType() != ActionType.SET_NEXT_HOP) continue;
                logger.warn("Unsupported action: {}", (Object)action);
            }
        }
        logger.trace("SAL Actions: {} Openflow Actions: {}", (Object)this.flow.getActions(), this.actionsList);
        return this.actionsList;
    }

    public OFMessage getOFFlowMod(short command, OFPort port) {
        V6FlowMod fm;
        V6FlowMod v6FlowMod = fm = this.isIPv6 ? new V6FlowMod() : new OFFlowMod();
        if (this.ofMatch == null) {
            this.getOFMatch();
        }
        if (this.actionsList == null) {
            this.getOFActions();
        }
        if (!this.isIPv6) {
            ((OFFlowMod)fm).setMatch(this.ofMatch);
            ((OFFlowMod)fm).setActions(this.actionsList);
            ((OFFlowMod)fm).setPriority(this.flow.getPriority());
            ((OFFlowMod)fm).setCookie(this.flow.getId());
            ((OFFlowMod)fm).setBufferId(OFPacketOut.BUFFER_ID_NONE);
            ((OFFlowMod)fm).setLength(U16.t((int)(OFFlowMod.MINIMUM_LENGTH + this.actionsLength)));
            ((OFFlowMod)fm).setIdleTimeout(this.flow.getIdleTimeout());
            ((OFFlowMod)fm).setHardTimeout(this.flow.getHardTimeout());
            ((OFFlowMod)fm).setCommand(command);
            if (port != null) {
                ((OFFlowMod)fm).setOutPort(port);
            }
            if (command == 0 || command == 1 || command == 2) {
                ((OFFlowMod)fm).setFlags((short)1);
            }
        } else {
            fm.setVendor();
            fm.setMatch((V6Match)this.ofMatch);
            fm.setActions(this.actionsList);
            fm.setPriority(this.flow.getPriority());
            fm.setCookie(this.flow.getId());
            fm.setLength(U16.t((int)(OFVendor.MINIMUM_LENGTH + ((V6Match)this.ofMatch).getIPv6ExtMinHdrLen() + ((V6Match)this.ofMatch).getIPv6MatchLen() + ((V6Match)this.ofMatch).getPadSize() + this.actionsLength)));
            fm.setIdleTimeout(this.flow.getIdleTimeout());
            fm.setHardTimeout(this.flow.getHardTimeout());
            fm.setCommand(command);
            if (port != null) {
                fm.setOutPort(port);
            }
            if (command == 0 || command == 1 || command == 2) {
                fm.setFlags((short)1);
            }
        }
        logger.trace("Openflow Match: {} Openflow Actions: {}", (Object)this.ofMatch, this.actionsList);
        logger.trace("Openflow Mod Message: {}", (Object)fm);
        return fm;
    }

    public Flow getFlow(Node node) {
        if (this.flow == null) {
            Match salMatch = new Match();
            if (this.ofMatch != null) {
                if (!this.isIPv6) {
                    short vlan;
                    if (this.ofMatch.getInputPort() != 0 && this.ofMatch.getInputPort() != OFPort.OFPP_LOCAL.getValue()) {
                        salMatch.setField(new MatchField(MatchType.IN_PORT, (Object)NodeConnectorCreator.createNodeConnector((Object)this.ofMatch.getInputPort(), (Node)node)));
                    }
                    if (this.ofMatch.getDataLayerSource() != null && !NetUtils.isZeroMAC((byte[])this.ofMatch.getDataLayerSource())) {
                        byte[] srcMac = this.ofMatch.getDataLayerSource();
                        salMatch.setField(new MatchField(MatchType.DL_SRC, srcMac.clone()));
                    }
                    if (this.ofMatch.getDataLayerDestination() != null && !NetUtils.isZeroMAC((byte[])this.ofMatch.getDataLayerDestination())) {
                        byte[] dstMac = this.ofMatch.getDataLayerDestination();
                        salMatch.setField(new MatchField(MatchType.DL_DST, dstMac.clone()));
                    }
                    if (this.ofMatch.getDataLayerType() != 0) {
                        salMatch.setField(new MatchField(MatchType.DL_TYPE, (Object)this.ofMatch.getDataLayerType()));
                    }
                    if ((vlan = this.ofMatch.getDataLayerVirtualLan()) != 0) {
                        if (vlan == -1) {
                            vlan = 0;
                        }
                        salMatch.setField(new MatchField(MatchType.DL_VLAN, (Object)vlan));
                    }
                    if (this.ofMatch.getDataLayerVirtualLanPriorityCodePoint() != 0) {
                        salMatch.setField(MatchType.DL_VLAN_PR, (Object)this.ofMatch.getDataLayerVirtualLanPriorityCodePoint());
                    }
                    if (this.ofMatch.getNetworkSource() != 0) {
                        salMatch.setField(MatchType.NW_SRC, (Object)NetUtils.getInetAddress((int)this.ofMatch.getNetworkSource()), (Object)NetUtils.getInetNetworkMask((int)this.ofMatch.getNetworkSourceMaskLen(), (boolean)false));
                    }
                    if (this.ofMatch.getNetworkDestination() != 0) {
                        salMatch.setField(MatchType.NW_DST, (Object)NetUtils.getInetAddress((int)this.ofMatch.getNetworkDestination()), (Object)NetUtils.getInetNetworkMask((int)this.ofMatch.getNetworkDestinationMaskLen(), (boolean)false));
                    }
                    if (this.ofMatch.getNetworkTypeOfService() != 0) {
                        int dscp = NetUtils.getUnsignedByte((byte)this.ofMatch.getNetworkTypeOfService());
                        byte tos = (byte)(dscp >> 2);
                        salMatch.setField(MatchType.NW_TOS, (Object)tos);
                    }
                    if (this.ofMatch.getNetworkProtocol() != 0) {
                        salMatch.setField(MatchType.NW_PROTO, (Object)this.ofMatch.getNetworkProtocol());
                    }
                    if (this.ofMatch.getTransportSource() != 0) {
                        salMatch.setField(MatchType.TP_SRC, (Object)this.ofMatch.getTransportSource());
                    }
                    if (this.ofMatch.getTransportDestination() != 0) {
                        salMatch.setField(MatchType.TP_DST, (Object)this.ofMatch.getTransportDestination());
                    }
                } else {
                    short vlan;
                    V6Match v6Match = (V6Match)this.ofMatch;
                    if (v6Match.getInputPort() != 0 && v6Match.getInputPort() != OFPort.OFPP_LOCAL.getValue()) {
                        salMatch.setField(new MatchField(MatchType.IN_PORT, (Object)NodeConnectorCreator.createOFNodeConnector((Short)v6Match.getInputPort(), (Node)node)));
                    }
                    if (v6Match.getDataLayerSource() != null && !NetUtils.isZeroMAC((byte[])this.ofMatch.getDataLayerSource())) {
                        byte[] srcMac = v6Match.getDataLayerSource();
                        salMatch.setField(new MatchField(MatchType.DL_SRC, srcMac.clone()));
                    }
                    if (v6Match.getDataLayerDestination() != null && !NetUtils.isZeroMAC((byte[])this.ofMatch.getDataLayerDestination())) {
                        byte[] dstMac = v6Match.getDataLayerDestination();
                        salMatch.setField(new MatchField(MatchType.DL_DST, dstMac.clone()));
                    }
                    if (v6Match.getDataLayerType() != 0) {
                        salMatch.setField(new MatchField(MatchType.DL_TYPE, (Object)v6Match.getDataLayerType()));
                    }
                    if ((vlan = v6Match.getDataLayerVirtualLan()) != 0) {
                        if (vlan == -1) {
                            vlan = 0;
                        }
                        salMatch.setField(new MatchField(MatchType.DL_VLAN, (Object)vlan));
                    }
                    if (v6Match.getDataLayerVirtualLanPriorityCodePoint() != 0) {
                        salMatch.setField(MatchType.DL_VLAN_PR, (Object)v6Match.getDataLayerVirtualLanPriorityCodePoint());
                    }
                    if (v6Match.getNetworkSrc() != null) {
                        salMatch.setField(MatchType.NW_SRC, (Object)v6Match.getNetworkSrc(), (Object)v6Match.getNetworkSourceMask());
                    } else if (v6Match.getNetworkSource() != 0) {
                        salMatch.setField(MatchType.NW_SRC, (Object)NetUtils.getInetAddress((int)v6Match.getNetworkSource()), (Object)NetUtils.getInetNetworkMask((int)v6Match.getNetworkSourceMaskLen(), (boolean)false));
                    }
                    if (v6Match.getNetworkDest() != null) {
                        salMatch.setField(MatchType.NW_DST, (Object)v6Match.getNetworkDest(), (Object)v6Match.getNetworkDestinationMask());
                    } else if (v6Match.getNetworkDestination() != 0) {
                        salMatch.setField(MatchType.NW_DST, (Object)NetUtils.getInetAddress((int)v6Match.getNetworkDestination()), (Object)NetUtils.getInetNetworkMask((int)v6Match.getNetworkDestinationMaskLen(), (boolean)false));
                    }
                    if (v6Match.getNetworkTypeOfService() != 0) {
                        int dscp = NetUtils.getUnsignedByte((byte)v6Match.getNetworkTypeOfService());
                        byte tos = (byte)(dscp >> 2);
                        salMatch.setField(MatchType.NW_TOS, (Object)tos);
                    }
                    if (v6Match.getNetworkProtocol() != 0) {
                        salMatch.setField(MatchType.NW_PROTO, (Object)v6Match.getNetworkProtocol());
                    }
                    if (v6Match.getTransportSource() != 0) {
                        salMatch.setField(MatchType.TP_SRC, (Object)v6Match.getTransportSource());
                    }
                    if (v6Match.getTransportDestination() != 0) {
                        salMatch.setField(MatchType.TP_DST, (Object)v6Match.getTransportDestination());
                    }
                }
            }
            Object salAction = null;
            ArrayList<Object> salActionList = new ArrayList<Object>();
            if (this.actionsList == null) {
                salActionList.add(new Drop());
            } else {
                for (OFAction ofAction : this.actionsList) {
                    if (ofAction instanceof OFActionOutput) {
                        short ofPort = ((OFActionOutput)ofAction).getPort();
                        salAction = ofPort == OFPort.OFPP_CONTROLLER.getValue() ? new Controller() : (ofPort == OFPort.OFPP_NONE.getValue() ? new Drop() : (ofPort == OFPort.OFPP_IN_PORT.getValue() ? new Loopback() : (ofPort == OFPort.OFPP_FLOOD.getValue() ? new Flood() : (ofPort == OFPort.OFPP_ALL.getValue() ? new FloodAll() : (ofPort == OFPort.OFPP_LOCAL.getValue() ? new SwPath() : (ofPort == OFPort.OFPP_NORMAL.getValue() ? new HwPath() : (ofPort == OFPort.OFPP_TABLE.getValue() ? new HwPath() : new Output(NodeConnectorCreator.createOFNodeConnector((Short)ofPort, (Node)node)))))))));
                    } else if (ofAction instanceof OFActionEnqueue) {
                        salAction = new Enqueue(NodeConnectorCreator.createOFNodeConnector((Short)((OFActionEnqueue)ofAction).getPort(), (Node)node), ((OFActionEnqueue)ofAction).getQueueId());
                    } else if (ofAction instanceof OFActionVirtualLanIdentifier) {
                        salAction = new SetVlanId((int)((OFActionVirtualLanIdentifier)ofAction).getVirtualLanIdentifier());
                    } else if (ofAction instanceof OFActionStripVirtualLan) {
                        salAction = new PopVlan();
                    } else if (ofAction instanceof OFActionVirtualLanPriorityCodePoint) {
                        salAction = new SetVlanPcp((int)((OFActionVirtualLanPriorityCodePoint)ofAction).getVirtualLanPriorityCodePoint());
                    } else if (ofAction instanceof OFActionDataLayerSource) {
                        salAction = new SetDlSrc((byte[])((OFActionDataLayerSource)ofAction).getDataLayerAddress().clone());
                    } else if (ofAction instanceof OFActionDataLayerDestination) {
                        salAction = new SetDlDst((byte[])((OFActionDataLayerDestination)ofAction).getDataLayerAddress().clone());
                    } else if (ofAction instanceof OFActionNetworkLayerSource) {
                        byte[] addr = BigInteger.valueOf(((OFActionNetworkLayerSource)ofAction).getNetworkAddress()).toByteArray();
                        InetAddress ip = null;
                        try {
                            ip = InetAddress.getByAddress(addr);
                        }
                        catch (UnknownHostException e) {
                            logger.error("", (Throwable)e);
                        }
                        salAction = new SetNwSrc(ip);
                    } else if (ofAction instanceof OFActionNetworkLayerDestination) {
                        byte[] addr = BigInteger.valueOf(((OFActionNetworkLayerDestination)ofAction).getNetworkAddress()).toByteArray();
                        InetAddress ip = null;
                        try {
                            ip = InetAddress.getByAddress(addr);
                        }
                        catch (UnknownHostException e) {
                            logger.error("", (Throwable)e);
                        }
                        salAction = new SetNwDst(ip);
                    } else if (ofAction instanceof OFActionNetworkTypeOfService) {
                        salAction = new SetNwTos((int)((OFActionNetworkTypeOfService)ofAction).getNetworkTypeOfService());
                    } else if (ofAction instanceof OFActionTransportLayerSource) {
                        Short port = ((OFActionTransportLayerSource)ofAction).getTransportPort();
                        int intPort = NetUtils.getUnsignedShort((short)port);
                        salAction = new SetTpSrc(intPort);
                    } else if (ofAction instanceof OFActionTransportLayerDestination) {
                        Short port = ((OFActionTransportLayerDestination)ofAction).getTransportPort();
                        int intPort = NetUtils.getUnsignedShort((short)port);
                        salAction = new SetTpDst(intPort);
                    }
                    salActionList.add(salAction);
                }
            }
            this.flow = new Flow(salMatch, salActionList);
        }
        logger.trace("Openflow Match: {} Openflow Actions: {}", (Object)this.ofMatch, this.actionsList);
        logger.trace("SAL Flow: {}", (Object)this.flow);
        return this.flow;
    }

    public static List<Class<? extends Action>> getFlowActions(int ofActionBitmask) {
        ArrayList<Class<? extends Action>> list = new ArrayList<Class<? extends Action>>();
        for (int i = 0; i < 32; ++i) {
            int index = 1 << i;
            if ((index & ofActionBitmask) <= 0 || !actionMap.containsKey(index)) continue;
            list.add(actionMap.get(index));
        }
        list.add(Controller.class);
        list.add(SwPath.class);
        list.add(HwPath.class);
        list.add(Drop.class);
        return list;
    }
}

