/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.internal;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.opendaylight.controller.protocol_plugin.openflow.IDataPacketListen;
import org.opendaylight.controller.protocol_plugin.openflow.IDataPacketMux;
import org.opendaylight.controller.protocol_plugin.openflow.IDiscoveryListener;
import org.opendaylight.controller.protocol_plugin.openflow.IInventoryProvider;
import org.opendaylight.controller.protocol_plugin.openflow.IInventoryShimExternalListener;
import org.opendaylight.controller.protocol_plugin.openflow.core.IController;
import org.opendaylight.controller.protocol_plugin.openflow.core.ISwitch;
import org.opendaylight.controller.sal.connection.IPluginOutConnectionService;
import org.opendaylight.controller.sal.core.Config;
import org.opendaylight.controller.sal.core.ConstructionException;
import org.opendaylight.controller.sal.core.ContainerFlow;
import org.opendaylight.controller.sal.core.Edge;
import org.opendaylight.controller.sal.core.IContainerListener;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.Property;
import org.opendaylight.controller.sal.core.State;
import org.opendaylight.controller.sal.core.UpdateType;
import org.opendaylight.controller.sal.packet.Ethernet;
import org.opendaylight.controller.sal.packet.LLDP;
import org.opendaylight.controller.sal.packet.LLDPTLV;
import org.opendaylight.controller.sal.packet.LinkEncap;
import org.opendaylight.controller.sal.packet.Packet;
import org.opendaylight.controller.sal.packet.PacketResult;
import org.opendaylight.controller.sal.packet.RawPacket;
import org.opendaylight.controller.sal.utils.EtherTypes;
import org.opendaylight.controller.sal.utils.HexEncode;
import org.opendaylight.controller.sal.utils.NodeConnectorCreator;
import org.opendaylight.controller.sal.utils.NodeCreator;
import org.openflow.protocol.OFPhysicalPort;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryService
implements IInventoryShimExternalListener,
IDataPacketListen,
IContainerListener,
CommandProvider {
    private static Logger logger = LoggerFactory.getLogger(DiscoveryService.class);
    private IController controller = null;
    private IDiscoveryListener discoveryListener = null;
    private IInventoryProvider inventoryProvider = null;
    private IDataPacketMux iDataPacketMux = null;
    private List<NodeConnector> readyListHi = null;
    private List<NodeConnector> readyListLo = null;
    private List<NodeConnector> stagingList = null;
    private ConcurrentMap<NodeConnector, Integer> holdTime = null;
    private ConcurrentMap<NodeConnector, Integer> elapsedTime = null;
    private ConcurrentMap<NodeConnector, Edge> edgeMap = null;
    private ConcurrentMap<NodeConnector, Integer> agingMap = null;
    private ConcurrentMap<NodeConnector, Edge> prodMap = null;
    private Timer discoveryTimer;
    private DiscoveryTimerTask discoveryTimerTask;
    private static final long discoveryTimerTick = 2000L;
    private int discoveryTimerTickCount = 0;
    private int discoveryBatchMaxPorts;
    private int discoveryBatchRestartTicks;
    private int discoveryBatchPausePeriod = 2;
    private int discoveryBatchPauseTicks;
    private int discoveryTimeoutTicks;
    private int discoveryThresholdTicks;
    private int discoveryAgeoutTicks;
    private int discoveryConsistencyCheckMultiple = 2;
    private int discoveryConsistencyCheckTickCount;
    private int discoveryConsistencyCheckCallingTimes = 0;
    private int discoveryConsistencyCheckCorrected = 0;
    private boolean discoveryConsistencyCheckEnabled = true;
    private boolean discoveryAgingEnabled = true;
    private boolean discoverySnoopingEnabled = true;
    private List<NodeConnector> discoverySnoopingDisableList;
    private BlockingQueue<NodeConnector> transmitQ;
    private Thread transmitThread;
    private Boolean throttling = false;
    private volatile Boolean shuttingDown = false;
    private LLDPTLV chassisIdTlv;
    private LLDPTLV systemNameTlv;
    private LLDPTLV portIdTlv;
    private LLDPTLV ttlTlv;
    private LLDPTLV customTlv;
    private IPluginOutConnectionService connectionOutService;

    private RawPacket createDiscoveryPacket(NodeConnector nodeConnector) {
        String nodeId = HexEncode.longToHexString((long)((Long)nodeConnector.getNode().getID()));
        byte[] cidValue = LLDPTLV.createChassisIDTLVValue((String)nodeId);
        this.chassisIdTlv.setType(LLDPTLV.TLVType.ChassisID.getValue()).setLength((short)cidValue.length).setValue(cidValue);
        byte[] snValue = LLDPTLV.createSystemNameTLVValue((String)nodeConnector.getNode().toString());
        this.systemNameTlv.setType(LLDPTLV.TLVType.SystemName.getValue()).setLength((short)snValue.length).setValue(snValue);
        String portId = nodeConnector.getNodeConnectorIDString();
        byte[] pidValue = LLDPTLV.createPortIDTLVValue((String)portId);
        this.portIdTlv.setType(LLDPTLV.TLVType.PortID.getValue()).setLength((short)pidValue.length).setValue(pidValue);
        byte[] customValue = LLDPTLV.createCustomTLVValue((String)nodeConnector.toString());
        this.customTlv.setType(LLDPTLV.TLVType.Custom.getValue()).setLength((short)customValue.length).setValue(customValue);
        ArrayList<LLDPTLV> customList = new ArrayList<LLDPTLV>();
        customList.add(this.customTlv);
        LLDP discoveryPkt = new LLDP();
        discoveryPkt.setChassisId(this.chassisIdTlv).setPortId(this.portIdTlv).setTtl(this.ttlTlv).setSystemNameId(this.systemNameTlv).setOptionalTLVList(customList);
        RawPacket rawPkt = null;
        try {
            byte[] sourceMac = this.getSourceMACFromNodeID(nodeId);
            Ethernet ethPkt = new Ethernet();
            ethPkt.setSourceMACAddress(sourceMac).setDestinationMACAddress(LLDP.LLDPMulticastMac).setEtherType(EtherTypes.LLDP.shortValue()).setPayload((Packet)discoveryPkt);
            byte[] data = ethPkt.serialize();
            rawPkt = new RawPacket(data);
            rawPkt.setOutgoingNodeConnector(nodeConnector);
        }
        catch (ConstructionException cex) {
            logger.warn("RawPacket creation caught exception {}", (Object)cex.getMessage());
        }
        catch (Exception e) {
            logger.error("Failed to serialize the LLDP packet: " + e);
        }
        return rawPkt;
    }

    private void sendDiscoveryPacket(NodeConnector nodeConnector, RawPacket outPkt) {
        if (nodeConnector == null) {
            logger.debug("Can not send discovery packet out since nodeConnector is null");
            return;
        }
        if (!this.connectionOutService.isLocal(nodeConnector.getNode())) {
            logger.debug("Discoery packets will not be sent to {} in a non-master controller", (Object)nodeConnector.toString());
            return;
        }
        if (outPkt == null) {
            logger.debug("Can not send discovery packet out since outPkt is null");
            return;
        }
        long sid = (Long)nodeConnector.getNode().getID();
        ISwitch sw = this.controller.getSwitches().get(sid);
        if (sw == null) {
            logger.debug("Can not send discovery packet out since switch {} is null", (Object)sid);
            return;
        }
        if (!sw.isOperational()) {
            logger.debug("Can not send discovery packet out since switch {} is not operational", (Object)sw);
            return;
        }
        if (this.iDataPacketMux == null) {
            logger.debug("Can not send discovery packet out since DataPacket service is not available");
            return;
        }
        logger.trace("Sending topology discovery pkt thru {}", (Object)nodeConnector);
        this.iDataPacketMux.transmitDataPacket(outPkt);
    }

    @Override
    public PacketResult receiveDataPacket(RawPacket inPkt) {
        NodeConnector dst;
        if (inPkt == null) {
            logger.debug("Ignoring null packet");
            return PacketResult.IGNORED;
        }
        byte[] data = inPkt.getPacketData();
        if (data.length <= 0) {
            logger.trace("Ignoring zero length packet");
            return PacketResult.IGNORED;
        }
        if (!inPkt.getEncap().equals((Object)LinkEncap.ETHERNET)) {
            logger.trace("Ignoring non ethernet packet");
            return PacketResult.IGNORED;
        }
        NodeConnector nodeConnector = inPkt.getIncomingNodeConnector();
        if (((Short)nodeConnector.getID()).equals(NodeConnector.SPECIALNODECONNECTORID)) {
            logger.trace("Ignoring ethernet packet received on special port: " + inPkt.getIncomingNodeConnector().toString());
            return PacketResult.IGNORED;
        }
        if (!this.connectionOutService.isLocal(nodeConnector.getNode())) {
            logger.debug("Discoery packets will not be processed from {} in a non-master controller", (Object)nodeConnector.toString());
            return PacketResult.IGNORED;
        }
        Ethernet ethPkt = new Ethernet();
        try {
            ethPkt.deserialize(data, 0, data.length * 8);
        }
        catch (Exception e) {
            logger.warn("Failed to decode LLDP packet from {}: {}", (Object)inPkt.getIncomingNodeConnector(), (Object)e);
            return PacketResult.IGNORED;
        }
        if (ethPkt.getPayload() instanceof LLDP && this.isEnabled(dst = inPkt.getIncomingNodeConnector())) {
            if (!this.processDiscoveryPacket(dst, ethPkt)) {
                this.snoopDiscoveryPacket(dst, ethPkt);
            }
            return PacketResult.CONSUME;
        }
        return PacketResult.IGNORED;
    }

    private void snoopDiscoveryPacket(NodeConnector dstNodeConnector, Ethernet ethPkt) {
        if (!this.discoverySnoopingEnabled || this.discoverySnoopingDisableList.contains(dstNodeConnector)) {
            logger.trace("Discarded received discovery packet on {} since snooping is turned off", (Object)dstNodeConnector);
            return;
        }
        if (dstNodeConnector == null || ethPkt == null) {
            logger.trace("Quit snooping discovery packet: Null node connector or packet");
            return;
        }
        LLDP lldp = (LLDP)ethPkt.getPayload();
        try {
            String nodeId = LLDPTLV.getHexStringValue((byte[])lldp.getChassisId().getValue(), (int)lldp.getChassisId().getLength());
            String portId = LLDPTLV.getStringValue((byte[])lldp.getPortId().getValue(), (int)lldp.getPortId().getLength());
            byte[] systemNameBytes = null;
            for (LLDPTLV lldptlv : lldp.getOptionalTLVList()) {
                if (lldptlv.getType() != LLDPTLV.TLVType.SystemName.getValue()) continue;
                systemNameBytes = lldptlv.getValue();
                break;
            }
            String nodeName = systemNameBytes == null ? nodeId : new String(systemNameBytes, Charset.defaultCharset());
            Node srcNode = new Node(Node.NodeIDType.PRODUCTION, (Object)nodeName);
            NodeConnector srcNodeConnector = NodeConnectorCreator.createNodeConnector((String)NodeConnector.NodeConnectorIDType.PRODUCTION, (Object)portId, (Node)srcNode);
            Edge edge = null;
            Set<Property> props = null;
            edge = new Edge(srcNodeConnector, dstNodeConnector);
            props = this.getProps(dstNodeConnector);
            this.updateProdEdge(edge, props);
        }
        catch (Exception e) {
            logger.warn("Caught exception ", (Throwable)e);
        }
    }

    private boolean processDiscoveryPacket(NodeConnector dstNodeConnector, Ethernet ethPkt) {
        if (dstNodeConnector == null || ethPkt == null) {
            logger.trace("Ignoring processing of discovery packet: Null node connector or packet");
            return false;
        }
        logger.trace("Handle discovery packet {} from {}", (Object)ethPkt, (Object)dstNodeConnector);
        LLDP lldp = (LLDP)ethPkt.getPayload();
        List optionalTLVList = lldp.getOptionalTLVList();
        if (optionalTLVList == null) {
            logger.warn("The discovery packet with null custom option from {}", (Object)dstNodeConnector);
            return false;
        }
        Node srcNode = null;
        NodeConnector srcNodeConnector = null;
        for (LLDPTLV lldptlv : lldp.getOptionalTLVList()) {
            String ncString;
            if (lldptlv.getType() != LLDPTLV.TLVType.Custom.getValue() || (srcNodeConnector = NodeConnector.fromString((String)(ncString = LLDPTLV.getCustomString((byte[])lldptlv.getValue(), (int)lldptlv.getLength())))) == null) continue;
            srcNode = srcNodeConnector.getNode();
        }
        if (srcNode == null || srcNodeConnector == null) {
            logger.trace("Received non-controller generated discovery packet from {}", (Object)dstNodeConnector);
            return false;
        }
        Edge edge = null;
        Set<Property> props = null;
        try {
            edge = new Edge(srcNodeConnector, dstNodeConnector);
            props = this.getProps(dstNodeConnector);
        }
        catch (ConstructionException e) {
            logger.error("Caught exception ", (Throwable)e);
        }
        this.addEdge(edge, props);
        logger.trace("Received discovery packet for Edge {}", (Object)edge);
        return true;
    }

    public Map<String, Property> getPropMap(NodeConnector nodeConnector) {
        if (nodeConnector == null) {
            return null;
        }
        if (this.inventoryProvider == null) {
            return null;
        }
        ConcurrentMap props = this.inventoryProvider.getNodeConnectorProps(false);
        if (props == null) {
            return null;
        }
        return (Map)props.get(nodeConnector);
    }

    public Property getProp(NodeConnector nodeConnector, String propName) {
        Map<String, Property> propMap = this.getPropMap(nodeConnector);
        if (propMap == null) {
            return null;
        }
        Property prop = propMap.get(propName);
        return prop;
    }

    public Set<Property> getProps(NodeConnector nodeConnector) {
        Map<String, Property> propMap = this.getPropMap(nodeConnector);
        if (propMap == null) {
            return null;
        }
        HashSet<Property> props = new HashSet<Property>(propMap.values());
        return props;
    }

    private boolean isEnabled(NodeConnector nodeConnector) {
        if (nodeConnector == null) {
            return false;
        }
        Config config = (Config)this.getProp(nodeConnector, "config");
        State state = (State)this.getProp(nodeConnector, "state");
        return config != null && config.getValue() == 1 && state != null && state.getValue() == 1;
    }

    private boolean isTracked(NodeConnector nodeConnector) {
        if (this.readyListHi.contains(nodeConnector)) {
            return true;
        }
        if (this.readyListLo.contains(nodeConnector)) {
            return true;
        }
        if (this.holdTime.keySet().contains(nodeConnector)) {
            return true;
        }
        return this.stagingList.contains(nodeConnector);
    }

    private Set<NodeConnector> getWorkingSet() {
        HashSet<NodeConnector> workingSet = new HashSet<NodeConnector>();
        HashSet<NodeConnector> removeSet = new HashSet<NodeConnector>();
        for (NodeConnector nodeConnector : this.readyListHi) {
            if (this.isOverLimit(workingSet.size()).booleanValue()) break;
            workingSet.add(nodeConnector);
            removeSet.add(nodeConnector);
            this.elapsedTime.put(nodeConnector, 0);
        }
        this.readyListHi.removeAll(removeSet);
        removeSet.clear();
        for (NodeConnector nodeConnector : this.readyListLo) {
            if (this.isOverLimit(workingSet.size()).booleanValue()) break;
            workingSet.add(nodeConnector);
            removeSet.add(nodeConnector);
        }
        this.readyListLo.removeAll(removeSet);
        return workingSet;
    }

    private Boolean isOverLimit(int size) {
        return size >= this.discoveryBatchMaxPorts && this.throttling == false;
    }

    private void addDiscovery() {
        Map<Long, ISwitch> switches = this.controller.getSwitches();
        Set<Long> sidSet = switches.keySet();
        if (sidSet == null) {
            return;
        }
        for (Long sid : sidSet) {
            Node node = NodeCreator.createOFNode((Long)sid);
            this.addDiscovery(node);
        }
    }

    private void addDiscovery(Node node) {
        Map<Long, ISwitch> switches = this.controller.getSwitches();
        ISwitch sw = switches.get(node.getID());
        if (sw == null) {
            return;
        }
        List<OFPhysicalPort> ports = sw.getEnabledPorts();
        for (OFPhysicalPort port : ports) {
            NodeConnector nodeConnector = NodeConnectorCreator.createOFNodeConnector((Short)port.getPortNumber(), (Node)node);
            if (this.readyListHi.contains(nodeConnector)) continue;
            this.readyListHi.add(nodeConnector);
        }
    }

    private void addDiscovery(NodeConnector nodeConnector) {
        if (this.isTracked(nodeConnector)) {
            return;
        }
        this.readyListHi.add(nodeConnector);
    }

    private void removeNodeConnector(NodeConnector nodeConnector) {
        this.readyListLo.remove(nodeConnector);
        this.readyListHi.remove(nodeConnector);
        this.stagingList.remove(nodeConnector);
        this.holdTime.remove(nodeConnector);
        this.elapsedTime.remove(nodeConnector);
    }

    private Set<NodeConnector> getRemoveSet(Collection<NodeConnector> c, Node node) {
        HashSet<NodeConnector> removeSet = new HashSet<NodeConnector>();
        if (c == null) {
            return removeSet;
        }
        for (NodeConnector nodeConnector : c) {
            if (!node.equals((Object)nodeConnector.getNode())) continue;
            removeSet.add(nodeConnector);
        }
        return removeSet;
    }

    private void removeDiscovery(Node node) {
        Set<NodeConnector> removeSet = this.getRemoveSet(this.edgeMap.keySet(), node);
        for (NodeConnector nodeConnector : removeSet) {
            Edge edge2;
            NodeConnector peerConnector = null;
            Edge edge1 = (Edge)this.edgeMap.get(nodeConnector);
            if (edge1 != null && (edge2 = (Edge)this.edgeMap.get(edge1.getTailNodeConnector())) != null && node.equals((Object)edge2.getTailNodeConnector().getNode())) {
                peerConnector = edge2.getHeadNodeConnector();
            }
            this.removeEdge(nodeConnector, false);
            this.removeEdge(peerConnector, this.isEnabled(peerConnector));
        }
        removeSet = this.getRemoveSet(this.prodMap.keySet(), node);
        for (NodeConnector nodeConnector : removeSet) {
            this.removeProdEdge(nodeConnector);
        }
        removeSet = this.getRemoveSet(this.readyListHi, node);
        this.readyListHi.removeAll(removeSet);
        removeSet = this.getRemoveSet(this.readyListLo, node);
        this.readyListLo.removeAll(removeSet);
        removeSet = this.getRemoveSet(this.stagingList, node);
        this.stagingList.removeAll(removeSet);
        removeSet = this.getRemoveSet(this.holdTime.keySet(), node);
        for (NodeConnector nodeConnector : removeSet) {
            this.holdTime.remove(nodeConnector);
        }
        removeSet = this.getRemoveSet(this.elapsedTime.keySet(), node);
        for (NodeConnector nodeConnector : removeSet) {
            this.elapsedTime.remove(nodeConnector);
        }
    }

    private void removeDiscovery(NodeConnector nodeConnector) {
        this.removeNodeConnector(nodeConnector);
        this.removeEdge(nodeConnector, false);
        this.removeProdEdge(nodeConnector);
    }

    private void checkTimeout() {
        int ticks;
        HashSet<NodeConnector> removeSet = new HashSet<NodeConnector>();
        Set monitorSet = this.holdTime.keySet();
        if (monitorSet != null) {
            for (NodeConnector nodeConnector : monitorSet) {
                ticks = (Integer)this.holdTime.get(nodeConnector);
                this.holdTime.put(nodeConnector, ++ticks);
                if (ticks < this.discoveryTimeoutTicks) continue;
                removeSet.add(nodeConnector);
                logger.trace("Discovery timeout {}", (Object)nodeConnector);
            }
        }
        for (NodeConnector nodeConnector : removeSet) {
            this.removeEdge(nodeConnector);
        }
        HashSet<NodeConnector> retrySet = new HashSet<NodeConnector>();
        Set ncSet = this.elapsedTime.keySet();
        if (ncSet != null && ncSet.size() > 0) {
            for (NodeConnector nodeConnector : ncSet) {
                ticks = (Integer)this.elapsedTime.get(nodeConnector);
                this.elapsedTime.put(nodeConnector, ++ticks);
                if (ticks < this.discoveryThresholdTicks) continue;
                retrySet.add(nodeConnector);
            }
            for (NodeConnector nodeConnector : retrySet) {
                this.elapsedTime.remove(nodeConnector);
                if (!this.connectionOutService.isLocal(nodeConnector.getNode())) continue;
                this.transmitQ.add(nodeConnector);
            }
        }
    }

    private void checkAging() {
        if (!this.discoveryAgingEnabled) {
            return;
        }
        HashSet<NodeConnector> removeSet = new HashSet<NodeConnector>();
        Set agingSet = this.agingMap.keySet();
        if (agingSet != null) {
            for (NodeConnector nodeConnector : agingSet) {
                int ticks = (Integer)this.agingMap.get(nodeConnector);
                this.agingMap.put(nodeConnector, ++ticks);
                if (ticks <= this.discoveryAgeoutTicks) continue;
                removeSet.add(nodeConnector);
                logger.trace("Discovery age out {}", (Object)nodeConnector);
            }
        }
        for (NodeConnector nodeConnector : removeSet) {
            this.removeProdEdge(nodeConnector);
        }
    }

    private void doDiscovery() {
        if (++this.discoveryTimerTickCount <= this.discoveryBatchPauseTicks) {
            for (NodeConnector nodeConnector : this.getWorkingSet()) {
                if (!this.connectionOutService.isLocal(nodeConnector.getNode())) continue;
                this.transmitQ.add(nodeConnector);
                if (this.stagingList.contains(nodeConnector)) continue;
                this.stagingList.add(nodeConnector);
            }
        } else if (this.discoveryTimerTickCount >= this.discoveryBatchRestartTicks) {
            this.discoveryTimerTickCount = 0;
            for (NodeConnector nodeConnector : this.stagingList) {
                if (this.readyListLo.contains(nodeConnector)) continue;
                this.readyListLo.add(nodeConnector);
            }
            this.stagingList.removeAll(this.readyListLo);
        }
    }

    private void doConsistencyCheck() {
        if (!this.discoveryConsistencyCheckEnabled) {
            return;
        }
        if (++this.discoveryConsistencyCheckTickCount % this.getDiscoveryConsistencyCheckInterval() != 0) {
            return;
        }
        ++this.discoveryConsistencyCheckCallingTimes;
        HashSet<NodeConnector> removeSet = new HashSet<NodeConnector>();
        Set ncSet = this.edgeMap.keySet();
        if (ncSet == null) {
            return;
        }
        for (NodeConnector nodeConnector : ncSet) {
            if (!this.isEnabled(nodeConnector)) {
                removeSet.add(nodeConnector);
                ++this.discoveryConsistencyCheckCorrected;
                logger.debug("ConsistencyChecker: remove disabled {}", (Object)nodeConnector);
                continue;
            }
            if (this.isTracked(nodeConnector)) continue;
            this.stagingList.add(nodeConnector);
            ++this.discoveryConsistencyCheckCorrected;
            logger.debug("ConsistencyChecker: add back untracked {}", (Object)nodeConnector);
        }
        for (NodeConnector nodeConnector : removeSet) {
            this.removeEdge(nodeConnector, false);
        }
        removeSet.clear();
        for (NodeConnector nodeConnector : this.stagingList) {
            if (this.isEnabled(nodeConnector)) continue;
            removeSet.add(nodeConnector);
            ++this.discoveryConsistencyCheckCorrected;
            logger.debug("ConsistencyChecker: remove disabled {}", (Object)nodeConnector);
        }
        this.stagingList.removeAll(removeSet);
        Map<Long, ISwitch> switches = this.controller.getSwitches();
        for (ISwitch sw : switches.values()) {
            for (OFPhysicalPort port : sw.getEnabledPorts()) {
                Node node = NodeCreator.createOFNode((Long)sw.getId());
                NodeConnector nodeConnector = NodeConnectorCreator.createOFNodeConnector((Short)port.getPortNumber(), (Node)node);
                if (this.isTracked(nodeConnector)) continue;
                this.stagingList.add(nodeConnector);
                ++this.discoveryConsistencyCheckCorrected;
                logger.debug("ConsistencyChecker: add back untracked {}", (Object)nodeConnector);
            }
        }
    }

    private void addEdge(Edge edge, Set<Property> props) {
        if (edge == null) {
            return;
        }
        NodeConnector src = edge.getTailNodeConnector();
        NodeConnector dst = edge.getHeadNodeConnector();
        if (!src.getType().equals(NodeConnector.NodeConnectorIDType.PRODUCTION)) {
            this.holdTime.put(dst, 0);
        } else {
            this.agingMap.put(dst, 0);
        }
        this.elapsedTime.remove(src);
        if (!(this.edgeMap.containsKey(dst) || this.readyListHi.contains(dst) || this.elapsedTime.keySet().contains(dst))) {
            this.moveToReadyListHi(dst);
        }
        this.updateEdge(edge, UpdateType.ADDED, props);
        logger.trace("Add edge {}", (Object)edge);
    }

    private void updateProdEdge(Edge edge, Set<Property> props) {
        NodeConnector edgePort = edge.getHeadNodeConnector();
        if (this.edgeMap.get(edgePort) != null) {
            logger.trace("Discarded edge {} since there is an existing OF link {}", (Object)edge, this.edgeMap.get(edgePort));
            return;
        }
        Edge oldEdge = (Edge)this.prodMap.get(edgePort);
        if (oldEdge == null) {
            this.addEdge(edge, props);
        } else if (!edge.equals((Object)oldEdge)) {
            this.removeProdEdge(oldEdge.getHeadNodeConnector());
            this.addEdge(edge, props);
        } else {
            NodeConnector dst = edge.getHeadNodeConnector();
            this.agingMap.put(dst, 0);
        }
    }

    private void removeProdEdge(NodeConnector edgePort) {
        this.agingMap.remove(edgePort);
        Edge edge = null;
        Set prodKeySet = this.prodMap.keySet();
        if (prodKeySet != null && prodKeySet.contains(edgePort)) {
            edge = (Edge)this.prodMap.get(edgePort);
            this.prodMap.remove(edgePort);
        }
        if (this.discoveryListener != null) {
            this.discoveryListener.notifyEdge(edge, UpdateType.REMOVED, null);
        }
        logger.trace("Remove edge {}", edge);
    }

    private void removeEdge(NodeConnector nodeConnector, boolean stillEnabled) {
        if (nodeConnector == null) {
            return;
        }
        this.removeNodeConnector(nodeConnector);
        if (stillEnabled) {
            this.stagingList.add(nodeConnector);
        }
        Edge edge = null;
        Set edgeKeySet = this.edgeMap.keySet();
        if (edgeKeySet != null && edgeKeySet.contains(nodeConnector)) {
            edge = (Edge)this.edgeMap.get(nodeConnector);
            this.edgeMap.remove(nodeConnector);
        }
        if (this.discoveryListener != null) {
            this.discoveryListener.notifyEdge(edge, UpdateType.REMOVED, null);
        }
        logger.trace("Remove {}", (Object)nodeConnector);
    }

    private void removeEdge(NodeConnector nodeConnector) {
        this.removeEdge(nodeConnector, this.isEnabled(nodeConnector));
    }

    private void updateEdge(Edge edge, UpdateType type, Set<Property> props) {
        if (this.discoveryListener == null) {
            return;
        }
        this.discoveryListener.notifyEdge(edge, type, props);
        NodeConnector src = edge.getTailNodeConnector();
        NodeConnector dst = edge.getHeadNodeConnector();
        if (!src.getType().equals(NodeConnector.NodeConnectorIDType.PRODUCTION)) {
            if (type == UpdateType.ADDED) {
                this.edgeMap.put(dst, edge);
            } else {
                this.edgeMap.remove(dst);
            }
        } else if (type == UpdateType.ADDED) {
            this.prodMap.put(dst, edge);
        } else {
            this.prodMap.remove(dst);
        }
    }

    private void moveToReadyListHi(NodeConnector nodeConnector) {
        if (this.readyListLo.contains(nodeConnector)) {
            this.readyListLo.remove(nodeConnector);
        } else if (this.stagingList.contains(nodeConnector)) {
            this.stagingList.remove(nodeConnector);
        }
        this.readyListHi.add(nodeConnector);
    }

    private void registerWithOSGIConsole() {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        bundleContext.registerService(CommandProvider.class.getName(), (Object)this, null);
    }

    private int getDiscoveryConsistencyCheckInterval() {
        return this.discoveryConsistencyCheckMultiple * this.discoveryBatchRestartTicks;
    }

    public String getHelp() {
        StringBuffer help = new StringBuffer();
        help.append("---Topology Discovery---\n");
        help.append("\t prlh                            - Print readyListHi entries\n");
        help.append("\t prll                            - Print readyListLo entries\n");
        help.append("\t psl                             - Print stagingList entries\n");
        help.append("\t pht                             - Print hold time\n");
        help.append("\t pet                             - Print elapsed time\n");
        help.append("\t ptick                           - Print tick time in msec\n");
        help.append("\t pcc                             - Print CC info\n");
        help.append("\t psize                           - Print sizes of all the lists\n");
        help.append("\t ptm                             - Print timeout info\n");
        help.append("\t ecc                             - Enable CC\n");
        help.append("\t dcc                             - Disable CC\n");
        help.append("\t scc [multiple]                  - Set/show CC multiple and interval\n");
        help.append("\t sports [ports]                  - Set/show max ports per batch\n");
        help.append("\t spause [ticks]                  - Set/show pause period\n");
        help.append("\t sdi [ticks]                     - Set/show discovery interval in ticks\n");
        help.append("\t addsw <swid>                    - Add a switch\n");
        help.append("\t remsw <swid>                    - Remove a switch\n");
        help.append("\t page                            - Print aging info\n");
        help.append("\t sage                            - Set/Show aging time limit\n");
        help.append("\t eage                            - Enable aging\n");
        help.append("\t dage                            - Disable aging\n");
        help.append("\t pthrot                          - Print throttling\n");
        help.append("\t ethrot                          - Enable throttling\n");
        help.append("\t dthrot                          - Disable throttling\n");
        help.append("\t psnp                            - Print LLDP snooping\n");
        help.append("\t esnp <all|nodeConnector>        - Enable LLDP snooping\n");
        help.append("\t dsnp <all|nodeConnector>        - Disable LLDP snooping\n");
        return help.toString();
    }

    private List<NodeConnector> sortList(Collection<NodeConnector> ncs) {
        ArrayList<String> ncStrArray = new ArrayList<String>();
        for (NodeConnector nc : ncs) {
            ncStrArray.add(nc.toString());
        }
        Collections.sort(ncStrArray);
        ArrayList<NodeConnector> sortedNodeConnectors = new ArrayList<NodeConnector>();
        for (String ncStr : ncStrArray) {
            sortedNodeConnectors.add(NodeConnector.fromString((String)ncStr));
        }
        return sortedNodeConnectors;
    }

    public void _prlh(CommandInterpreter ci) {
        ci.println((Object)"readyListHi\n");
        for (NodeConnector nodeConnector : this.sortList(this.readyListHi)) {
            if (nodeConnector == null) continue;
            ci.println((Object)nodeConnector);
        }
        ci.println((Object)("Total number of Node Connectors: " + this.readyListHi.size()));
    }

    public void _prll(CommandInterpreter ci) {
        ci.println((Object)"readyListLo\n");
        for (NodeConnector nodeConnector : this.sortList(this.readyListLo)) {
            if (nodeConnector == null) continue;
            ci.println((Object)nodeConnector);
        }
        ci.println((Object)("Total number of Node Connectors: " + this.readyListLo.size()));
    }

    public void _psl(CommandInterpreter ci) {
        ci.println((Object)"stagingList\n");
        for (NodeConnector nodeConnector : this.sortList(this.stagingList)) {
            if (nodeConnector == null) continue;
            ci.println((Object)nodeConnector);
        }
        ci.println((Object)("Total number of Node Connectors: " + this.stagingList.size()));
    }

    public void _pht(CommandInterpreter ci) {
        ci.println((Object)"          NodeConnector            Last rx LLDP (sec)");
        for (Map.Entry entry : this.holdTime.entrySet()) {
            ci.println((Object)(entry.getKey() + "\t\t" + (long)((Integer)entry.getValue()).intValue() * 2L));
        }
        ci.println((Object)("\nSize: " + this.holdTime.size() + "\tTimeout: " + (long)this.discoveryTimeoutTicks * 2L + " sec"));
    }

    public void _pet(CommandInterpreter ci) {
        ci.println((Object)"          NodeConnector            Elapsed Time (sec)");
        for (Map.Entry entry : this.elapsedTime.entrySet()) {
            ci.println((Object)(entry.getKey() + "\t\t" + (long)((Integer)entry.getValue()).intValue() * 2L));
        }
        ci.println((Object)("\nSize: " + this.elapsedTime.size() + "\tThreshold: " + DiscoveryPeriod.THRESHOLD.getTime() + " sec"));
    }

    public void _ptick(CommandInterpreter ci) {
        ci.println((Object)"Current timer is 2000 msec per tick");
    }

    public void _pcc(CommandInterpreter ci) {
        if (this.discoveryConsistencyCheckEnabled) {
            ci.println((Object)"ConsistencyChecker is currently enabled");
        } else {
            ci.println((Object)"ConsistencyChecker is currently disabled");
        }
        ci.println((Object)("Interval " + this.getDiscoveryConsistencyCheckInterval()));
        ci.println((Object)("Multiple " + this.discoveryConsistencyCheckMultiple));
        ci.println((Object)("Number of times called " + this.discoveryConsistencyCheckCallingTimes));
        ci.println((Object)("Corrected count " + this.discoveryConsistencyCheckCorrected));
    }

    public void _ptm(CommandInterpreter ci) {
        ci.println((Object)("Timeout " + this.discoveryTimeoutTicks + " ticks, " + 2L + " sec per tick."));
    }

    public void _psize(CommandInterpreter ci) {
        ci.println((Object)("readyListLo size " + this.readyListLo.size() + "\n" + "readyListHi size " + this.readyListHi.size() + "\n" + "stagingList size " + this.stagingList.size() + "\n" + "holdTime size " + this.holdTime.size() + "\n" + "edgeMap size " + this.edgeMap.size() + "\n" + "prodMap size " + this.prodMap.size() + "\n" + "agingMap size " + this.agingMap.size() + "\n" + "elapsedTime size " + this.elapsedTime.size()));
    }

    public void _page(CommandInterpreter ci) {
        if (this.discoveryAgingEnabled) {
            ci.println((Object)"Aging is enabled");
        } else {
            ci.println((Object)"Aging is disabled");
        }
        ci.println((Object)("Current aging time limit " + this.discoveryAgeoutTicks));
        ci.println((Object)"\n");
        ci.println((Object)"                           Edge                                 Aging ");
        Collection prodSet = this.prodMap.values();
        if (prodSet == null) {
            return;
        }
        for (Edge edge : prodSet) {
            Integer aging = (Integer)this.agingMap.get(edge.getHeadNodeConnector());
            if (aging == null) continue;
            ci.println((Object)(edge + "      " + aging));
        }
        ci.println((Object)"\n");
        ci.println((Object)"              NodeConnector                                                 Edge ");
        Set keySet = this.prodMap.keySet();
        if (keySet == null) {
            return;
        }
        for (NodeConnector nc : keySet) {
            ci.println((Object)(nc + "      " + this.prodMap.get(nc)));
        }
    }

    public void _sage(CommandInterpreter ci) {
        String val = ci.nextArgument();
        if (val == null) {
            ci.println((Object)("Please enter aging time limit. Current value " + this.discoveryAgeoutTicks));
            return;
        }
        try {
            this.discoveryAgeoutTicks = Integer.parseInt(val);
        }
        catch (Exception e) {
            ci.println((Object)"Please enter a valid number");
        }
    }

    public void _eage(CommandInterpreter ci) {
        this.discoveryAgingEnabled = true;
        ci.println((Object)"Aging is enabled");
    }

    public void _dage(CommandInterpreter ci) {
        this.discoveryAgingEnabled = false;
        ci.println((Object)"Aging is disabled");
    }

    public void _scc(CommandInterpreter ci) {
        String val = ci.nextArgument();
        if (val == null) {
            ci.println((Object)("Please enter CC multiple. Current multiple " + this.discoveryConsistencyCheckMultiple + " (interval " + this.getDiscoveryConsistencyCheckInterval() + ") calling times " + this.discoveryConsistencyCheckCallingTimes));
            return;
        }
        try {
            this.discoveryConsistencyCheckMultiple = Integer.parseInt(val);
        }
        catch (Exception e) {
            ci.println((Object)"Please enter a valid number");
        }
    }

    public void _ecc(CommandInterpreter ci) {
        this.discoveryConsistencyCheckEnabled = true;
        ci.println((Object)"ConsistencyChecker is enabled");
    }

    public void _dcc(CommandInterpreter ci) {
        this.discoveryConsistencyCheckEnabled = false;
        ci.println((Object)"ConsistencyChecker is disabled");
    }

    public void _psnp(CommandInterpreter ci) {
        if (this.discoverySnoopingEnabled) {
            ci.println((Object)"Discovery snooping is globally enabled");
        } else {
            ci.println((Object)"Discovery snooping is globally disabled");
        }
        ci.println((Object)"\nDiscovery snooping is locally disabled on these ports");
        for (NodeConnector nodeConnector : this.discoverySnoopingDisableList) {
            ci.println((Object)nodeConnector);
        }
    }

    public void _esnp(CommandInterpreter ci) {
        String val = ci.nextArgument();
        if (val == null) {
            ci.println((Object)"Usage: esnp <all|nodeConnector>");
        } else if (val.equalsIgnoreCase("all")) {
            this.discoverySnoopingEnabled = true;
            ci.println((Object)"Discovery snooping is globally enabled");
        } else {
            NodeConnector nodeConnector = NodeConnector.fromString((String)val);
            if (nodeConnector != null) {
                this.discoverySnoopingDisableList.remove(nodeConnector);
                ci.println((Object)("Discovery snooping is locally enabled on port " + nodeConnector));
            } else {
                ci.println((Object)("Entered invalid NodeConnector " + val));
            }
        }
    }

    public void _dsnp(CommandInterpreter ci) {
        String val = ci.nextArgument();
        if (val == null) {
            ci.println((Object)"Usage: dsnp <all|nodeConnector>");
        } else if (val.equalsIgnoreCase("all")) {
            this.discoverySnoopingEnabled = false;
            ci.println((Object)"Discovery snooping is globally disabled");
        } else {
            NodeConnector nodeConnector = NodeConnector.fromString((String)val);
            if (nodeConnector != null) {
                this.discoverySnoopingDisableList.add(nodeConnector);
                ci.println((Object)("Discovery snooping is locally disabled on port " + nodeConnector));
            } else {
                ci.println((Object)("Entered invalid NodeConnector " + val));
            }
        }
    }

    public void _spause(CommandInterpreter ci) {
        String val = ci.nextArgument();
        String out = "Please enter pause period less than " + this.discoveryBatchRestartTicks + ". Current pause period is " + this.discoveryBatchPausePeriod + " ticks, pause at " + this.discoveryBatchPauseTicks + " ticks, " + 2L + " sec per tick.";
        if (val != null) {
            try {
                int pause = Integer.parseInt(val);
                if (pause < this.discoveryBatchRestartTicks) {
                    this.discoveryBatchPausePeriod = pause;
                    this.discoveryBatchPauseTicks = this.getDiscoveryPauseInterval();
                    return;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ci.println((Object)out);
    }

    public void _sdi(CommandInterpreter ci) {
        String val = ci.nextArgument();
        String out = "Please enter discovery interval in ticks. Current value is " + this.discoveryBatchRestartTicks + " ticks, " + 2L + " sec per tick.";
        if (val != null) {
            try {
                Set monitorSet = this.holdTime.keySet();
                if (monitorSet != null) {
                    for (NodeConnector nodeConnector : monitorSet) {
                        this.holdTime.put(nodeConnector, 0);
                    }
                }
                int ticks = Integer.parseInt(val);
                DiscoveryPeriod.INTERVAL.setTick(ticks);
                this.discoveryBatchRestartTicks = this.getDiscoveryInterval();
                this.discoveryBatchPauseTicks = this.getDiscoveryPauseInterval();
                this.discoveryTimeoutTicks = this.getDiscoveryTimeout();
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ci.println((Object)out);
    }

    public void _sports(CommandInterpreter ci) {
        String val = ci.nextArgument();
        if (val == null) {
            ci.println((Object)("Please enter max ports per batch. Current value is " + this.discoveryBatchMaxPorts));
            return;
        }
        try {
            this.discoveryBatchMaxPorts = Integer.parseInt(val);
        }
        catch (Exception e) {
            ci.println((Object)"Please enter a valid number");
        }
    }

    public void _addsw(CommandInterpreter ci) {
        String val = ci.nextArgument();
        try {
            Long sid = Long.parseLong(val);
            Node node = NodeCreator.createOFNode((Long)sid);
            this.addDiscovery(node);
        }
        catch (Exception e) {
            ci.println((Object)"Please enter a valid number");
        }
    }

    public void _remsw(CommandInterpreter ci) {
        String val = ci.nextArgument();
        try {
            Long sid = Long.parseLong(val);
            Node node = NodeCreator.createOFNode((Long)sid);
            this.removeDiscovery(node);
        }
        catch (Exception e) {
            ci.println((Object)"Please enter a valid number");
        }
    }

    public void _pthrot(CommandInterpreter ci) {
        if (this.throttling.booleanValue()) {
            ci.println((Object)"Throttling is enabled");
        } else {
            ci.println((Object)"Throttling is disabled");
        }
    }

    public void _ethrot(CommandInterpreter ci) {
        this.throttling = true;
        ci.println((Object)"Throttling is enabled");
    }

    public void _dthrot(CommandInterpreter ci) {
        this.throttling = false;
        ci.println((Object)"Throttling is disabled");
    }

    @Override
    public void updateNode(Node node, UpdateType type, Set<Property> props) {
        switch (type) {
            case ADDED: {
                this.addNode(node, props);
                break;
            }
            case REMOVED: {
                this.removeNode(node);
                break;
            }
        }
    }

    @Override
    public void updateNodeConnector(NodeConnector nodeConnector, UpdateType type, Set<Property> props) {
        Config config = null;
        State state = null;
        boolean enabled = false;
        for (Property prop : props) {
            if (prop.getName().equals("config")) {
                config = (Config)prop;
                continue;
            }
            if (!prop.getName().equals("state")) continue;
            state = (State)prop;
        }
        enabled = config != null && config.getValue() == 1 && state != null && state.getValue() == 1;
        switch (type) {
            case ADDED: {
                if (enabled) {
                    this.addDiscovery(nodeConnector);
                    logger.trace("ADDED enabled {}", (Object)nodeConnector);
                    break;
                }
                logger.trace("ADDED disabled {}", (Object)nodeConnector);
                break;
            }
            case CHANGED: {
                if (enabled) {
                    this.addDiscovery(nodeConnector);
                    logger.trace("CHANGED enabled {}", (Object)nodeConnector);
                    break;
                }
                this.removeDiscovery(nodeConnector);
                logger.trace("CHANGED disabled {}", (Object)nodeConnector);
                break;
            }
            case REMOVED: {
                this.removeDiscovery(nodeConnector);
                logger.trace("REMOVED enabled {}", (Object)nodeConnector);
                break;
            }
            default: {
                return;
            }
        }
    }

    public void addNode(Node node, Set<Property> props) {
        if (node == null) {
            return;
        }
        this.addDiscovery(node);
    }

    public void removeNode(Node node) {
        if (node == null) {
            return;
        }
        this.removeDiscovery(node);
    }

    void setController(IController s) {
        this.controller = s;
    }

    void unsetController(IController s) {
        if (this.controller == s) {
            this.controller = null;
        }
    }

    public void setInventoryProvider(IInventoryProvider service) {
        this.inventoryProvider = service;
    }

    public void unsetInventoryProvider(IInventoryProvider service) {
        this.inventoryProvider = null;
    }

    public void setIDataPacketMux(IDataPacketMux service) {
        this.iDataPacketMux = service;
    }

    public void unsetIDataPacketMux(IDataPacketMux service) {
        if (this.iDataPacketMux == service) {
            this.iDataPacketMux = null;
        }
    }

    void setDiscoveryListener(IDiscoveryListener s) {
        this.discoveryListener = s;
    }

    void unsetDiscoveryListener(IDiscoveryListener s) {
        if (this.discoveryListener == s) {
            this.discoveryListener = null;
        }
    }

    void setIPluginOutConnectionService(IPluginOutConnectionService s) {
        this.connectionOutService = s;
    }

    void unsetIPluginOutConnectionService(IPluginOutConnectionService s) {
        if (this.connectionOutService == s) {
            this.connectionOutService = null;
        }
    }

    private void initDiscoveryPacket() {
        this.chassisIdTlv = new LLDPTLV();
        this.chassisIdTlv.setType(LLDPTLV.TLVType.ChassisID.getValue());
        this.systemNameTlv = new LLDPTLV();
        this.systemNameTlv.setType(LLDPTLV.TLVType.SystemName.getValue());
        this.portIdTlv = new LLDPTLV();
        this.portIdTlv.setType(LLDPTLV.TLVType.PortID.getValue());
        byte[] ttl = new byte[]{0, 120};
        this.ttlTlv = new LLDPTLV();
        this.ttlTlv.setType(LLDPTLV.TLVType.TTL.getValue()).setLength((short)ttl.length).setValue(ttl);
        this.customTlv = new LLDPTLV();
    }

    void init() {
        logger.trace("Init called");
        this.transmitQ = new LinkedBlockingQueue<NodeConnector>();
        this.readyListHi = new CopyOnWriteArrayList<NodeConnector>();
        this.readyListLo = new CopyOnWriteArrayList<NodeConnector>();
        this.stagingList = new CopyOnWriteArrayList<NodeConnector>();
        this.holdTime = new ConcurrentHashMap<NodeConnector, Integer>();
        this.elapsedTime = new ConcurrentHashMap<NodeConnector, Integer>();
        this.edgeMap = new ConcurrentHashMap<NodeConnector, Edge>();
        this.agingMap = new ConcurrentHashMap<NodeConnector, Integer>();
        this.prodMap = new ConcurrentHashMap<NodeConnector, Edge>();
        this.discoverySnoopingDisableList = new CopyOnWriteArrayList<NodeConnector>();
        this.discoveryBatchRestartTicks = this.getDiscoveryInterval();
        this.discoveryBatchPauseTicks = this.getDiscoveryPauseInterval();
        this.discoveryTimeoutTicks = this.getDiscoveryTimeout();
        this.discoveryThresholdTicks = this.getDiscoveryThreshold();
        this.discoveryAgeoutTicks = this.getDiscoveryAgeout();
        this.discoveryConsistencyCheckTickCount = this.discoveryBatchPauseTicks;
        this.discoveryBatchMaxPorts = this.getDiscoveryBatchMaxPorts();
        this.discoveryTimer = new Timer("DiscoveryService");
        this.discoveryTimerTask = new DiscoveryTimerTask();
        this.transmitThread = new Thread(new DiscoveryTransmit(this.transmitQ));
        this.initDiscoveryPacket();
        this.registerWithOSGIConsole();
    }

    void destroy() {
        this.transmitQ = null;
        this.readyListHi = null;
        this.readyListLo = null;
        this.stagingList = null;
        this.holdTime = null;
        this.edgeMap = null;
        this.agingMap = null;
        this.prodMap = null;
        this.discoveryTimer = null;
        this.discoveryTimerTask = null;
        this.transmitThread = null;
    }

    void start() {
        this.discoveryTimer.schedule((TimerTask)this.discoveryTimerTask, 2000L, 2000L);
        this.transmitThread.start();
    }

    void started() {
        this.addDiscovery();
    }

    void stop() {
        this.shuttingDown = true;
        this.discoveryTimer.cancel();
        this.transmitThread.interrupt();
    }

    public void tagUpdated(String containerName, Node n, short oldTag, short newTag, UpdateType t) {
    }

    public void containerFlowUpdated(String containerName, ContainerFlow previousFlow, ContainerFlow currentFlow, UpdateType t) {
    }

    public void nodeConnectorUpdated(String containerName, NodeConnector p, UpdateType t) {
        switch (t) {
            case ADDED: {
                this.moveToReadyListHi(p);
                break;
            }
        }
    }

    public void containerModeUpdated(UpdateType t) {
    }

    private byte[] getSourceMACFromNodeID(String nodeId) {
        byte[] sourceMac;
        byte[] cid = HexEncode.bytesFromHexString((String)nodeId);
        int pos = cid.length - (sourceMac = new byte[6]).length;
        if (pos >= 0) {
            System.arraycopy(cid, pos, sourceMac, 0, sourceMac.length);
        }
        return sourceMac;
    }

    private int getDiscoveryTicks(DiscoveryPeriod dp, String val) {
        if (dp == null) {
            return 0;
        }
        if (val != null) {
            try {
                dp.setTime(Integer.parseInt(val));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dp.getTick();
    }

    private int getDiscoveryInterval() {
        String intvl = System.getProperty("of.discoveryInterval");
        return this.getDiscoveryTicks(DiscoveryPeriod.INTERVAL, intvl);
    }

    private int getDiscoveryTimeout() {
        String val = System.getProperty("of.discoveryTimeoutMultiple");
        int multiple = 2;
        if (val != null) {
            try {
                multiple = Integer.parseInt(val);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getDiscoveryInterval() * multiple + 3;
    }

    private int getDiscoveryThreshold() {
        String val = System.getProperty("of.discoveryThreshold");
        return this.getDiscoveryTicks(DiscoveryPeriod.THRESHOLD, val);
    }

    private int getDiscoveryAgeout() {
        return this.getDiscoveryTicks(DiscoveryPeriod.AGEOUT, null);
    }

    private int getDiscoveryPauseInterval() {
        if (this.discoveryBatchRestartTicks > this.discoveryBatchPausePeriod) {
            return this.discoveryBatchRestartTicks - this.discoveryBatchPausePeriod;
        }
        return this.discoveryBatchRestartTicks - 1;
    }

    private int getDiscoveryBatchMaxPorts() {
        String val = System.getProperty("of.discoveryBatchMaxPorts");
        int ports = 512;
        if (val != null) {
            try {
                ports = Integer.parseInt(val);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ports;
    }

    public static enum DiscoveryPeriod {
        INTERVAL(300),
        AGEOUT(120),
        THRESHOLD(30);

        private int time;
        private int tick;

        private DiscoveryPeriod(int time) {
            this.time = time;
            this.tick = this.time2Tick(time);
        }

        public int getTime() {
            return this.time;
        }

        public void setTime(int time) {
            this.time = time;
            this.tick = this.time2Tick(time);
        }

        public int getTick() {
            return this.tick;
        }

        public void setTick(int tick) {
            this.time = this.tick2Time(tick);
            this.tick = tick;
        }

        private int time2Tick(int time) {
            return (int)((long)time / 2L);
        }

        private int tick2Time(int tick) {
            return (int)((long)tick * 2L);
        }
    }

    class DiscoveryTimerTask
    extends TimerTask {
        DiscoveryTimerTask() {
        }

        @Override
        public void run() {
            DiscoveryService.this.checkTimeout();
            DiscoveryService.this.checkAging();
            DiscoveryService.this.doConsistencyCheck();
            DiscoveryService.this.doDiscovery();
        }
    }

    class DiscoveryTransmit
    implements Runnable {
        private final BlockingQueue<NodeConnector> transmitQ;
        private int count = 0;

        DiscoveryTransmit(BlockingQueue<NodeConnector> transmitQ) {
            this.transmitQ = transmitQ;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        NodeConnector nodeConnector = this.transmitQ.take();
                        RawPacket outPkt = DiscoveryService.this.createDiscoveryPacket(nodeConnector);
                        DiscoveryService.this.sendDiscoveryPacket(nodeConnector, outPkt);
                        nodeConnector = null;
                        if ((++this.count & 0x7F) != 0) continue;
                        Thread.sleep(10L);
                    }
                }
                catch (InterruptedException e1) {
                    logger.warn("DiscoveryTransmit interupted", (Object)e1.getMessage());
                    if (!DiscoveryService.this.shuttingDown.booleanValue()) continue;
                    return;
                }
                catch (Exception e2) {
                    logger.error("", (Throwable)e2);
                    continue;
                }
                break;
            }
        }
    }
}

