/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.internal;

import java.util.List;
import org.opendaylight.controller.sal.reader.NodeDescription;
import org.openflow.protocol.statistics.OFDescriptionStatistics;
import org.openflow.protocol.statistics.OFStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DescStatisticsConverter {
    private static final Logger log = LoggerFactory.getLogger(DescStatisticsConverter.class);
    NodeDescription hwDesc = null;
    OFDescriptionStatistics ofDesc;

    public DescStatisticsConverter(List<OFStatistics> statsList) {
        this.ofDesc = statsList == null || statsList.isEmpty() ? null : (OFDescriptionStatistics)statsList.get(0);
    }

    public DescStatisticsConverter(OFDescriptionStatistics desc) {
        this.ofDesc = desc;
    }

    public NodeDescription getHwDescription() {
        if (this.hwDesc == null && this.ofDesc != null) {
            this.hwDesc = new NodeDescription();
            this.hwDesc.setManufacturer(this.ofDesc.getManufacturerDescription());
            this.hwDesc.setHardware(this.ofDesc.getHardwareDescription());
            this.hwDesc.setSoftware(this.ofDesc.getSoftwareDescription());
            this.hwDesc.setDescription(this.ofDesc.getDatapathDescription());
            this.hwDesc.setSerialNumber(this.ofDesc.getSerialNumber());
        }
        log.trace("OFDescriptionStatistics: {}", (Object)this.ofDesc);
        log.trace("NodeDescription: {}", (Object)this.hwDesc);
        return this.hwDesc;
    }
}

