/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.internal;

import org.opendaylight.controller.protocol_plugin.openflow.IDataPacketMux;
import org.opendaylight.controller.sal.connection.IPluginOutConnectionService;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.packet.IPluginInDataPacketService;
import org.opendaylight.controller.sal.packet.RawPacket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataPacketServices
implements IPluginInDataPacketService {
    protected static final Logger logger = LoggerFactory.getLogger(DataPacketServices.class);
    private IDataPacketMux iDataPacketMux = null;
    private IPluginOutConnectionService connectionOutService;

    void setIDataPacketMux(IDataPacketMux s) {
        this.iDataPacketMux = s;
    }

    void unsetIDataPacketMux(IDataPacketMux s) {
        if (this.iDataPacketMux == s) {
            this.iDataPacketMux = null;
        }
    }

    void setIPluginOutConnectionService(IPluginOutConnectionService s) {
        this.connectionOutService = s;
    }

    void unsetIPluginOutConnectionService(IPluginOutConnectionService s) {
        if (this.connectionOutService == s) {
            this.connectionOutService = null;
        }
    }

    public void transmitDataPacket(RawPacket outPkt) {
        NodeConnector nc = outPkt.getOutgoingNodeConnector();
        if (this.connectionOutService != null && this.connectionOutService.isLocal(nc.getNode())) {
            this.iDataPacketMux.transmitDataPacket(outPkt);
        } else {
            logger.debug("{} is dropped in the controller " + outPkt);
        }
    }
}

