/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opendaylight.controller.protocol_plugin.openflow.IDataPacketListen;
import org.opendaylight.controller.protocol_plugin.openflow.IDataPacketMux;
import org.opendaylight.controller.protocol_plugin.openflow.IInventoryShimExternalListener;
import org.opendaylight.controller.protocol_plugin.openflow.core.IController;
import org.opendaylight.controller.protocol_plugin.openflow.core.IMessageListener;
import org.opendaylight.controller.protocol_plugin.openflow.core.ISwitch;
import org.opendaylight.controller.protocol_plugin.openflow.internal.PortConverter;
import org.opendaylight.controller.sal.connection.IPluginOutConnectionService;
import org.opendaylight.controller.sal.core.ConstructionException;
import org.opendaylight.controller.sal.core.ContainerFlow;
import org.opendaylight.controller.sal.core.IContainerAware;
import org.opendaylight.controller.sal.core.IContainerListener;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.Property;
import org.opendaylight.controller.sal.core.UpdateType;
import org.opendaylight.controller.sal.packet.IPluginOutDataPacketService;
import org.opendaylight.controller.sal.packet.PacketResult;
import org.opendaylight.controller.sal.packet.RawPacket;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.HexEncode;
import org.openflow.protocol.OFMessage;
import org.openflow.protocol.OFPacketIn;
import org.openflow.protocol.OFPacketOut;
import org.openflow.protocol.OFPort;
import org.openflow.protocol.OFType;
import org.openflow.protocol.action.OFActionOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataPacketMuxDemux
implements IContainerListener,
IMessageListener,
IDataPacketMux,
IInventoryShimExternalListener,
IContainerAware {
    protected static final Logger logger = LoggerFactory.getLogger(DataPacketMuxDemux.class);
    private IController controller = null;
    private ConcurrentMap<Long, ISwitch> swID2ISwitch = new ConcurrentHashMap<Long, ISwitch>();
    private ConcurrentMap<String, IPluginOutDataPacketService> pluginOutDataPacketServices = new ConcurrentHashMap<String, IPluginOutDataPacketService>();
    private ConcurrentMap<NodeConnector, List<String>> nc2Container = new ConcurrentHashMap<NodeConnector, List<String>>();
    private ConcurrentMap<String, List<ContainerFlow>> container2FlowSpecs = new ConcurrentHashMap<String, List<ContainerFlow>>();
    private List<IDataPacketListen> iDataPacketListen = new CopyOnWriteArrayList<IDataPacketListen>();
    private IPluginOutConnectionService connectionOutService;

    void setIDataPacketListen(IDataPacketListen s) {
        if (this.iDataPacketListen != null && !this.iDataPacketListen.contains(s)) {
            logger.debug("Added new IDataPacketListen");
            this.iDataPacketListen.add(s);
        }
    }

    void unsetIDataPacketListen(IDataPacketListen s) {
        if (this.iDataPacketListen != null && this.iDataPacketListen.contains(s)) {
            logger.debug("Removed IDataPacketListen");
            this.iDataPacketListen.remove(s);
        }
    }

    void setPluginOutDataPacketService(Map<String, Object> props, IPluginOutDataPacketService s) {
        if (props == null) {
            logger.error("Didn't receive the service properties");
            return;
        }
        String containerName = (String)props.get("containerName");
        if (containerName == null) {
            logger.error("containerName not supplied");
            return;
        }
        if (this.pluginOutDataPacketServices != null) {
            this.pluginOutDataPacketServices.put(containerName, s);
            logger.debug("New outService for container: {}", (Object)containerName);
        }
    }

    void unsetPluginOutDataPacketService(Map<String, Object> props, IPluginOutDataPacketService s) {
        if (props == null) {
            logger.error("Didn't receive the service properties");
            return;
        }
        String containerName = (String)props.get("containerName");
        if (containerName == null) {
            logger.error("containerName not supplied");
            return;
        }
        if (this.pluginOutDataPacketServices != null) {
            this.pluginOutDataPacketServices.remove(containerName);
            logger.debug("Removed outService for container: {}", (Object)containerName);
        }
    }

    void setController(IController s) {
        logger.debug("Controller provider set in DATAPACKET SERVICES");
        this.controller = s;
    }

    void unsetController(IController s) {
        if (this.controller == s) {
            logger.debug("Controller provider UNset in DATAPACKET SERVICES");
            this.controller = null;
        }
    }

    void setIPluginOutConnectionService(IPluginOutConnectionService s) {
        this.connectionOutService = s;
    }

    void unsetIPluginOutConnectionService(IPluginOutConnectionService s) {
        if (this.connectionOutService == s) {
            this.connectionOutService = null;
        }
    }

    void init() {
        this.controller.addMessageListener(OFType.PACKET_IN, this);
    }

    void destroy() {
        this.controller.removeMessageListener(OFType.PACKET_IN, this);
        this.pluginOutDataPacketServices.clear();
        this.nc2Container.clear();
        this.container2FlowSpecs.clear();
        this.controller = null;
        this.swID2ISwitch.clear();
    }

    @Override
    public void receive(ISwitch sw, OFMessage msg) {
        if (sw == null || msg == null || this.pluginOutDataPacketServices == null) {
            logger.debug("sw: {} and/or msg: {} and/or pluginOutDataPacketServices: {} is null!", new Object[]{sw, msg, this.pluginOutDataPacketServices});
            return;
        }
        Long ofSwitchID = (long)sw.getId();
        try {
            Node n = new Node(Node.NodeIDType.OPENFLOW, (Object)ofSwitchID);
            if (!this.connectionOutService.isLocal(n)) {
                logger.debug("Connection service refused DataPacketMuxDemux receive {} {}", (Object)sw, (Object)msg);
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        if (msg instanceof OFPacketIn) {
            OFPacketIn ofPacket = (OFPacketIn)msg;
            Short ofPortID = ofPacket.getInPort();
            try {
                List containersRX;
                Node n = new Node(Node.NodeIDType.OPENFLOW, (Object)ofSwitchID);
                NodeConnector p = PortConverter.toNodeConnector(ofPortID, n);
                RawPacket dataPacket = new RawPacket(ofPacket.getPacketData());
                dataPacket.setIncomingNodeConnector(p);
                for (int i = 0; i < this.iDataPacketListen.size(); ++i) {
                    IDataPacketListen s = this.iDataPacketListen.get(i);
                    if (!s.receiveDataPacket(dataPacket).equals((Object)PacketResult.CONSUME)) continue;
                    logger.trace("Consumed locally data packet");
                    return;
                }
                IPluginOutDataPacketService defaultOutService = (IPluginOutDataPacketService)this.pluginOutDataPacketServices.get(GlobalConstants.DEFAULT.toString());
                if (defaultOutService != null) {
                    defaultOutService.receiveDataPacket(dataPacket);
                    if (logger.isTraceEnabled()) {
                        logger.trace("Dispatched to apps a frame of size: {} on container: {}: {}", new Object[]{ofPacket.getPacketData().length, GlobalConstants.DEFAULT.toString(), HexEncode.bytesToHexString((byte[])dataPacket.getPacketData())});
                    }
                }
                if ((containersRX = (List)this.nc2Container.get(p)) != null) {
                    for (int i = 0; i < containersRX.size(); ++i) {
                        String container = (String)containersRX.get(i);
                        IPluginOutDataPacketService s = (IPluginOutDataPacketService)this.pluginOutDataPacketServices.get(container);
                        if (s == null) continue;
                        s.receiveDataPacket(dataPacket);
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace("Dispatched to apps a frame of size: {} on container: {}: {}", new Object[]{ofPacket.getPacketData().length, container, HexEncode.bytesToHexString((byte[])dataPacket.getPacketData())});
                    }
                }
                return;
            }
            catch (ConstructionException cex) {
                return;
            }
        }
    }

    public void transmitDataPacket(RawPacket outPkt) {
        if (outPkt == null) {
            logger.debug("outPkt is null!");
            return;
        }
        NodeConnector outPort = outPkt.getOutgoingNodeConnector();
        if (outPort == null) {
            logger.debug("outPort is null! outPkt: {}", (Object)outPkt);
            return;
        }
        if (!this.connectionOutService.isLocal(outPort.getNode())) {
            logger.debug("data packets will not be sent to {} in a non-master controller", (Object)outPort.toString());
            return;
        }
        if (!outPort.getType().equals(NodeConnector.NodeConnectorIDType.OPENFLOW)) {
            logger.debug("outPort is not OF Type! outPort: {}", (Object)outPort);
            return;
        }
        Short port = (Short)outPort.getID();
        Long swID = (Long)outPort.getNode().getID();
        ISwitch sw = (ISwitch)this.swID2ISwitch.get(swID);
        if (sw == null) {
            logger.debug("swID: {} - sw is null!", (Object)swID);
            return;
        }
        byte[] data = outPkt.getPacketData();
        OFActionOutput action = new OFActionOutput().setPort(port.shortValue());
        OFPacketOut po = new OFPacketOut().setBufferId(OFPacketOut.BUFFER_ID_NONE).setActions(Collections.singletonList(action)).setActionsLength((short)OFActionOutput.MINIMUM_LENGTH);
        if (outPkt.getIncomingNodeConnector() != null) {
            po.setInPort(((Short)outPkt.getIncomingNodeConnector().getID()).shortValue());
        } else {
            po.setInPort(OFPort.OFPP_NONE);
        }
        po.setLengthU(OFPacketOut.MINIMUM_LENGTH + po.getActionsLength() + data.length);
        po.setPacketData(data);
        sw.asyncFastSend((OFMessage)po);
        logger.trace("Transmitted a frame of size: {}", (Object)data.length);
    }

    public void addNode(Node node, Set<Property> props) {
        if (node == null) {
            logger.debug("node is null!");
            return;
        }
        long sid = (Long)node.getID();
        ISwitch sw = this.controller.getSwitches().get(sid);
        if (sw == null) {
            logger.debug("sid: {} - sw is null!", (Object)sid);
            return;
        }
        this.swID2ISwitch.put(sw.getId(), sw);
    }

    public void removeNode(Node node) {
        if (node == null) {
            logger.debug("node is null!");
            return;
        }
        long sid = (Long)node.getID();
        ISwitch sw = this.controller.getSwitches().get(sid);
        if (sw == null) {
            logger.debug("sid: {} - sw is null!", (Object)sid);
            return;
        }
        this.swID2ISwitch.remove(sw.getId());
    }

    public void tagUpdated(String containerName, Node n, short oldTag, short newTag, UpdateType t) {
    }

    public void containerFlowUpdated(String containerName, ContainerFlow previousFlow, ContainerFlow currentFlow, UpdateType t) {
        if (this.container2FlowSpecs == null) {
            logger.error("container2FlowSpecs is NULL");
            return;
        }
        CopyOnWriteArrayList<ContainerFlow> fSpecs = (CopyOnWriteArrayList<ContainerFlow>)this.container2FlowSpecs.get(containerName);
        if (fSpecs == null) {
            fSpecs = new CopyOnWriteArrayList<ContainerFlow>();
        }
        switch (t) {
            case ADDED: {
                if (!fSpecs.contains(currentFlow)) {
                    fSpecs.add(currentFlow);
                }
                this.container2FlowSpecs.put(containerName, fSpecs);
                break;
            }
            case REMOVED: {
                fSpecs.remove(currentFlow);
                break;
            }
        }
    }

    public void nodeConnectorUpdated(String containerName, NodeConnector p, UpdateType t) {
        if (this.nc2Container == null) {
            logger.error("nc2Container is NULL");
            return;
        }
        CopyOnWriteArrayList<String> containers = (CopyOnWriteArrayList<String>)this.nc2Container.get(p);
        if (containers == null) {
            containers = new CopyOnWriteArrayList<String>();
        }
        boolean updateMap = false;
        switch (t) {
            case ADDED: {
                if (containers.contains(containerName)) break;
                containers.add(containerName);
                updateMap = true;
                break;
            }
            case REMOVED: {
                if (!containers.contains(containerName)) break;
                containers.remove(containerName);
                updateMap = true;
                break;
            }
        }
        if (updateMap) {
            if (containers.isEmpty()) {
                this.nc2Container.remove(p);
            } else {
                this.nc2Container.put(p, containers);
            }
        }
    }

    public void containerModeUpdated(UpdateType t) {
    }

    @Override
    public void updateNode(Node node, UpdateType type, Set<Property> props) {
        switch (type) {
            case ADDED: {
                this.addNode(node, props);
                break;
            }
            case REMOVED: {
                this.removeNode(node);
                break;
            }
        }
    }

    @Override
    public void updateNodeConnector(NodeConnector nodeConnector, UpdateType type, Set<Property> props) {
    }

    public void containerCreate(String containerName) {
    }

    public void containerDestroy(String containerName) {
        List ncContainers;
        HashSet<NodeConnector> removeNodeConnectorSet = new HashSet<NodeConnector>();
        for (Map.Entry entry : this.nc2Container.entrySet()) {
            ncContainers = (List)entry.getValue();
            if (!ncContainers.contains(containerName)) continue;
            NodeConnector nodeConnector = (NodeConnector)entry.getKey();
            removeNodeConnectorSet.add(nodeConnector);
        }
        for (NodeConnector nodeConnector : removeNodeConnectorSet) {
            ncContainers = (List)this.nc2Container.get(nodeConnector);
            ncContainers.remove(containerName);
            if (!ncContainers.isEmpty()) continue;
            this.nc2Container.remove(nodeConnector);
        }
        this.container2FlowSpecs.remove(containerName);
    }
}

