/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.Dependency;
import org.opendaylight.controller.protocol_plugin.openflow.IDataPacketListen;
import org.opendaylight.controller.protocol_plugin.openflow.IDataPacketMux;
import org.opendaylight.controller.protocol_plugin.openflow.IDiscoveryListener;
import org.opendaylight.controller.protocol_plugin.openflow.IFlowProgrammerNotifier;
import org.opendaylight.controller.protocol_plugin.openflow.IInventoryProvider;
import org.opendaylight.controller.protocol_plugin.openflow.IInventoryShimExternalListener;
import org.opendaylight.controller.protocol_plugin.openflow.IInventoryShimInternalListener;
import org.opendaylight.controller.protocol_plugin.openflow.IOFStatisticsListener;
import org.opendaylight.controller.protocol_plugin.openflow.IOFStatisticsManager;
import org.opendaylight.controller.protocol_plugin.openflow.IReadFilterInternalListener;
import org.opendaylight.controller.protocol_plugin.openflow.IReadServiceFilter;
import org.opendaylight.controller.protocol_plugin.openflow.IRefreshInternalProvider;
import org.opendaylight.controller.protocol_plugin.openflow.ITopologyServiceShimListener;
import org.opendaylight.controller.protocol_plugin.openflow.core.IController;
import org.opendaylight.controller.protocol_plugin.openflow.core.IMessageListener;
import org.opendaylight.controller.protocol_plugin.openflow.core.internal.Controller;
import org.opendaylight.controller.protocol_plugin.openflow.internal.DataPacketMuxDemux;
import org.opendaylight.controller.protocol_plugin.openflow.internal.DataPacketServices;
import org.opendaylight.controller.protocol_plugin.openflow.internal.DiscoveryService;
import org.opendaylight.controller.protocol_plugin.openflow.internal.FlowProgrammerNotifier;
import org.opendaylight.controller.protocol_plugin.openflow.internal.FlowProgrammerService;
import org.opendaylight.controller.protocol_plugin.openflow.internal.InventoryService;
import org.opendaylight.controller.protocol_plugin.openflow.internal.InventoryServiceShim;
import org.opendaylight.controller.protocol_plugin.openflow.internal.OFStatisticsManager;
import org.opendaylight.controller.protocol_plugin.openflow.internal.ReadService;
import org.opendaylight.controller.protocol_plugin.openflow.internal.ReadServiceFilter;
import org.opendaylight.controller.protocol_plugin.openflow.internal.TopologyServiceShim;
import org.opendaylight.controller.protocol_plugin.openflow.internal.TopologyServices;
import org.opendaylight.controller.sal.connection.IPluginInConnectionService;
import org.opendaylight.controller.sal.connection.IPluginOutConnectionService;
import org.opendaylight.controller.sal.core.ComponentActivatorAbstractBase;
import org.opendaylight.controller.sal.core.IContainerAware;
import org.opendaylight.controller.sal.core.IContainerListener;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.flowprogrammer.IPluginInFlowProgrammerService;
import org.opendaylight.controller.sal.flowprogrammer.IPluginOutFlowProgrammerService;
import org.opendaylight.controller.sal.inventory.IPluginInInventoryService;
import org.opendaylight.controller.sal.inventory.IPluginOutInventoryService;
import org.opendaylight.controller.sal.packet.IPluginInDataPacketService;
import org.opendaylight.controller.sal.packet.IPluginOutDataPacketService;
import org.opendaylight.controller.sal.reader.IPluginInReadService;
import org.opendaylight.controller.sal.reader.IPluginOutReadService;
import org.opendaylight.controller.sal.topology.IPluginInTopologyService;
import org.opendaylight.controller.sal.topology.IPluginOutTopologyService;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
extends ComponentActivatorAbstractBase {
    protected static final Logger logger = LoggerFactory.getLogger(Activator.class);

    public Object[] getImplementations() {
        Object[] res = new Object[]{TopologyServices.class, DataPacketServices.class, InventoryService.class, ReadService.class, FlowProgrammerNotifier.class};
        return res;
    }

    public void configureInstance(Component c, Object imp, String containerName) {
        Hashtable<String, String> props;
        if (imp.equals(TopologyServices.class)) {
            c.setInterface(new String[]{IPluginInTopologyService.class.getName(), ITopologyServiceShimListener.class.getName()}, null);
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(IPluginOutTopologyService.class).setCallbacks("setPluginOutTopologyService", "unsetPluginOutTopologyService").setRequired(false));
            c.add((Dependency)this.createServiceDependency().setService(IRefreshInternalProvider.class).setCallbacks("setRefreshInternalProvider", "unsetRefreshInternalProvider").setRequired(false));
        }
        if (imp.equals(InventoryService.class)) {
            c.setInterface(new String[]{IPluginInInventoryService.class.getName(), IInventoryShimInternalListener.class.getName(), IInventoryProvider.class.getName()}, null);
            c.add((Dependency)this.createServiceDependency().setService(IController.class, "(name=Controller)").setCallbacks("setController", "unsetController").setRequired(true));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(IPluginOutInventoryService.class).setCallbacks("setPluginOutInventoryServices", "unsetPluginOutInventoryServices").setRequired(false));
        }
        if (imp.equals(DataPacketServices.class)) {
            props = new Hashtable<String, String>();
            ((Dictionary)props).put(GlobalConstants.PROTOCOLPLUGINTYPE.toString(), Node.NodeIDType.OPENFLOW);
            c.setInterface(IPluginInDataPacketService.class.getName(), props);
            c.add((Dependency)this.createServiceDependency().setService(IController.class, "(name=Controller)").setCallbacks("setController", "unsetController").setRequired(true));
            c.add((Dependency)this.createServiceDependency().setService(IDataPacketMux.class).setCallbacks("setIDataPacketMux", "unsetIDataPacketMux").setRequired(true));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(IPluginOutDataPacketService.class).setCallbacks("setPluginOutDataPacketService", "unsetPluginOutDataPacketService").setRequired(false));
            c.add((Dependency)this.createServiceDependency().setService(IPluginOutConnectionService.class).setCallbacks("setIPluginOutConnectionService", "unsetIPluginOutConnectionService").setRequired(true));
        }
        if (imp.equals(ReadService.class)) {
            props = new Hashtable();
            ((Dictionary)props).put(GlobalConstants.PROTOCOLPLUGINTYPE.toString(), Node.NodeIDType.OPENFLOW);
            c.setInterface(new String[]{IReadFilterInternalListener.class.getName(), IPluginInReadService.class.getName()}, props);
            c.add((Dependency)this.createServiceDependency().setService(IReadServiceFilter.class).setCallbacks("setService", "unsetService").setRequired(true));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(IPluginOutReadService.class).setCallbacks("setPluginOutReadServices", "unsetPluginOutReadServices").setRequired(false));
            c.add((Dependency)this.createServiceDependency().setService(IPluginOutConnectionService.class).setCallbacks("setIPluginOutConnectionService", "unsetIPluginOutConnectionService").setRequired(true));
        }
        if (imp.equals(FlowProgrammerNotifier.class)) {
            props = new Hashtable();
            ((Dictionary)props).put(GlobalConstants.PROTOCOLPLUGINTYPE.toString(), Node.NodeIDType.OPENFLOW);
            c.setInterface(IFlowProgrammerNotifier.class.getName(), props);
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(IPluginOutFlowProgrammerService.class).setCallbacks("setPluginOutFlowProgrammerService", "unsetPluginOutFlowProgrammerService").setRequired(true));
            c.add((Dependency)this.createServiceDependency().setService(IPluginOutConnectionService.class).setCallbacks("setIPluginOutConnectionService", "unsetIPluginOutConnectionService").setRequired(true));
        }
    }

    public Object[] getGlobalImplementations() {
        Object[] res = new Object[]{Controller.class, OFStatisticsManager.class, FlowProgrammerService.class, ReadServiceFilter.class, DiscoveryService.class, DataPacketMuxDemux.class, InventoryService.class, InventoryServiceShim.class, TopologyServiceShim.class};
        return res;
    }

    public void configureGlobalInstance(Component c, Object imp) {
        Hashtable<String, String> props;
        if (imp.equals(Controller.class)) {
            logger.debug("Activator configureGlobalInstance( ) is called");
            props = new Hashtable<String, String>();
            ((Dictionary)props).put("name", "Controller");
            ((Dictionary)props).put(GlobalConstants.PROTOCOLPLUGINTYPE.toString(), Node.NodeIDType.OPENFLOW);
            c.setInterface(new String[]{IController.class.getName(), IPluginInConnectionService.class.getName()}, props);
        }
        if (imp.equals(FlowProgrammerService.class)) {
            props = new Hashtable();
            ((Dictionary)props).put(GlobalConstants.PROTOCOLPLUGINTYPE.toString(), Node.NodeIDType.OPENFLOW);
            c.setInterface(new String[]{IPluginInFlowProgrammerService.class.getName(), IMessageListener.class.getName(), IContainerListener.class.getName(), IInventoryShimExternalListener.class.getName(), IContainerAware.class.getName()}, props);
            c.add((Dependency)this.createServiceDependency().setService(IController.class, "(name=Controller)").setCallbacks("setController", "unsetController").setRequired(true));
            c.add((Dependency)this.createServiceDependency().setService(IFlowProgrammerNotifier.class).setCallbacks("setFlowProgrammerNotifier", "unsetsetFlowProgrammerNotifier").setRequired(false));
            c.add((Dependency)this.createServiceDependency().setService(IPluginOutConnectionService.class).setCallbacks("setIPluginOutConnectionService", "unsetIPluginOutConnectionService").setRequired(true));
        }
        if (imp.equals(ReadServiceFilter.class)) {
            c.setInterface(new String[]{IReadServiceFilter.class.getName(), IContainerListener.class.getName(), IOFStatisticsListener.class.getName(), IContainerAware.class.getName()}, null);
            c.add((Dependency)this.createServiceDependency().setService(IController.class, "(name=Controller)").setCallbacks("setController", "unsetController").setRequired(true));
            c.add((Dependency)this.createServiceDependency().setService(IOFStatisticsManager.class).setCallbacks("setService", "unsetService").setRequired(true));
            c.add((Dependency)this.createServiceDependency().setService(IReadFilterInternalListener.class).setCallbacks("setReadFilterInternalListener", "unsetReadFilterInternalListener").setRequired(false));
        }
        if (imp.equals(OFStatisticsManager.class)) {
            c.setInterface(new String[]{IOFStatisticsManager.class.getName(), IInventoryShimExternalListener.class.getName()}, null);
            c.add((Dependency)this.createServiceDependency().setService(IController.class, "(name=Controller)").setCallbacks("setController", "unsetController").setRequired(true));
            c.add((Dependency)this.createServiceDependency().setService(IOFStatisticsListener.class).setCallbacks("setStatisticsListener", "unsetStatisticsListener").setRequired(false));
        }
        if (imp.equals(DiscoveryService.class)) {
            c.setInterface(new String[]{IInventoryShimExternalListener.class.getName(), IDataPacketListen.class.getName(), IContainerListener.class.getName()}, null);
            c.add((Dependency)this.createServiceDependency().setService(IController.class, "(name=Controller)").setCallbacks("setController", "unsetController").setRequired(true));
            c.add((Dependency)this.createContainerServiceDependency(GlobalConstants.DEFAULT.toString()).setService(IInventoryProvider.class).setCallbacks("setInventoryProvider", "unsetInventoryProvider").setRequired(true));
            c.add((Dependency)this.createServiceDependency().setService(IDataPacketMux.class).setCallbacks("setIDataPacketMux", "unsetIDataPacketMux").setRequired(true));
            c.add((Dependency)this.createServiceDependency().setService(IDiscoveryListener.class).setCallbacks("setDiscoveryListener", "unsetDiscoveryListener").setRequired(true));
            c.add((Dependency)this.createServiceDependency().setService(IPluginOutConnectionService.class).setCallbacks("setIPluginOutConnectionService", "unsetIPluginOutConnectionService").setRequired(true));
        }
        if (imp.equals(DataPacketMuxDemux.class)) {
            c.setInterface(new String[]{IDataPacketMux.class.getName(), IContainerListener.class.getName(), IInventoryShimExternalListener.class.getName(), IContainerAware.class.getName()}, null);
            c.add((Dependency)this.createServiceDependency().setService(IController.class, "(name=Controller)").setCallbacks("setController", "unsetController").setRequired(true));
            c.add((Dependency)this.createServiceDependency().setService(IPluginOutDataPacketService.class).setCallbacks("setPluginOutDataPacketService", "unsetPluginOutDataPacketService").setRequired(false));
            c.add((Dependency)this.createServiceDependency().setService(IDataPacketListen.class).setCallbacks("setIDataPacketListen", "unsetIDataPacketListen").setRequired(false));
            c.add((Dependency)this.createServiceDependency().setService(IPluginOutConnectionService.class).setCallbacks("setIPluginOutConnectionService", "unsetIPluginOutConnectionService").setRequired(true));
        }
        if (imp.equals(InventoryService.class)) {
            props = new Hashtable();
            ((Dictionary)props).put("scope", "Global");
            c.setInterface(new String[]{IPluginInInventoryService.class.getName(), IInventoryShimInternalListener.class.getName(), IInventoryProvider.class.getName()}, props);
            c.add((Dependency)this.createServiceDependency().setService(IController.class, "(name=Controller)").setCallbacks("setController", "unsetController").setRequired(true));
            c.add((Dependency)this.createServiceDependency().setService(IPluginOutInventoryService.class, "(scope=Global)").setCallbacks("setPluginOutInventoryServices", "unsetPluginOutInventoryServices").setRequired(true));
        }
        if (imp.equals(InventoryServiceShim.class)) {
            c.setInterface(new String[]{IContainerListener.class.getName(), IOFStatisticsListener.class.getName(), IContainerAware.class.getName()}, null);
            c.add((Dependency)this.createServiceDependency().setService(IController.class, "(name=Controller)").setCallbacks("setController", "unsetController").setRequired(true));
            c.add((Dependency)this.createServiceDependency().setService(IInventoryShimInternalListener.class, "(!(scope=Global))").setCallbacks("setInventoryShimInternalListener", "unsetInventoryShimInternalListener").setRequired(true));
            c.add((Dependency)this.createServiceDependency().setService(IInventoryShimInternalListener.class, "(scope=Global)").setCallbacks("setInventoryShimGlobalInternalListener", "unsetInventoryShimGlobalInternalListener").setRequired(true));
            c.add((Dependency)this.createServiceDependency().setService(IInventoryShimExternalListener.class).setCallbacks("setInventoryShimExternalListener", "unsetInventoryShimExternalListener").setRequired(false));
            c.add((Dependency)this.createServiceDependency().setService(IPluginOutConnectionService.class).setCallbacks("setIPluginOutConnectionService", "unsetIPluginOutConnectionService").setRequired(true));
        }
        if (imp.equals(TopologyServiceShim.class)) {
            c.setInterface(new String[]{IDiscoveryListener.class.getName(), IContainerListener.class.getName(), IRefreshInternalProvider.class.getName(), IInventoryShimExternalListener.class.getName(), IContainerAware.class.getName()}, null);
            c.add((Dependency)this.createServiceDependency().setService(ITopologyServiceShimListener.class).setCallbacks("setTopologyServiceShimListener", "unsetTopologyServiceShimListener").setRequired(true));
            c.add((Dependency)this.createServiceDependency().setService(IOFStatisticsManager.class).setCallbacks("setStatisticsManager", "unsetStatisticsManager").setRequired(false));
        }
    }
}

