/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.core.internal;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import org.opendaylight.controller.protocol_plugin.openflow.core.ISwitch;
import org.openflow.protocol.OFBarrierRequest;
import org.openflow.protocol.OFError;
import org.openflow.protocol.OFMessage;

public class SynchronousMessage
implements Callable<Object> {
    private ISwitch sw;
    private Integer xid;
    private OFMessage syncMsg;
    protected CountDownLatch latch;
    private Object result;
    private boolean syncRequest;

    public SynchronousMessage(ISwitch sw, Integer xid, OFMessage msg, boolean syncRequest) {
        this.sw = sw;
        this.xid = xid;
        this.syncMsg = msg;
        this.latch = new CountDownLatch(1);
        this.result = null;
        this.syncRequest = syncRequest;
    }

    @Override
    public Object call() throws Exception {
        if (this.syncRequest) {
            this.sw.asyncSend(this.syncMsg, this.xid);
            if (!(this.syncMsg instanceof OFBarrierRequest)) {
                OFBarrierRequest barrierMsg = new OFBarrierRequest();
                this.sw.asyncSend((OFMessage)barrierMsg, this.xid);
            }
        }
        this.latch.await();
        return this.result;
    }

    public Integer getXid() {
        return this.xid;
    }

    public void wakeup() {
        this.latch.countDown();
    }

    public void wakeup(OFError e) {
        this.result = e;
        this.wakeup();
    }
}

