/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.core.internal;

import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.opendaylight.controller.protocol_plugin.openflow.core.IController;
import org.opendaylight.controller.protocol_plugin.openflow.core.IMessageReadWrite;
import org.opendaylight.controller.protocol_plugin.openflow.core.ISwitch;
import org.opendaylight.controller.protocol_plugin.openflow.core.internal.Controller;
import org.opendaylight.controller.protocol_plugin.openflow.core.internal.MessageReadWriteService;
import org.opendaylight.controller.protocol_plugin.openflow.core.internal.PriorityMessage;
import org.opendaylight.controller.protocol_plugin.openflow.core.internal.SecureMessageReadWriteService;
import org.opendaylight.controller.protocol_plugin.openflow.core.internal.StatisticsCollector;
import org.opendaylight.controller.protocol_plugin.openflow.core.internal.SynchronousMessage;
import org.openflow.protocol.OFBarrierReply;
import org.openflow.protocol.OFBarrierRequest;
import org.openflow.protocol.OFEchoReply;
import org.openflow.protocol.OFEchoRequest;
import org.openflow.protocol.OFError;
import org.openflow.protocol.OFFeaturesReply;
import org.openflow.protocol.OFFlowMod;
import org.openflow.protocol.OFGetConfigReply;
import org.openflow.protocol.OFMatch;
import org.openflow.protocol.OFMessage;
import org.openflow.protocol.OFPhysicalPort;
import org.openflow.protocol.OFPort;
import org.openflow.protocol.OFPortStatus;
import org.openflow.protocol.OFSetConfig;
import org.openflow.protocol.OFStatisticsReply;
import org.openflow.protocol.OFStatisticsRequest;
import org.openflow.protocol.OFType;
import org.openflow.protocol.factory.BasicFactory;
import org.openflow.util.HexString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchHandler
implements ISwitch {
    private static final Logger logger = LoggerFactory.getLogger(SwitchHandler.class);
    private static final int SWITCH_LIVENESS_TIMER = 5000;
    private static final int switchLivenessTimeout = SwitchHandler.getSwitchLivenessTimeout();
    private final int MESSAGE_RESPONSE_TIMER = 2000;
    private final String instanceName;
    private final ISwitch thisISwitch;
    private final IController core;
    private Long sid;
    private Integer buffers;
    private Integer capabilities;
    private Byte tables;
    private Integer actions;
    private Selector selector;
    private final SocketChannel socket;
    private final BasicFactory factory;
    private final AtomicInteger xid;
    private SwitchState state;
    private Timer periodicTimer;
    private final Map<Short, OFPhysicalPort> physicalPorts;
    private final Map<Short, Integer> portBandwidth;
    private final Date connectedDate;
    private Long lastMsgReceivedTimeStamp;
    private Boolean probeSent;
    private final ExecutorService executor;
    private final ConcurrentHashMap<Integer, Callable<Object>> messageWaitingDone;
    private boolean running;
    private IMessageReadWrite msgReadWriteService;
    private Thread switchHandlerThread;
    private Integer responseTimerValue;
    private PriorityBlockingQueue<PriorityMessage> transmitQ;
    private Thread transmitThread;

    public SwitchHandler(Controller core, SocketChannel sc, String name) {
        this.instanceName = name;
        this.thisISwitch = this;
        this.sid = 0L;
        this.buffers = 0;
        this.capabilities = 0;
        this.tables = 0;
        this.actions = 0;
        this.core = core;
        this.socket = sc;
        this.factory = new BasicFactory();
        this.connectedDate = new Date();
        this.lastMsgReceivedTimeStamp = this.connectedDate.getTime();
        this.physicalPorts = new HashMap<Short, OFPhysicalPort>();
        this.portBandwidth = new HashMap<Short, Integer>();
        this.state = SwitchState.NON_OPERATIONAL;
        this.probeSent = false;
        this.xid = new AtomicInteger(this.socket.hashCode());
        this.periodicTimer = null;
        this.executor = Executors.newFixedThreadPool(4);
        this.messageWaitingDone = new ConcurrentHashMap();
        this.responseTimerValue = 2000;
        String rTimer = System.getProperty("of.messageResponseTimer");
        if (rTimer != null) {
            try {
                this.responseTimerValue = Integer.decode(rTimer);
            }
            catch (NumberFormatException e) {
                logger.warn("Invalid of.messageResponseTimer: {} use default({})", (Object)rTimer, (Object)2000);
            }
        }
    }

    public void start() {
        try {
            this.startTransmitThread();
            this.setupCommChannel();
            this.sendFirstHello();
            this.startHandlerThread();
        }
        catch (Exception e) {
            this.reportError(e);
        }
    }

    private void startHandlerThread() {
        this.switchHandlerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                SwitchHandler.this.running = true;
                while (SwitchHandler.this.running) {
                    try {
                        SwitchHandler.this.selector.select(0L);
                        Iterator<SelectionKey> selectedKeys = SwitchHandler.this.selector.selectedKeys().iterator();
                        while (selectedKeys.hasNext()) {
                            SelectionKey skey = selectedKeys.next();
                            selectedKeys.remove();
                            if (skey.isValid() && skey.isWritable()) {
                                SwitchHandler.this.resumeSend();
                            }
                            if (!skey.isValid() || !skey.isReadable()) continue;
                            SwitchHandler.this.handleMessages();
                        }
                    }
                    catch (Exception e) {
                        SwitchHandler.this.reportError(e);
                    }
                }
            }
        }, this.instanceName);
        this.switchHandlerThread.start();
    }

    private void stopInternal() {
        logger.debug("{} receives stop signal", (Object)(this.isOperational() ? HexString.toHexString((long)this.sid) : "unknown"));
        this.running = false;
        this.cancelSwitchTimer();
        try {
            this.selector.wakeup();
            this.selector.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.msgReadWriteService.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.debug("executor shutdown now");
        this.executor.shutdownNow();
        this.msgReadWriteService = null;
    }

    public void stop() {
        this.stopInternal();
        if (this.switchHandlerThread != null) {
            this.switchHandlerThread.interrupt();
        }
        if (this.transmitThread != null) {
            this.transmitThread.interrupt();
        }
    }

    @Override
    public int getNextXid() {
        return this.xid.incrementAndGet();
    }

    @Override
    public Integer asyncSend(OFMessage msg) {
        return this.asyncSend(msg, this.getNextXid());
    }

    private Object syncSend(OFMessage msg, int xid) {
        return this.syncMessageInternal(msg, xid, true);
    }

    @Override
    public Integer asyncSend(OFMessage msg, int xid) {
        msg.setXid(xid);
        if (this.transmitQ != null) {
            this.transmitQ.add(new PriorityMessage(msg, 0));
        }
        return xid;
    }

    @Override
    public Integer asyncFastSend(OFMessage msg) {
        return this.asyncFastSend(msg, this.getNextXid());
    }

    @Override
    public Integer asyncFastSend(OFMessage msg, int xid) {
        msg.setXid(xid);
        if (this.transmitQ != null) {
            this.transmitQ.add(new PriorityMessage(msg, 1));
        }
        return xid;
    }

    public void resumeSend() {
        try {
            if (this.msgReadWriteService != null) {
                this.msgReadWriteService.resumeSend();
            }
        }
        catch (Exception e) {
            this.reportError(e);
        }
    }

    private void asyncSendNow(OFMessage msg, Integer xid) {
        if (xid == null) {
            xid = this.getNextXid();
        }
        msg.setXid(xid.intValue());
        this.asyncSendNow(msg);
    }

    private void asyncSendNow(OFMessage msg) {
        if (this.msgReadWriteService == null) {
            logger.warn("asyncSendNow: {} is not sent because Message ReadWrite Service is not available.", (Object)msg);
            return;
        }
        try {
            this.msgReadWriteService.asyncSend(msg);
        }
        catch (Exception e) {
            this.reportError(e);
        }
    }

    public void handleMessages() {
        List<OFMessage> msgs = null;
        try {
            if (this.msgReadWriteService != null) {
                msgs = this.msgReadWriteService.readMessages();
            }
        }
        catch (Exception e) {
            this.reportError(e);
        }
        if (msgs == null) {
            return;
        }
        for (OFMessage msg : msgs) {
            logger.trace("Message received: {}", (Object)msg);
            this.lastMsgReceivedTimeStamp = System.currentTimeMillis();
            OFType type = msg.getType();
            switch (type) {
                case HELLO: {
                    this.sendFeaturesRequest();
                    break;
                }
                case ECHO_REQUEST: {
                    OFEchoReply echoReply = (OFEchoReply)this.factory.getMessage(OFType.ECHO_REPLY);
                    byte[] payload = ((OFEchoRequest)msg).getPayload();
                    if (payload != null && payload.length != 0) {
                        echoReply.setPayload(payload);
                        echoReply.setLength((short)(echoReply.getLength() + payload.length));
                    }
                    this.asyncSendNow((OFMessage)echoReply, msg.getXid());
                    this.sendFeaturesRequest();
                    break;
                }
                case ECHO_REPLY: {
                    this.probeSent = false;
                    break;
                }
                case FEATURES_REPLY: {
                    this.processFeaturesReply((OFFeaturesReply)msg);
                    break;
                }
                case GET_CONFIG_REPLY: {
                    if (((OFGetConfigReply)msg).getMissSendLength() != -1) break;
                    this.state = SwitchState.OPERATIONAL;
                    break;
                }
                case BARRIER_REPLY: {
                    this.processBarrierReply((OFBarrierReply)msg);
                    break;
                }
                case ERROR: {
                    this.processErrorReply((OFError)msg);
                    break;
                }
                case PORT_STATUS: {
                    this.processPortStatusMsg((OFPortStatus)msg);
                    break;
                }
                case STATS_REPLY: {
                    this.processStatsReply((OFStatisticsReply)msg);
                    break;
                }
                case PACKET_IN: {
                    break;
                }
            }
            if (!this.isOperational()) continue;
            ((Controller)this.core).takeSwitchEventMsg(this.thisISwitch, msg);
        }
    }

    private void processPortStatusMsg(OFPortStatus msg) {
        OFPhysicalPort port = msg.getDesc();
        if (msg.getReason() == (byte)OFPortStatus.OFPortReason.OFPPR_MODIFY.ordinal()) {
            this.updatePhysicalPort(port);
        } else if (msg.getReason() == (byte)OFPortStatus.OFPortReason.OFPPR_ADD.ordinal()) {
            this.updatePhysicalPort(port);
        } else if (msg.getReason() == (byte)OFPortStatus.OFPortReason.OFPPR_DELETE.ordinal()) {
            this.deletePhysicalPort(port);
        }
    }

    private void startSwitchTimer() {
        this.periodicTimer = new Timer();
        this.periodicTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    Long now = System.currentTimeMillis();
                    if (now - SwitchHandler.this.lastMsgReceivedTimeStamp > (long)switchLivenessTimeout) {
                        if (SwitchHandler.this.probeSent.booleanValue()) {
                            logger.warn("{} sid {} is idle for too long, disconnect", (Object)SwitchHandler.this.socket.socket().getRemoteSocketAddress().toString().split("/")[1], (Object)(SwitchHandler.this.sid == 0L ? "unknown" : HexString.toHexString((long)SwitchHandler.this.sid)));
                            SwitchHandler.this.reportSwitchStateChange(false);
                        } else {
                            logger.debug("Send idle probe (Echo Request) to {}", (Object)this);
                            SwitchHandler.this.probeSent = true;
                            OFMessage echo = SwitchHandler.this.factory.getMessage(OFType.ECHO_REQUEST);
                            SwitchHandler.this.asyncFastSend(echo);
                        }
                    } else if (SwitchHandler.this.state == SwitchState.WAIT_FEATURES_REPLY) {
                        OFMessage request = SwitchHandler.this.factory.getMessage(OFType.FEATURES_REQUEST);
                        SwitchHandler.this.asyncFastSend(request);
                    } else if (SwitchHandler.this.state == SwitchState.WAIT_CONFIG_REPLY) {
                        OFSetConfig config = (OFSetConfig)SwitchHandler.this.factory.getMessage(OFType.SET_CONFIG);
                        config.setMissSendLength((short)-1).setLengthU(OFSetConfig.MINIMUM_LENGTH);
                        SwitchHandler.this.asyncFastSend((OFMessage)config);
                        OFMessage getConfig = SwitchHandler.this.factory.getMessage(OFType.GET_CONFIG_REQUEST);
                        SwitchHandler.this.asyncFastSend(getConfig);
                    }
                }
                catch (Exception e) {
                    SwitchHandler.this.reportError(e);
                }
            }
        }, 5000L, 5000L);
    }

    private void cancelSwitchTimer() {
        if (this.periodicTimer != null) {
            this.periodicTimer.cancel();
        }
    }

    private void reportError(Exception e) {
        if (!this.running) {
            logger.debug("Caught exception {} while switch {} is shutting down. Skip", (Object)e.getMessage(), (Object)(this.isOperational() ? HexString.toHexString((long)this.sid) : "unknown"));
            return;
        }
        logger.debug("Caught exception: ", (Throwable)e);
        ((Controller)this.core).takeSwitchEventError(this);
        this.stopInternal();
    }

    private void reportSwitchStateChange(boolean added) {
        if (added) {
            ((Controller)this.core).takeSwitchEventAdd(this);
        } else {
            ((Controller)this.core).takeSwitchEventDelete(this);
        }
    }

    @Override
    public Long getId() {
        return this.sid;
    }

    private void sendFeaturesRequest() {
        if (!this.isOperational() && this.state != SwitchState.WAIT_FEATURES_REPLY) {
            OFMessage featureRequest = this.factory.getMessage(OFType.FEATURES_REQUEST);
            this.asyncFastSend(featureRequest);
            this.state = SwitchState.WAIT_FEATURES_REPLY;
            this.startSwitchTimer();
        }
    }

    private void processFeaturesReply(OFFeaturesReply reply) {
        if (this.state == SwitchState.WAIT_FEATURES_REPLY) {
            this.sid = reply.getDatapathId();
            this.buffers = reply.getBuffers();
            this.capabilities = reply.getCapabilities();
            this.tables = reply.getTables();
            this.actions = reply.getActions();
            for (OFPhysicalPort port : reply.getPorts()) {
                this.updatePhysicalPort(port);
            }
            OFSetConfig config = (OFSetConfig)this.factory.getMessage(OFType.SET_CONFIG);
            config.setMissSendLength((short)-1).setLengthU(OFSetConfig.MINIMUM_LENGTH);
            this.asyncFastSend((OFMessage)config);
            OFMessage getConfig = this.factory.getMessage(OFType.GET_CONFIG_REQUEST);
            this.asyncFastSend(getConfig);
            this.state = SwitchState.WAIT_CONFIG_REPLY;
            this.reportSwitchStateChange(true);
        }
    }

    private void updatePhysicalPort(OFPhysicalPort port) {
        Short portNumber = port.getPortNumber();
        this.physicalPorts.put(portNumber, port);
        this.portBandwidth.put(portNumber, port.getCurrentFeatures() & (OFPhysicalPort.OFPortFeatures.OFPPF_10MB_FD.getValue() | OFPhysicalPort.OFPortFeatures.OFPPF_10MB_HD.getValue() | OFPhysicalPort.OFPortFeatures.OFPPF_100MB_FD.getValue() | OFPhysicalPort.OFPortFeatures.OFPPF_100MB_HD.getValue() | OFPhysicalPort.OFPortFeatures.OFPPF_1GB_FD.getValue() | OFPhysicalPort.OFPortFeatures.OFPPF_1GB_HD.getValue() | OFPhysicalPort.OFPortFeatures.OFPPF_10GB_FD.getValue()));
    }

    private void deletePhysicalPort(OFPhysicalPort port) {
        Short portNumber = port.getPortNumber();
        this.physicalPorts.remove(portNumber);
        this.portBandwidth.remove(portNumber);
    }

    @Override
    public boolean isOperational() {
        return this.state == SwitchState.WAIT_CONFIG_REPLY || this.state == SwitchState.OPERATIONAL;
    }

    public String toString() {
        try {
            return "Switch:" + this.socket.socket().getRemoteSocketAddress().toString().split("/")[1] + " SWID:" + (this.isOperational() ? HexString.toHexString((long)this.sid) : "unknown");
        }
        catch (Exception e) {
            return this.isOperational() ? HexString.toHexString((long)this.sid) : "unknown";
        }
    }

    @Override
    public Date getConnectedDate() {
        return this.connectedDate;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    @Override
    public Object getStatistics(OFStatisticsRequest req) {
        Future<Object> submit;
        int xid = this.getNextXid();
        StatisticsCollector worker = new StatisticsCollector(this, xid, req);
        this.messageWaitingDone.put(xid, worker);
        Object result = null;
        try {
            submit = this.executor.submit(worker);
        }
        catch (RejectedExecutionException re) {
            this.messageWaitingDone.remove(xid);
            return result;
        }
        try {
            result = submit.get(this.responseTimerValue.intValue(), TimeUnit.MILLISECONDS);
            return result;
        }
        catch (Exception e) {
            logger.warn("Timeout while waiting for {} replies from {}", (Object)req.getType(), (Object)(this.isOperational() ? HexString.toHexString((long)this.sid) : "unknown"));
            result = null;
            worker.wakeup();
            return result;
        }
    }

    @Override
    public Object syncSend(OFMessage msg) {
        if (!this.running) {
            logger.debug("Switch is going down, ignore syncSend");
            return null;
        }
        int xid = this.getNextXid();
        return this.syncSend(msg, xid);
    }

    private void processBarrierReply(OFBarrierReply msg) {
        Integer xid = msg.getXid();
        SynchronousMessage worker = (SynchronousMessage)this.messageWaitingDone.remove(xid);
        if (worker == null) {
            return;
        }
        worker.wakeup();
    }

    private void processErrorReply(OFError errorMsg) {
        OFMessage offendingMsg = errorMsg.getOffendingMsg();
        Integer xid = offendingMsg != null ? Integer.valueOf(offendingMsg.getXid()) : Integer.valueOf(errorMsg.getXid());
        Callable<Object> worker = this.messageWaitingDone.remove(xid);
        if (worker == null) {
            return;
        }
        if (worker instanceof SynchronousMessage) {
            ((SynchronousMessage)worker).wakeup(errorMsg);
        } else {
            ((StatisticsCollector)worker).wakeup(errorMsg);
        }
    }

    private void processStatsReply(OFStatisticsReply reply) {
        Integer xid = reply.getXid();
        StatisticsCollector worker = (StatisticsCollector)this.messageWaitingDone.get(xid);
        if (worker == null) {
            return;
        }
        if (worker.collect(reply)) {
            this.messageWaitingDone.remove(xid);
            worker.wakeup();
        }
    }

    @Override
    public Map<Short, OFPhysicalPort> getPhysicalPorts() {
        return this.physicalPorts;
    }

    @Override
    public OFPhysicalPort getPhysicalPort(Short portNumber) {
        return this.physicalPorts.get(portNumber);
    }

    @Override
    public Integer getPortBandwidth(Short portNumber) {
        return this.portBandwidth.get(portNumber);
    }

    @Override
    public Set<Short> getPorts() {
        return this.physicalPorts.keySet();
    }

    @Override
    public Byte getTables() {
        return this.tables;
    }

    @Override
    public Integer getActions() {
        return this.actions;
    }

    @Override
    public Integer getCapabilities() {
        return this.capabilities;
    }

    @Override
    public Integer getBuffers() {
        return this.buffers;
    }

    @Override
    public boolean isPortEnabled(short portNumber) {
        return this.isPortEnabled(this.physicalPorts.get(portNumber));
    }

    @Override
    public boolean isPortEnabled(OFPhysicalPort port) {
        if (port == null) {
            return false;
        }
        int portConfig = port.getConfig();
        int portState = port.getState();
        if ((portConfig & OFPhysicalPort.OFPortConfig.OFPPC_PORT_DOWN.getValue()) > 0) {
            return false;
        }
        if ((portState & OFPhysicalPort.OFPortState.OFPPS_LINK_DOWN.getValue()) > 0) {
            return false;
        }
        return (portState & OFPhysicalPort.OFPortState.OFPPS_STP_MASK.getValue()) != OFPhysicalPort.OFPortState.OFPPS_STP_BLOCK.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OFPhysicalPort> getEnabledPorts() {
        ArrayList<OFPhysicalPort> result = new ArrayList<OFPhysicalPort>();
        Map<Short, OFPhysicalPort> map = this.physicalPorts;
        synchronized (map) {
            for (OFPhysicalPort port : this.physicalPorts.values()) {
                if (!this.isPortEnabled(port)) continue;
                result.add(port);
            }
        }
        return result;
    }

    private void startTransmitThread() {
        this.transmitQ = new PriorityBlockingQueue<PriorityMessage>(11, new Comparator<PriorityMessage>(){

            @Override
            public int compare(PriorityMessage p1, PriorityMessage p2) {
                if (p2.priority != p1.priority) {
                    return p2.priority - p1.priority;
                }
                return p2.seqNum < p1.seqNum ? 1 : -1;
            }
        });
        this.transmitThread = new Thread(new PriorityMessageTransmit());
        this.transmitThread.start();
    }

    private void setupCommChannel() throws Exception {
        this.selector = SelectorProvider.provider().openSelector();
        this.socket.configureBlocking(false);
        this.socket.socket().setTcpNoDelay(true);
        this.msgReadWriteService = this.getMessageReadWriteService();
    }

    private void sendFirstHello() {
        try {
            OFMessage msg = this.factory.getMessage(OFType.HELLO);
            this.asyncFastSend(msg);
        }
        catch (Exception e) {
            this.reportError(e);
        }
    }

    private IMessageReadWrite getMessageReadWriteService() throws Exception {
        String str = System.getProperty("secureChannelEnabled");
        return str != null && str.trim().equalsIgnoreCase("true") ? new SecureMessageReadWriteService(this.socket, this.selector) : new MessageReadWriteService(this.socket, this.selector);
    }

    @Override
    public Object syncSendBarrierMessage() {
        OFBarrierRequest barrierMsg = new OFBarrierRequest();
        return this.syncSend((OFMessage)barrierMsg);
    }

    @Override
    public Object asyncSendBarrierMessage() {
        if (this.transmitQ == null) {
            return Boolean.FALSE;
        }
        OFBarrierRequest barrierMsg = new OFBarrierRequest();
        int xid = this.getNextXid();
        barrierMsg.setXid(xid);
        this.transmitQ.add(new PriorityMessage((OFMessage)barrierMsg, 0, true));
        return Boolean.TRUE;
    }

    private static int getSwitchLivenessTimeout() {
        String timeout = System.getProperty("of.switchLivenessTimeout");
        int rv = 60500;
        try {
            if (timeout != null) {
                rv = Integer.parseInt(timeout);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rv;
    }

    private Object syncMessageInternal(OFMessage msg, int xid, boolean syncRequest) {
        Future<Object> submit;
        SynchronousMessage worker = new SynchronousMessage(this, xid, msg, syncRequest);
        this.messageWaitingDone.put(xid, worker);
        Object result = null;
        Boolean status = false;
        try {
            submit = this.executor.submit(worker);
        }
        catch (RejectedExecutionException re) {
            this.messageWaitingDone.remove(xid);
            return result;
        }
        try {
            result = submit.get(this.responseTimerValue.intValue(), TimeUnit.MILLISECONDS);
            this.messageWaitingDone.remove(xid);
            if (result == null) {
                status = true;
                result = status;
            } else if (logger.isDebugEnabled()) {
                logger.debug("Send {} failed --> {}", (Object)msg.getType(), result);
            }
            return result;
        }
        catch (Exception e) {
            logger.warn("Timeout while waiting for {} reply", (Object)msg.getType().toString());
            status = false;
            result = status;
            worker.wakeup();
            return result;
        }
    }

    @Override
    public void deleteAllFlows() {
        logger.trace("deleteAllFlows on switch {}", (Object)HexString.toHexString((long)this.sid));
        OFMatch match = new OFMatch().setWildcards(0x3FFFFF);
        OFFlowMod flowMod = (OFFlowMod)this.factory.getMessage(OFType.FLOW_MOD);
        flowMod.setMatch(match).setCommand((short)3).setOutPort(OFPort.OFPP_NONE).setLength((short)OFFlowMod.MINIMUM_LENGTH);
        this.asyncFastSend((OFMessage)flowMod);
    }

    class PriorityMessageTransmit
    implements Runnable {
        PriorityMessageTransmit() {
        }

        @Override
        public void run() {
            SwitchHandler.this.running = true;
            while (SwitchHandler.this.running) {
                try {
                    PriorityMessage pmsg = (PriorityMessage)SwitchHandler.this.transmitQ.take();
                    SwitchHandler.this.msgReadWriteService.asyncSend(pmsg.msg);
                    if (!pmsg.syncReply) continue;
                    SwitchHandler.this.syncMessageInternal(pmsg.msg, pmsg.msg.getXid(), false);
                }
                catch (InterruptedException ie) {
                    SwitchHandler.this.reportError(new InterruptedException("PriorityMessageTransmit thread interrupted"));
                }
                catch (Exception e) {
                    SwitchHandler.this.reportError(e);
                }
            }
            SwitchHandler.this.transmitQ = null;
        }
    }

    private static enum SwitchState {
        NON_OPERATIONAL(0),
        WAIT_FEATURES_REPLY(1),
        WAIT_CONFIG_REPLY(2),
        OPERATIONAL(3);

        private int value;

        private SwitchState(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }
}

