/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.core.internal;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import org.opendaylight.controller.protocol_plugin.openflow.core.ISwitch;
import org.openflow.protocol.OFError;
import org.openflow.protocol.OFMessage;
import org.openflow.protocol.OFStatisticsReply;
import org.openflow.protocol.OFStatisticsRequest;
import org.openflow.protocol.statistics.OFStatistics;

public class StatisticsCollector
implements Callable<Object> {
    private ISwitch sw;
    private Integer xid;
    private OFStatisticsRequest request;
    private CountDownLatch latch;
    private Object result;
    private List<OFStatistics> stats;

    public StatisticsCollector(ISwitch sw, int xid, OFStatisticsRequest request) {
        this.sw = sw;
        this.xid = xid;
        this.request = request;
        this.latch = new CountDownLatch(1);
        this.result = new Object();
        this.stats = new CopyOnWriteArrayList<OFStatistics>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean collect(OFStatisticsReply reply) {
        Object object = this.result;
        synchronized (object) {
            this.stats.addAll(reply.getStatistics());
            if ((reply.getFlags() & 1) == 0) {
                this.result = this.stats;
                return true;
            }
            return false;
        }
    }

    @Override
    public Object call() throws Exception {
        this.sw.asyncSend((OFMessage)this.request, this.xid);
        this.request = null;
        this.latch.await();
        return this.result;
    }

    public Integer getXid() {
        return this.xid;
    }

    public void wakeup() {
        this.latch.countDown();
    }

    public void wakeup(OFError errorMsg) {
        this.result = errorMsg;
        this.wakeup();
    }
}

