/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.core.internal;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManagerFactory;
import org.opendaylight.controller.protocol_plugin.openflow.core.IMessageReadWrite;
import org.openflow.protocol.OFMessage;
import org.openflow.protocol.factory.BasicFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureMessageReadWriteService
implements IMessageReadWrite {
    private static final Logger logger = LoggerFactory.getLogger(SecureMessageReadWriteService.class);
    private Selector selector;
    private SocketChannel socket;
    private BasicFactory factory;
    private SSLEngine sslEngine;
    private SSLEngineResult sslEngineResult;
    private ByteBuffer myAppData;
    private ByteBuffer myNetData;
    private ByteBuffer peerAppData;
    private ByteBuffer peerNetData;
    private FileInputStream kfd = null;
    private FileInputStream tfd = null;

    public SecureMessageReadWriteService(SocketChannel socket, Selector selector) throws Exception {
        this.socket = socket;
        this.selector = selector;
        this.factory = new BasicFactory();
        try {
            this.createSecureChannel(socket);
            this.createBuffers(this.sslEngine);
        }
        catch (Exception e) {
            logger.warn("Failed to setup TLS connection {} {}", (Object)socket, (Object)e);
            this.stop();
            throw e;
        }
    }

    private void createSecureChannel(SocketChannel socket) throws Exception {
        String keyStoreFile = System.getProperty("controllerKeyStore");
        String keyStorePassword = System.getProperty("controllerKeyStorePassword");
        String trustStoreFile = System.getProperty("controllerTrustStore");
        String trustStorePassword = System.getProperty("controllerTrustStorePassword");
        if (keyStoreFile != null) {
            keyStoreFile = keyStoreFile.trim();
        }
        if (keyStoreFile == null || keyStoreFile.isEmpty()) {
            throw new FileNotFoundException("TLS KeyStore file not found.");
        }
        if (keyStorePassword != null) {
            keyStorePassword = keyStorePassword.trim();
        }
        if (keyStorePassword == null || keyStorePassword.isEmpty()) {
            throw new FileNotFoundException("TLS KeyStore Password not provided.");
        }
        if (trustStoreFile != null) {
            trustStoreFile = trustStoreFile.trim();
        }
        if (trustStoreFile == null || trustStoreFile.isEmpty()) {
            throw new FileNotFoundException("TLS TrustStore file not found");
        }
        if (trustStorePassword != null) {
            trustStorePassword = trustStorePassword.trim();
        }
        if (trustStorePassword == null || trustStorePassword.isEmpty()) {
            throw new FileNotFoundException("TLS TrustStore Password not provided.");
        }
        KeyStore ks = KeyStore.getInstance("JKS");
        KeyStore ts = KeyStore.getInstance("JKS");
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        this.kfd = new FileInputStream(keyStoreFile);
        this.tfd = new FileInputStream(trustStoreFile);
        ks.load(this.kfd, keyStorePassword.toCharArray());
        ts.load(this.tfd, trustStorePassword.toCharArray());
        kmf.init(ks, keyStorePassword.toCharArray());
        tmf.init(ts);
        SecureRandom random = new SecureRandom();
        random.nextInt();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), random);
        this.sslEngine = sslContext.createSSLEngine();
        this.sslEngine.setUseClientMode(false);
        this.sslEngine.setNeedClientAuth(true);
        this.sslEngine.setEnabledCipherSuites(new String[]{"SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", "TLS_EMPTY_RENEGOTIATION_INFO_SCSV"});
        this.doHandshake(socket, this.sslEngine);
        this.socket.register(this.selector, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncSend(OFMessage msg) throws Exception {
        ByteBuffer byteBuffer = this.myAppData;
        synchronized (byteBuffer) {
            int msgLen = msg.getLengthU();
            if (this.myAppData.remaining() < msgLen) {
                ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.myAppData.capacity() + msgLen);
                this.myAppData.flip();
                newBuffer.put(this.myAppData);
                this.myAppData = newBuffer;
            }
        }
        byteBuffer = this.myAppData;
        synchronized (byteBuffer) {
            msg.writeTo(this.myAppData);
            this.myAppData.flip();
            this.sslEngineResult = this.sslEngine.wrap(this.myAppData, this.myNetData);
            logger.trace("asyncSend sslEngine wrap: {}", (Object)this.sslEngineResult);
            this.runDelegatedTasks(this.sslEngineResult, this.sslEngine);
            if (!this.socket.isOpen()) {
                return;
            }
            this.myNetData.flip();
            this.socket.write(this.myNetData);
            if (this.myNetData.hasRemaining()) {
                this.myNetData.compact();
            } else {
                this.myNetData.clear();
            }
            if (this.myAppData.hasRemaining()) {
                this.myAppData.compact();
                this.socket.register(this.selector, 4, this);
            } else {
                this.myAppData.clear();
                this.socket.register(this.selector, 1, this);
            }
            logger.trace("Message sent: {}", (Object)msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeSend() throws Exception {
        ByteBuffer byteBuffer = this.myAppData;
        synchronized (byteBuffer) {
            this.myAppData.flip();
            this.sslEngineResult = this.sslEngine.wrap(this.myAppData, this.myNetData);
            logger.trace("resumeSend sslEngine wrap: {}", (Object)this.sslEngineResult);
            this.runDelegatedTasks(this.sslEngineResult, this.sslEngine);
            if (!this.socket.isOpen()) {
                return;
            }
            this.myNetData.flip();
            this.socket.write(this.myNetData);
            if (this.myNetData.hasRemaining()) {
                this.myNetData.compact();
            } else {
                this.myNetData.clear();
            }
            if (this.myAppData.hasRemaining()) {
                this.myAppData.compact();
                this.socket.register(this.selector, 4, this);
            } else {
                this.myAppData.clear();
                this.socket.register(this.selector, 1, this);
            }
        }
    }

    @Override
    public List<OFMessage> readMessages() throws Exception {
        if (!this.socket.isOpen()) {
            return null;
        }
        List msgs = null;
        int bytesRead = -1;
        int countDown = 50;
        bytesRead = this.socket.read(this.peerNetData);
        if (bytesRead < 0) {
            logger.debug("Message read operation failed");
            throw new AsynchronousCloseException();
        }
        do {
            this.peerNetData.flip();
            this.sslEngineResult = this.sslEngine.unwrap(this.peerNetData, this.peerAppData);
            if (this.peerNetData.hasRemaining()) {
                this.peerNetData.compact();
            } else {
                this.peerNetData.clear();
            }
            logger.trace("sslEngine unwrap result: {}", (Object)this.sslEngineResult);
            this.runDelegatedTasks(this.sslEngineResult, this.sslEngine);
        } while (this.sslEngineResult.getStatus() == SSLEngineResult.Status.OK && this.peerNetData.hasRemaining() && --countDown > 0);
        if (countDown == 0) {
            logger.trace("countDown reaches 0. peerNetData pos {} lim {}", (Object)this.peerNetData.position(), (Object)this.peerNetData.limit());
        }
        try {
            this.peerAppData.flip();
            msgs = this.factory.parseMessages(this.peerAppData);
            if (this.peerAppData.hasRemaining()) {
                this.peerAppData.compact();
            } else {
                this.peerAppData.clear();
            }
        }
        catch (Exception e) {
            this.peerAppData.clear();
            logger.debug("Caught exception: ", (Throwable)e);
        }
        this.socket.register(this.selector, 1, this);
        return msgs;
    }

    private void runDelegatedTasks(SSLEngineResult result, SSLEngine engine) throws Exception {
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            Runnable runnable;
            while ((runnable = engine.getDelegatedTask()) != null) {
                logger.debug("\trunning delegated task...");
                runnable.run();
            }
            SSLEngineResult.HandshakeStatus hsStatus = engine.getHandshakeStatus();
            if (hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                throw new Exception("handshake shouldn't need additional tasks");
            }
            logger.debug("\tnew HandshakeStatus: {}", (Object)hsStatus);
        }
    }

    private void doHandshake(SocketChannel socket, SSLEngine engine) throws Exception {
        SSLSession session = engine.getSession();
        ByteBuffer myAppData = ByteBuffer.allocate(session.getApplicationBufferSize());
        ByteBuffer peerAppData = ByteBuffer.allocate(session.getApplicationBufferSize());
        ByteBuffer myNetData = ByteBuffer.allocate(session.getPacketBufferSize());
        ByteBuffer peerNetData = ByteBuffer.allocate(session.getPacketBufferSize());
        engine.beginHandshake();
        SSLEngineResult.HandshakeStatus hs = engine.getHandshakeStatus();
        while (hs != SSLEngineResult.HandshakeStatus.FINISHED && hs != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            switch (hs) {
                case NEED_UNWRAP: {
                    if (socket.read(peerNetData) < 0) {
                        throw new AsynchronousCloseException();
                    }
                    peerNetData.flip();
                    SSLEngineResult res = engine.unwrap(peerNetData, peerAppData);
                    peerNetData.compact();
                    hs = res.getHandshakeStatus();
                    switch (res.getStatus()) {
                        default: 
                    }
                    break;
                }
                case NEED_WRAP: {
                    myNetData.clear();
                    SSLEngineResult res = engine.wrap(myAppData, myNetData);
                    hs = res.getHandshakeStatus();
                    switch (res.getStatus()) {
                        case OK: {
                            myNetData.flip();
                            while (myNetData.hasRemaining()) {
                                if (socket.write(myNetData) >= 0) continue;
                                throw new AsynchronousCloseException();
                            }
                            break;
                        }
                    }
                    break;
                }
                case NEED_TASK: {
                    Runnable runnable;
                    while ((runnable = engine.getDelegatedTask()) != null) {
                        logger.debug("\trunning delegated task...");
                        runnable.run();
                    }
                    hs = engine.getHandshakeStatus();
                    if (hs == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                        throw new Exception("handshake shouldn't need additional tasks");
                    }
                    logger.debug("\tnew HandshakeStatus: {}", (Object)hs);
                }
            }
        }
    }

    private void createBuffers(SSLEngine engine) {
        SSLSession session = engine.getSession();
        this.myAppData = ByteBuffer.allocate(session.getApplicationBufferSize());
        this.peerAppData = ByteBuffer.allocate(session.getApplicationBufferSize());
        this.myNetData = ByteBuffer.allocate(session.getPacketBufferSize());
        this.peerNetData = ByteBuffer.allocate(session.getPacketBufferSize());
    }

    @Override
    public void stop() throws IOException {
        this.sslEngine = null;
        this.sslEngineResult = null;
        this.myAppData = null;
        this.myNetData = null;
        this.peerAppData = null;
        this.peerNetData = null;
        if (this.kfd != null) {
            this.kfd.close();
            this.kfd = null;
        }
        if (this.tfd != null) {
            this.tfd.close();
            this.tfd = null;
        }
    }
}

