/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.core.internal;

import java.util.concurrent.atomic.AtomicLong;
import org.openflow.protocol.OFMessage;

class PriorityMessage {
    OFMessage msg;
    int priority;
    static final AtomicLong seq = new AtomicLong();
    final long seqNum;
    boolean syncReply;

    public PriorityMessage(OFMessage msg, int priority) {
        this.msg = msg;
        this.priority = priority;
        this.seqNum = seq.getAndIncrement();
        this.syncReply = false;
    }

    public PriorityMessage(OFMessage msg, int priority, boolean syncReply) {
        this(msg, priority);
        this.syncReply = syncReply;
    }

    public OFMessage getMsg() {
        return this.msg;
    }

    public void setMsg(OFMessage msg) {
        this.msg = msg;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.msg == null ? 0 : this.msg.hashCode());
        result = 31 * result + this.priority;
        result = 31 * result + (int)(this.seqNum ^ this.seqNum >>> 32);
        result = 31 * result + (this.syncReply ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PriorityMessage other = (PriorityMessage)obj;
        if (this.msg == null ? other.msg != null : !this.msg.equals((Object)other.msg)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.seqNum != other.seqNum) {
            return false;
        }
        return this.syncReply == other.syncReply;
    }

    public String toString() {
        return "PriorityMessage [msg=" + this.msg + ", priority=" + this.priority + ", seqNum=" + this.seqNum + ", syncReply=" + this.syncReply + "]";
    }
}

