/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.core.internal;

import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.List;
import org.opendaylight.controller.protocol_plugin.openflow.core.IMessageReadWrite;
import org.openflow.protocol.OFMessage;
import org.openflow.protocol.factory.BasicFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageReadWriteService
implements IMessageReadWrite {
    private static final Logger logger = LoggerFactory.getLogger(MessageReadWriteService.class);
    private static final int bufferSize = 0x100000;
    private Selector selector;
    private SelectionKey clientSelectionKey;
    private SocketChannel socket;
    private ByteBuffer inBuffer;
    private ByteBuffer outBuffer;
    private BasicFactory factory;

    public MessageReadWriteService(SocketChannel socket, Selector selector) throws ClosedChannelException {
        this.socket = socket;
        this.selector = selector;
        this.factory = new BasicFactory();
        this.inBuffer = ByteBuffer.allocateDirect(0x100000);
        this.outBuffer = ByteBuffer.allocateDirect(0x100000);
        this.clientSelectionKey = this.socket.register(this.selector, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncSend(OFMessage msg) throws Exception {
        ByteBuffer byteBuffer = this.outBuffer;
        synchronized (byteBuffer) {
            int msgLen = msg.getLengthU();
            if (this.outBuffer.remaining() < msgLen) {
                ByteBuffer newBuffer = ByteBuffer.allocateDirect(this.outBuffer.capacity() + msgLen);
                this.outBuffer.flip();
                newBuffer.put(this.outBuffer);
                this.outBuffer = newBuffer;
            }
        }
        byteBuffer = this.outBuffer;
        synchronized (byteBuffer) {
            msg.writeTo(this.outBuffer);
            if (!this.socket.isOpen()) {
                return;
            }
            this.outBuffer.flip();
            this.socket.write(this.outBuffer);
            this.outBuffer.compact();
            if (this.outBuffer.position() > 0) {
                this.clientSelectionKey = this.socket.register(this.selector, 4, this);
            }
            logger.trace("Message sent: {}", (Object)msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeSend() throws Exception {
        ByteBuffer byteBuffer = this.outBuffer;
        synchronized (byteBuffer) {
            if (!this.socket.isOpen()) {
                return;
            }
            this.outBuffer.flip();
            this.socket.write(this.outBuffer);
            this.outBuffer.compact();
            this.clientSelectionKey = this.outBuffer.position() > 0 ? this.socket.register(this.selector, 4, this) : this.socket.register(this.selector, 1, this);
        }
    }

    @Override
    public List<OFMessage> readMessages() throws Exception {
        if (!this.socket.isOpen()) {
            return null;
        }
        List msgs = null;
        int bytesRead = -1;
        bytesRead = this.socket.read(this.inBuffer);
        if (bytesRead < 0) {
            throw new AsynchronousCloseException();
        }
        try {
            this.inBuffer.flip();
            msgs = this.factory.parseMessages(this.inBuffer);
            if (this.inBuffer.hasRemaining()) {
                this.inBuffer.compact();
            } else {
                this.inBuffer.clear();
            }
        }
        catch (Exception e) {
            this.inBuffer.clear();
            logger.debug("Caught exception: ", (Throwable)e);
        }
        return msgs;
    }

    @Override
    public void stop() {
        this.inBuffer = null;
        this.outBuffer = null;
    }
}

