/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.core.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Iterator;
import org.opendaylight.controller.protocol_plugin.openflow.core.IController;
import org.opendaylight.controller.protocol_plugin.openflow.core.internal.Controller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerIO {
    private static final Logger logger = LoggerFactory.getLogger(ControllerIO.class);
    private static Short defaultOpenFlowPort = 6633;
    private Short openFlowPort;
    private InetAddress controllerIP;
    private NetworkInterface netInt;
    private SelectionKey serverSelectionKey;
    private IController listener;
    private ServerSocketChannel serverSocket;
    private Selector selector;
    private boolean running;
    private Thread controllerIOThread;

    public ControllerIO(IController l) {
        String addressString;
        this.listener = l;
        this.openFlowPort = defaultOpenFlowPort;
        String portString = System.getProperty("of.listenPort");
        if (portString != null) {
            try {
                this.openFlowPort = (short)Short.decode(portString);
            }
            catch (NumberFormatException e) {
                logger.warn("Invalid port:{}, use default({})", (Object)portString, (Object)this.openFlowPort);
            }
        }
        if ((addressString = System.getProperty("of.address")) != null) {
            try {
                this.controllerIP = InetAddress.getByName(addressString);
            }
            catch (Exception e) {
                this.controllerIP = null;
                logger.warn("Invalid IP: {}, use wildcard *", (Object)addressString);
            }
        } else {
            this.controllerIP = null;
        }
    }

    public void start() throws IOException {
        this.running = true;
        this.netInt = null;
        this.controllerIOThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ControllerIO.this.waitUntilInterfaceUp();
                if (!ControllerIO.this.startAcceptConnections()) {
                    return;
                }
                logger.info("Controller is now listening on {}:{}", (Object)(ControllerIO.this.controllerIP == null ? "any" : ControllerIO.this.controllerIP.getHostAddress()), (Object)ControllerIO.this.openFlowPort);
                boolean netInterfaceUp = true;
                while (ControllerIO.this.running) {
                    try {
                        ControllerIO.this.selector.select(5000L);
                        Iterator<SelectionKey> selectedKeys = ControllerIO.this.selector.selectedKeys().iterator();
                        netInterfaceUp = ControllerIO.this.isNetInterfaceUp(netInterfaceUp);
                        while (selectedKeys.hasNext()) {
                            SelectionKey skey = selectedKeys.next();
                            selectedKeys.remove();
                            if (!skey.isValid() || !skey.isAcceptable()) continue;
                            ((Controller)ControllerIO.this.listener).handleNewConnection(ControllerIO.this.selector, ControllerIO.this.serverSelectionKey);
                        }
                    }
                    catch (Exception e) {
                    }
                }
            }
        }, "ControllerI/O Thread");
        this.controllerIOThread.start();
    }

    private boolean startAcceptConnections() {
        if (this.running) {
            try {
                this.selector = SelectorProvider.provider().openSelector();
                this.serverSocket = ServerSocketChannel.open();
                this.serverSocket.configureBlocking(false);
                this.serverSocket.socket().bind(new InetSocketAddress(this.controllerIP, (int)this.openFlowPort.shortValue()));
                this.serverSocket.socket().setReuseAddress(true);
                this.serverSelectionKey = this.serverSocket.register(this.selector, 16);
            }
            catch (IOException e) {
                logger.error("Failed to listen on {}:{}, exit", (Object)(this.controllerIP == null ? "" : this.controllerIP.getHostAddress()), (Object)this.openFlowPort);
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isNetInterfaceUp(boolean currentlyUp) {
        boolean up;
        if (this.controllerIP == null) {
            return true;
        }
        try {
            if (this.netInt == null) {
                logger.warn("Can't find any operational interface for address {}", (Object)this.controllerIP.getHostAddress());
                return false;
            }
            up = this.netInt.isUp();
            if (!up) {
                logger.warn("Interface {} with address {} is DOWN!", (Object)this.netInt.getDisplayName(), (Object)this.controllerIP.getHostAddress());
            } else if (!currentlyUp) {
                logger.trace("Interface {} with address {} is UP!", (Object)this.netInt.getDisplayName(), (Object)this.controllerIP.getHostAddress());
            }
        }
        catch (SocketException e) {
            logger.warn("Interface {} with address {} is DOWN!", (Object)this.netInt.getDisplayName(), (Object)this.controllerIP.getHostAddress());
            up = false;
        }
        return up;
    }

    private void waitUntilInterfaceUp() {
        if (this.controllerIP == null) {
            return;
        }
        boolean isUp = false;
        do {
            try {
                this.netInt = NetworkInterface.getByInetAddress(this.controllerIP);
                isUp = this.isNetInterfaceUp(isUp);
                if (isUp) continue;
                Thread.sleep(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!isUp && this.running);
    }

    public void shutDown() throws IOException {
        this.running = false;
        this.selector.wakeup();
        this.serverSocket.close();
    }
}

