/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.protocol_plugin.openflow.core.internal;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.opendaylight.controller.protocol_plugin.openflow.core.IController;
import org.opendaylight.controller.protocol_plugin.openflow.core.IMessageListener;
import org.opendaylight.controller.protocol_plugin.openflow.core.ISwitch;
import org.opendaylight.controller.protocol_plugin.openflow.core.ISwitchStateListener;
import org.opendaylight.controller.protocol_plugin.openflow.core.internal.ControllerIO;
import org.opendaylight.controller.protocol_plugin.openflow.core.internal.SwitchEvent;
import org.opendaylight.controller.protocol_plugin.openflow.core.internal.SwitchHandler;
import org.opendaylight.controller.sal.connection.ConnectionConstants;
import org.opendaylight.controller.sal.connection.IPluginInConnectionService;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.openflow.protocol.OFMessage;
import org.openflow.protocol.OFType;
import org.openflow.util.HexString;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Controller
implements IController,
CommandProvider,
IPluginInConnectionService {
    private static final Logger logger = LoggerFactory.getLogger(Controller.class);
    private ControllerIO controllerIO;
    private Thread switchEventThread;
    private ConcurrentHashMap<Long, ISwitch> switches;
    private PriorityBlockingQueue<SwitchEvent> switchEvents;
    private ConcurrentMap<OFType, IMessageListener> messageListeners;
    private ISwitchStateListener switchStateListener;
    private AtomicInteger switchInstanceNumber;
    private int MAXQUEUESIZE = 50000;

    public void init() {
        logger.debug("Initializing!");
        this.switches = new ConcurrentHashMap();
        this.switchEvents = new PriorityBlockingQueue<SwitchEvent>(this.MAXQUEUESIZE, new Comparator<SwitchEvent>(){

            @Override
            public int compare(SwitchEvent p1, SwitchEvent p2) {
                return p2.getPriority() - p1.getPriority();
            }
        });
        this.messageListeners = new ConcurrentHashMap<OFType, IMessageListener>();
        this.switchStateListener = null;
        this.switchInstanceNumber = new AtomicInteger(0);
        this.registerWithOSGIConsole();
    }

    public void start() {
        logger.debug("Starting!");
        this.switchEventThread = new Thread((Runnable)new EventHandler(), "SwitchEvent Thread");
        this.switchEventThread.start();
        this.controllerIO = new ControllerIO(this);
        try {
            this.controllerIO.start();
        }
        catch (IOException ex) {
            logger.error("Caught exception while starting:", (Throwable)ex);
        }
    }

    public void stop() {
        Iterator<Map.Entry<Long, ISwitch>> it = this.switches.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, ISwitch> entry = it.next();
            ((SwitchHandler)entry.getValue()).stop();
            it.remove();
        }
        this.switchEventThread.interrupt();
        try {
            this.controllerIO.shutDown();
        }
        catch (IOException ex) {
            logger.error("Caught exception while stopping:", (Throwable)ex);
        }
    }

    public void destroy() {
    }

    @Override
    public void addMessageListener(OFType type, IMessageListener listener) {
        IMessageListener currentListener = (IMessageListener)this.messageListeners.get(type);
        if (currentListener != null) {
            logger.warn("{} is already listened by {}", (Object)type, (Object)currentListener);
        }
        this.messageListeners.put(type, listener);
        logger.debug("{} is now listened by {}", (Object)type, (Object)listener);
    }

    @Override
    public void removeMessageListener(OFType type, IMessageListener listener) {
        IMessageListener currentListener = (IMessageListener)this.messageListeners.get(type);
        if (currentListener != null && currentListener == listener) {
            logger.debug("{} listener {} is Removed", (Object)type, (Object)listener);
            this.messageListeners.remove(type);
        }
    }

    @Override
    public void addSwitchStateListener(ISwitchStateListener listener) {
        if (this.switchStateListener != null) {
            logger.warn("Switch events are already listened by {}", (Object)this.switchStateListener);
        }
        this.switchStateListener = listener;
        logger.debug("Switch events are now listened by {}", (Object)listener);
    }

    @Override
    public void removeSwitchStateListener(ISwitchStateListener listener) {
        if (this.switchStateListener != null && this.switchStateListener == listener) {
            logger.debug("SwitchStateListener {} is Removed", (Object)listener);
            this.switchStateListener = null;
        }
    }

    public void handleNewConnection(Selector selector, SelectionKey serverSelectionKey) {
        ServerSocketChannel ssc = (ServerSocketChannel)serverSelectionKey.channel();
        SocketChannel sc = null;
        try {
            sc = ssc.accept();
            int i = this.switchInstanceNumber.addAndGet(1);
            String instanceName = "SwitchHandler-" + i;
            SwitchHandler switchHandler = new SwitchHandler(this, sc, instanceName);
            switchHandler.start();
            if (sc.isConnected()) {
                logger.info("Switch:{} is connected to the Controller", (Object)sc.socket().getRemoteSocketAddress().toString().split("/")[1]);
            }
        }
        catch (IOException e) {
            return;
        }
    }

    private void disconnectSwitch(ISwitch sw) {
        Long sid;
        if (((SwitchHandler)sw).isOperational() && this.switches.remove(sid = sw.getId(), sw)) {
            logger.info("{} is removed", (Object)sw);
            this.notifySwitchDeleted(sw);
        }
        ((SwitchHandler)sw).stop();
        sw = null;
    }

    private void notifySwitchAdded(ISwitch sw) {
        if (this.switchStateListener != null) {
            this.switchStateListener.switchAdded(sw);
        }
    }

    private void notifySwitchDeleted(ISwitch sw) {
        if (this.switchStateListener != null) {
            this.switchStateListener.switchDeleted(sw);
        }
    }

    private synchronized void addSwitchEvent(SwitchEvent event) {
        this.switchEvents.put(event);
    }

    public void takeSwitchEventAdd(ISwitch sw) {
        SwitchEvent ev = new SwitchEvent(SwitchEvent.SwitchEventType.SWITCH_ADD, sw, null, SwitchEventPriority.HIGH.ordinal());
        this.addSwitchEvent(ev);
    }

    public void takeSwitchEventDelete(ISwitch sw) {
        SwitchEvent ev = new SwitchEvent(SwitchEvent.SwitchEventType.SWITCH_DELETE, sw, null, SwitchEventPriority.HIGH.ordinal());
        this.addSwitchEvent(ev);
    }

    public void takeSwitchEventError(ISwitch sw) {
        SwitchEvent ev = new SwitchEvent(SwitchEvent.SwitchEventType.SWITCH_ERROR, sw, null, SwitchEventPriority.NORMAL.ordinal());
        this.addSwitchEvent(ev);
    }

    public void takeSwitchEventMsg(ISwitch sw, OFMessage msg) {
        if (this.messageListeners.get(msg.getType()) != null) {
            SwitchEvent ev = new SwitchEvent(SwitchEvent.SwitchEventType.SWITCH_MESSAGE, sw, msg, SwitchEventPriority.LOW.ordinal());
            this.addSwitchEvent(ev);
        }
    }

    @Override
    public Map<Long, ISwitch> getSwitches() {
        return this.switches;
    }

    @Override
    public ISwitch getSwitch(Long switchId) {
        return this.switches.get(switchId);
    }

    public void _controllerShowQueueSize(CommandInterpreter ci) {
        ci.print((Object)("switchEvents queue size: " + this.switchEvents.size() + "\n"));
    }

    public void _controllerShowSwitches(CommandInterpreter ci) {
        Set sids = this.switches.keySet();
        StringBuffer s = new StringBuffer();
        int size = sids.size();
        if (size == 0) {
            ci.print((Object)"switches: empty");
            return;
        }
        Iterator iter = sids.iterator();
        s.append("Total: " + size + " switches\n");
        while (iter.hasNext()) {
            Long sid = (Long)iter.next();
            Date date = this.switches.get(sid).getConnectedDate();
            String switchInstanceName = ((SwitchHandler)this.switches.get(sid)).getInstanceName();
            s.append(switchInstanceName + "/" + HexString.toHexString((long)sid) + " connected since " + date.toString() + "\n");
        }
        ci.print((Object)s.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _controllerReset(CommandInterpreter ci) {
        ci.print((Object)"...Disconnecting the communication to all switches...\n");
        this.stop();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            ci.print((Object)"...start to accept connections from switches...\n");
            this.start();
        }
    }

    public void _controllerShowConnConfig(CommandInterpreter ci) {
        String str = System.getProperty("secureChannelEnabled");
        if (str != null && str.trim().equalsIgnoreCase("true")) {
            ci.print((Object)"The Controller and Switch should communicate through TLS connetion.\n");
            String keyStoreFile = System.getProperty("controllerKeyStore");
            String trustStoreFile = System.getProperty("controllerTrustStore");
            if (keyStoreFile == null || keyStoreFile.trim().isEmpty()) {
                ci.print((Object)"controllerKeyStore not specified\n");
            } else {
                ci.print((Object)("controllerKeyStore=" + keyStoreFile + "\n"));
            }
            if (trustStoreFile == null || trustStoreFile.trim().isEmpty()) {
                ci.print((Object)"controllerTrustStore not specified\n");
            } else {
                ci.print((Object)("controllerTrustStore=" + trustStoreFile + "\n"));
            }
        } else {
            ci.print((Object)"The Controller and Switch should communicate through TCP connetion.\n");
        }
    }

    private void registerWithOSGIConsole() {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        bundleContext.registerService(CommandProvider.class.getName(), (Object)this, null);
    }

    public String getHelp() {
        StringBuffer help = new StringBuffer();
        help.append("---Open Flow Controller---\n");
        help.append("\t controllerShowSwitches\n");
        help.append("\t controllerReset\n");
        help.append("\t controllerShowConnConfig\n");
        help.append("\t controllerShowQueueSize\n");
        return help.toString();
    }

    public Status disconnect(Node node) {
        ISwitch sw = this.getSwitch((Long)node.getID());
        if (sw != null) {
            this.disconnectSwitch(sw);
        }
        return new Status(StatusCode.SUCCESS);
    }

    public Node connect(String connectionIdentifier, Map<ConnectionConstants, String> params) {
        return null;
    }

    public void notifyClusterViewChanged() {
        for (ISwitch sw : this.switches.values()) {
            this.notifySwitchAdded(sw);
        }
    }

    public void notifyNodeDisconnectFromMaster(Node node) {
        ISwitch sw = this.switches.get((Long)node.getID());
        if (sw != null) {
            this.notifySwitchAdded(sw);
        }
    }

    private class EventHandler
    implements Runnable {
        private EventHandler() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                block8: while (true) {
                    SwitchEvent ev = (SwitchEvent)Controller.this.switchEvents.take();
                    SwitchEvent.SwitchEventType eType = ev.getEventType();
                    ISwitch sw = ev.getSwitch();
                    switch (eType) {
                        case SWITCH_ADD: {
                            Long sid = sw.getId();
                            ISwitch existingSwitch = (ISwitch)Controller.this.switches.get(sid);
                            if (existingSwitch != null) {
                                logger.info("Replacing existing {} with New {}", (Object)existingSwitch, (Object)sw);
                                Controller.this.disconnectSwitch(existingSwitch);
                            }
                            Controller.this.switches.put(sid, sw);
                            Controller.this.notifySwitchAdded(sw);
                            continue block8;
                        }
                        case SWITCH_DELETE: {
                            Controller.this.disconnectSwitch(sw);
                            continue block8;
                        }
                        case SWITCH_ERROR: {
                            Controller.this.disconnectSwitch(sw);
                            continue block8;
                        }
                        case SWITCH_MESSAGE: {
                            IMessageListener listener;
                            OFMessage msg = ev.getMsg();
                            if (msg == null || (listener = (IMessageListener)Controller.this.messageListeners.get(msg.getType())) == null) continue block8;
                            listener.receive(sw, msg);
                            continue block8;
                        }
                    }
                    logger.error("Unknown switch event {}", (Object)eType.ordinal());
                }
            }
            catch (InterruptedException e) {
                Controller.this.switchEvents.clear();
                return;
            }
        }
    }

    private static enum SwitchEventPriority {
        LOW,
        NORMAL,
        HIGH;

    }
}

