/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.threadgroup.rev131107.modules.module.configuration;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.netty.threadgroup.rev131107.modules.module.configuration.NettyThreadgroupFixed;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class NettyThreadgroupFixedBuilder {
    private Integer _threadCount;
    private Map<Class<? extends Augmentation<NettyThreadgroupFixed>>, Augmentation<NettyThreadgroupFixed>> augmentation = new HashMap<Class<? extends Augmentation<NettyThreadgroupFixed>>, Augmentation<NettyThreadgroupFixed>>();

    public Integer getThreadCount() {
        return this._threadCount;
    }

    public <E extends Augmentation<NettyThreadgroupFixed>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NettyThreadgroupFixedBuilder setThreadCount(Integer value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Integer("0"), (Comparable)new Integer("65535")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._threadCount = value;
        return this;
    }

    public NettyThreadgroupFixedBuilder addAugmentation(Class<? extends Augmentation<NettyThreadgroupFixed>> augmentationType, Augmentation<NettyThreadgroupFixed> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NettyThreadgroupFixed build() {
        return new NettyThreadgroupFixedImpl(this);
    }

    private static final class NettyThreadgroupFixedImpl
    implements NettyThreadgroupFixed {
        private final Integer _threadCount;
        private Map<Class<? extends Augmentation<NettyThreadgroupFixed>>, Augmentation<NettyThreadgroupFixed>> augmentation = new HashMap<Class<? extends Augmentation<NettyThreadgroupFixed>>, Augmentation<NettyThreadgroupFixed>>();

        public Class<NettyThreadgroupFixed> getImplementedInterface() {
            return NettyThreadgroupFixed.class;
        }

        private NettyThreadgroupFixedImpl(NettyThreadgroupFixedBuilder builder) {
            this._threadCount = builder.getThreadCount();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Integer getThreadCount() {
            return this._threadCount;
        }

        public <E extends Augmentation<NettyThreadgroupFixed>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._threadCount == null ? 0 : this._threadCount.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NettyThreadgroupFixedImpl other = (NettyThreadgroupFixedImpl)obj;
            if (this._threadCount == null ? other._threadCount != null : !this._threadCount.equals(other._threadCount)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("NettyThreadgroupFixed [_threadCount=");
            builder.append(this._threadCount);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

