/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.netty.threadgroup;

import io.netty.channel.nio.NioEventLoopGroup;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.JmxAttributeValidationException;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.yang.netty.threadgroup.AbstractNettyThreadgroupModule;

public final class NettyThreadgroupModule
extends AbstractNettyThreadgroupModule {
    public NettyThreadgroupModule(ModuleIdentifier name, DependencyResolver dependencyResolver) {
        super(name, dependencyResolver);
    }

    public NettyThreadgroupModule(ModuleIdentifier name, DependencyResolver dependencyResolver, NettyThreadgroupModule oldModule, AutoCloseable oldInstance) {
        super(name, dependencyResolver, oldModule, oldInstance);
    }

    @Override
    public void validate() {
        if (this.getThreadCount() != null) {
            JmxAttributeValidationException.checkCondition((this.getThreadCount() > 0 ? 1 : 0) != 0, (String)"value must be greater than 0", (JmxAttribute)this.threadCountJmxAttribute);
        }
    }

    @Override
    public AutoCloseable createInstance() {
        return this.getThreadCount() == null ? new NioEventLoopGroupCloseable() : new NioEventLoopGroupCloseable(this.getThreadCount());
    }

    private class NioEventLoopGroupCloseable
    extends NioEventLoopGroup
    implements AutoCloseable {
        public NioEventLoopGroupCloseable(int threadCount) {
            super(threadCount);
        }

        public NioEventLoopGroupCloseable() {
        }

        @Override
        public void close() throws Exception {
            this.shutdownGracefully();
        }
    }
}

