/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.netty.threadgroup;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.DependencyResolverFactory;
import org.opendaylight.controller.config.api.DynamicMBeanWithInstance;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.AbstractServiceInterface;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.opendaylight.controller.config.yang.netty.EventLoopGroupServiceInterface;
import org.opendaylight.controller.config.yang.netty.threadgroup.NettyThreadgroupModule;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.osgi.framework.BundleContext;

@ModuleQName(namespace="urn:opendaylight:params:xml:ns:yang:controller:netty:threadgroup", revision="2013-11-07", name="threadgroup")
public abstract class AbstractNettyThreadgroupModuleFactory
implements ModuleFactory {
    public static final String NAME = "netty-threadgroup-fixed";
    private static final Set<Class<? extends AbstractServiceInterface>> serviceIfcs;

    public final boolean isModuleImplementingServiceInterface(Class<? extends AbstractServiceInterface> serviceInterface) {
        for (Class<? extends AbstractServiceInterface> ifc : serviceIfcs) {
            if (!serviceInterface.isAssignableFrom(ifc)) continue;
            return true;
        }
        return false;
    }

    public Set<Class<? extends AbstractServiceInterface>> getImplementedServiceIntefaces() {
        return serviceIfcs;
    }

    public Module createModule(String instanceName, DependencyResolver dependencyResolver, BundleContext bundleContext) {
        return this.instantiateModule(instanceName, dependencyResolver, bundleContext);
    }

    public Module createModule(String instanceName, DependencyResolver dependencyResolver, DynamicMBeanWithInstance old, BundleContext bundleContext) throws Exception {
        NettyThreadgroupModule oldModule = null;
        try {
            oldModule = (NettyThreadgroupModule)old.getModule();
        }
        catch (Exception e) {
            return this.handleChangedClass(old);
        }
        NettyThreadgroupModule module = this.instantiateModule(instanceName, dependencyResolver, oldModule, old.getInstance(), bundleContext);
        module.setThreadCount(oldModule.getThreadCount());
        return module;
    }

    public NettyThreadgroupModule instantiateModule(String instanceName, DependencyResolver dependencyResolver, NettyThreadgroupModule oldModule, AutoCloseable oldInstance, BundleContext bundleContext) {
        return new NettyThreadgroupModule(new ModuleIdentifier(NAME, instanceName), dependencyResolver, oldModule, oldInstance);
    }

    public NettyThreadgroupModule instantiateModule(String instanceName, DependencyResolver dependencyResolver, BundleContext bundleContext) {
        return new NettyThreadgroupModule(new ModuleIdentifier(NAME, instanceName), dependencyResolver);
    }

    public final String getImplementationName() {
        return NAME;
    }

    public NettyThreadgroupModule handleChangedClass(DynamicMBeanWithInstance old) throws Exception {
        throw new UnsupportedOperationException("Class reloading is not supported");
    }

    public Set<NettyThreadgroupModule> getDefaultModules(DependencyResolverFactory dependencyResolverFactory, BundleContext bundleContext) {
        return new HashSet<NettyThreadgroupModule>();
    }

    static {
        HashSet<Class<EventLoopGroupServiceInterface>> serviceIfcs2 = new HashSet<Class<EventLoopGroupServiceInterface>>();
        serviceIfcs2.add(EventLoopGroupServiceInterface.class);
        serviceIfcs = Collections.unmodifiableSet(serviceIfcs2);
    }
}

