/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.netty.threadgroup;

import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.RuntimeBeanRegistratorAwareModule;
import org.opendaylight.controller.config.api.annotations.Description;
import org.opendaylight.controller.config.api.runtime.RootRuntimeBeanRegistrator;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.yang.netty.EventLoopGroupServiceInterface;
import org.opendaylight.controller.config.yang.netty.threadgroup.NettyThreadgroupModuleMXBean;
import org.opendaylight.controller.config.yang.netty.threadgroup.NettyThreadgroupRuntimeRegistrator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNettyThreadgroupModule
implements Module,
NettyThreadgroupModuleMXBean,
EventLoopGroupServiceInterface,
RuntimeBeanRegistratorAwareModule {
    protected final JmxAttribute threadCountJmxAttribute = new JmxAttribute("ThreadCount");
    private Integer threadCount;
    private static final Logger logger = LoggerFactory.getLogger(AbstractNettyThreadgroupModule.class);
    private final AbstractNettyThreadgroupModule oldModule;
    private final AutoCloseable oldInstance;
    private AutoCloseable instance;
    private final DependencyResolver dependencyResolver;
    private final ModuleIdentifier identifier;
    private NettyThreadgroupRuntimeRegistrator rootRuntimeBeanRegistratorWrapper;

    public AbstractNettyThreadgroupModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldInstance = null;
        this.oldModule = null;
    }

    public AbstractNettyThreadgroupModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractNettyThreadgroupModule oldModule, AutoCloseable oldInstance) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldInstance = oldInstance;
        this.oldModule = oldModule;
    }

    @Override
    public Integer getThreadCount() {
        return this.threadCount;
    }

    @Override
    @Description(value="Number of threads to be used by NioEventLoopGroup. This attribute is optional and default value will be 2* Number of CPUs")
    public void setThreadCount(Integer threadCount) {
        this.threadCount = threadCount;
    }

    public NettyThreadgroupRuntimeRegistrator getRootRuntimeBeanRegistratorWrapper() {
        return this.rootRuntimeBeanRegistratorWrapper;
    }

    public void setRuntimeBeanRegistrator(RootRuntimeBeanRegistrator rootRuntimeRegistrator) {
        this.rootRuntimeBeanRegistratorWrapper = new NettyThreadgroupRuntimeRegistrator(rootRuntimeRegistrator);
    }

    public void validate() {
        this.customValidation();
    }

    protected void customValidation() {
    }

    public final AutoCloseable getInstance() {
        if (this.instance == null) {
            if (this.oldInstance != null && this.canReuseInstance(this.oldModule)) {
                this.instance = this.reuseInstance(this.oldInstance);
            } else {
                if (this.oldInstance != null) {
                    try {
                        this.oldInstance.close();
                    }
                    catch (Exception e) {
                        logger.error("An error occurred while closing old instance " + this.oldInstance, (Throwable)e);
                    }
                }
                this.instance = this.createInstance();
            }
        }
        return this.instance;
    }

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    public boolean canReuseInstance(AbstractNettyThreadgroupModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public abstract AutoCloseable createInstance();

    public boolean isSame(AbstractNettyThreadgroupModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        return !(this.threadCount == null ? other.threadCount != null : !this.threadCount.equals(other.threadCount));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractNettyThreadgroupModule that = (AbstractNettyThreadgroupModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }
}

