/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util.repo;

import com.google.common.base.Optional;

public final class SourceIdentifier {
    private final String name;
    private final String revision;

    public SourceIdentifier(String name, Optional<String> formattedRevision) {
        this.name = name;
        this.revision = (String)formattedRevision.orNull();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.revision == null ? 0 : this.revision.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SourceIdentifier other = (SourceIdentifier)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.revision == null ? other.revision != null : !this.revision.equals(other.revision));
    }

    public String getName() {
        return this.name;
    }

    public String getRevision() {
        return this.revision;
    }

    public static SourceIdentifier create(String moduleName, Optional<String> revision) {
        return new SourceIdentifier(moduleName, revision);
    }

    public String toYangFilename() {
        return SourceIdentifier.toYangFileName(this.name, (Optional<String>)Optional.fromNullable((Object)this.revision));
    }

    public String toString() {
        return "SourceIdentifier [name=" + this.name + "@" + this.revision + "]";
    }

    public static final String toYangFileName(String moduleName, Optional<String> revision) {
        StringBuilder filename = new StringBuilder(moduleName);
        if (revision.isPresent()) {
            filename.append("@");
            filename.append((String)revision.get());
        }
        filename.append(".yang");
        return filename.toString();
    }
}

