/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util.repo;

import com.google.common.base.Optional;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.yang.model.util.repo.AdvancedSchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.util.repo.SchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.util.repo.SourceIdentifier;

public class SchemaSourceProviders {
    private static final SchemaSourceProvider NOOP_PROVIDER = new AdvancedSchemaSourceProvider(){

        @Override
        public Optional getSchemaSource(String moduleName, Optional revision) {
            return Optional.absent();
        }

        public Optional getSchemaSource(SourceIdentifier sourceIdentifier) {
            return Optional.absent();
        }
    };

    public static <T> SchemaSourceProvider<T> noopProvider() {
        return NOOP_PROVIDER;
    }

    public static SchemaSourceProvider<InputStream> inputStreamProviderfromStringProvider(AdvancedSchemaSourceProvider<String> delegate) {
        return new StringToInputStreamSchemaSourceProvider(delegate);
    }

    public static <O> AdvancedSchemaSourceProvider<O> toAdvancedSchemaSourceProvider(SchemaSourceProvider<O> schemaSourceProvider) {
        if (schemaSourceProvider instanceof AdvancedSchemaSourceProvider) {
            return (AdvancedSchemaSourceProvider)schemaSourceProvider;
        }
        return new SchemaSourceCompatibilityWrapper<O>(schemaSourceProvider);
    }

    private static final class SchemaSourceCompatibilityWrapper<O>
    implements AdvancedSchemaSourceProvider<O>,
    Delegator<SchemaSourceProvider<O>> {
        private final SchemaSourceProvider<O> delegate;

        public SchemaSourceCompatibilityWrapper(SchemaSourceProvider<O> delegate) {
            this.delegate = delegate;
        }

        public SchemaSourceProvider<O> getDelegate() {
            return this.delegate;
        }

        @Override
        public Optional<O> getSchemaSource(SourceIdentifier sourceIdentifier) {
            String moduleName = sourceIdentifier.getName();
            Optional revision = Optional.fromNullable((Object)sourceIdentifier.getRevision());
            return this.delegate.getSchemaSource(moduleName, (Optional<String>)revision);
        }

        @Override
        public Optional<O> getSchemaSource(String moduleName, Optional<String> revision) {
            return this.delegate.getSchemaSource(moduleName, revision);
        }
    }

    private static final class StringToInputStreamSchemaSourceProvider
    implements AdvancedSchemaSourceProvider<InputStream>,
    Delegator<AdvancedSchemaSourceProvider<String>> {
        private AdvancedSchemaSourceProvider<String> delegate;

        public StringToInputStreamSchemaSourceProvider(AdvancedSchemaSourceProvider<String> delegate) {
            this.delegate = delegate;
        }

        public AdvancedSchemaSourceProvider<String> getDelegate() {
            return this.delegate;
        }

        @Override
        public Optional<InputStream> getSchemaSource(SourceIdentifier sourceIdentifier) {
            Optional potentialSource = this.getDelegate().getSchemaSource(sourceIdentifier);
            if (potentialSource.isPresent()) {
                String stringSource = (String)potentialSource.get();
                StringBufferInputStream stringInputStream = new StringBufferInputStream(stringSource);
                return Optional.of((Object)stringInputStream);
            }
            return Optional.absent();
        }

        @Override
        public Optional<InputStream> getSchemaSource(String moduleName, Optional<String> revision) {
            return this.getSchemaSource(SourceIdentifier.create(moduleName, revision));
        }
    }
}

