/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util.repo;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.StringBufferInputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opendaylight.yangtools.yang.model.util.repo.AbstractCachingSchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.util.repo.AdvancedSchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.util.repo.SchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.util.repo.SchemaSourceProviders;
import org.opendaylight.yangtools.yang.model.util.repo.SourceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemSchemaCachingProvider<I>
extends AbstractCachingSchemaSourceProvider<I, InputStream> {
    private static final Logger LOG = LoggerFactory.getLogger(FilesystemSchemaCachingProvider.class);
    private final File storageDirectory;
    private final Function<I, String> transformationFunction;
    private static final Function<String, String> NOOP_TRANSFORMATION = new Function<String, String>(){

        public String apply(String input) {
            return input;
        }
    };

    public FilesystemSchemaCachingProvider(AdvancedSchemaSourceProvider<I> delegate, File directory, Function<I, String> transformationFunction) {
        super(delegate);
        this.storageDirectory = directory;
        this.transformationFunction = transformationFunction;
    }

    @Override
    protected synchronized Optional<InputStream> cacheSchemaSource(SourceIdentifier identifier, Optional<I> source) {
        block28: {
            File schemaFile = this.toFile(identifier);
            try {
                if (!source.isPresent() || !schemaFile.createNewFile()) break block28;
                try (FileOutputStream outStream = new FileOutputStream(schemaFile);
                     OutputStreamWriter writer = new OutputStreamWriter(outStream);){
                    writer.write(this.transformToString(source.get()));
                    writer.flush();
                }
                catch (IOException e) {}
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return this.transformToStream(source);
    }

    private Optional<InputStream> transformToStream(Optional<I> source) {
        if (source.isPresent()) {
            return Optional.of((Object)new StringBufferInputStream(this.transformToString(source.get())));
        }
        return Optional.absent();
    }

    private String transformToString(I input) {
        return (String)this.transformationFunction.apply(input);
    }

    @Override
    protected Optional<InputStream> getCachedSchemaSource(SourceIdentifier identifier) {
        File inputFile = this.toFile(identifier);
        try {
            if (inputFile.exists() && inputFile.canRead()) {
                FileInputStream stream = new FileInputStream(inputFile);
                return Optional.of((Object)stream);
            }
        }
        catch (FileNotFoundException e) {
            return Optional.absent();
        }
        return Optional.absent();
    }

    private File toFile(SourceIdentifier identifier) {
        File file = null;
        String rev = identifier.getRevision();
        file = rev == null || rev.isEmpty() ? this.findFileWithNewestRev(identifier) : new File(this.storageDirectory, identifier.toYangFilename());
        return file;
    }

    private File findFileWithNewestRev(final SourceIdentifier identifier) {
        File[] files = this.storageDirectory.listFiles(new FilenameFilter(){
            final String regex;
            {
                this.regex = identifier.getName() + "(\\.yang|@\\d\\d\\d\\d-\\d\\d-\\d\\d.yang)";
            }

            @Override
            public boolean accept(File dir, String name) {
                return name.matches(this.regex);
            }
        });
        if (files.length == 0) {
            return new File(this.storageDirectory, identifier.toYangFilename());
        }
        if (files.length == 1) {
            return files[0];
        }
        File file = null;
        Pattern p = Pattern.compile("\\d\\d\\d\\d-\\d\\d-\\d\\d");
        TreeMap<Date, File> map = new TreeMap<Date, File>();
        for (File sorted : files) {
            String fileName = sorted.getName();
            Matcher m = p.matcher(fileName);
            if (m.find()) {
                String revStr = m.group();
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    Date d = df.parse(revStr);
                    map.put(d, sorted);
                }
                catch (ParseException e) {
                    LOG.info("Unable to parse date from yang file name");
                    map.put(new Date(0L), sorted);
                }
                continue;
            }
            map.put(new Date(0L), sorted);
        }
        file = (File)map.lastEntry().getValue();
        return file;
    }

    public static FilesystemSchemaCachingProvider<String> createFromStringSourceProvider(SchemaSourceProvider<String> liveProvider, File directory) {
        Preconditions.checkNotNull(liveProvider);
        Preconditions.checkNotNull((Object)directory);
        directory.mkdirs();
        return new FilesystemSchemaCachingProvider<String>(SchemaSourceProviders.toAdvancedSchemaSourceProvider(liveProvider), directory, NOOP_TRANSFORMATION);
    }
}

