/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util.repo;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.yang.model.util.repo.AdvancedSchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.util.repo.SchemaSourceProvider;
import org.opendaylight.yangtools.yang.model.util.repo.SchemaSourceProviders;
import org.opendaylight.yangtools.yang.model.util.repo.SourceIdentifier;

public abstract class AbstractCachingSchemaSourceProvider<I, O>
implements AdvancedSchemaSourceProvider<O>,
Delegator<AdvancedSchemaSourceProvider<I>> {
    private final AdvancedSchemaSourceProvider<I> defaultDelegate;

    protected AbstractCachingSchemaSourceProvider(AdvancedSchemaSourceProvider<I> delegate) {
        this.defaultDelegate = delegate;
    }

    @Override
    public Optional<O> getSchemaSource(String moduleName, Optional<String> revision) {
        Preconditions.checkNotNull((Object)moduleName, (Object)"Module name should not be null.");
        Preconditions.checkNotNull(revision, (Object)"Revision should not be null");
        return this.getSchemaSource(SourceIdentifier.create(moduleName, revision));
    }

    @Override
    public Optional<O> getSchemaSource(SourceIdentifier sourceIdentifier) {
        return this.getSchemaSourceImpl(sourceIdentifier, this.defaultDelegate);
    }

    protected final Optional<O> getSchemaSourceImpl(SourceIdentifier identifier, AdvancedSchemaSourceProvider<I> delegate) {
        Preconditions.checkNotNull((Object)identifier, (Object)"Source identifier name should not be null.");
        Optional<O> cached = this.getCachedSchemaSource(identifier);
        if (cached.isPresent()) {
            return cached;
        }
        Optional<I> live = delegate.getSchemaSource(identifier);
        return this.cacheSchemaSource(identifier, live);
    }

    protected abstract Optional<O> cacheSchemaSource(SourceIdentifier var1, Optional<I> var2);

    protected abstract Optional<O> getCachedSchemaSource(SourceIdentifier var1);

    public AdvancedSchemaSourceProvider<I> getDelegate() {
        return this.defaultDelegate;
    }

    public SchemaSourceProvider<O> createInstanceFor(SchemaSourceProvider<I> delegate) {
        Preconditions.checkNotNull(delegate, (Object)"Delegate should not be null");
        return new SchemaSourceProviderInstance(SchemaSourceProviders.toAdvancedSchemaSourceProvider(delegate));
    }

    private class SchemaSourceProviderInstance
    implements AdvancedSchemaSourceProvider<O>,
    Delegator<AdvancedSchemaSourceProvider<I>> {
        private final AdvancedSchemaSourceProvider<I> delegate;

        protected SchemaSourceProviderInstance(AdvancedSchemaSourceProvider<I> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Optional<O> getSchemaSource(String moduleName, Optional<String> revision) {
            return this.getSchemaSource(SourceIdentifier.create(moduleName, revision));
        }

        public AdvancedSchemaSourceProvider<I> getDelegate() {
            return this.delegate;
        }

        @Override
        public Optional<O> getSchemaSource(SourceIdentifier sourceIdentifier) {
            return AbstractCachingSchemaSourceProvider.this.getSchemaSourceImpl(sourceIdentifier, this.getDelegate());
        }
    }

    public class CompatibilitySchemaSourceProviderInstance
    implements SchemaSourceProvider<O> {
        @Override
        public Optional<O> getSchemaSource(String moduleName, Optional<String> revision) {
            return null;
        }
    }
}

