/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;
import org.opendaylight.yangtools.yang.model.api.type.UnknownTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.BaseTypes;

public final class UnknownType
implements UnknownTypeDefinition {
    private final QName name;
    private final SchemaPath path;
    private final String description;
    private final String reference;
    private final List<LengthConstraint> lengthStatements;
    private final List<PatternConstraint> patterns;
    private final List<RangeConstraint> rangeStatements;
    private final List<UnknownSchemaNode> extensions;
    private final LengthConstraint lengthConstraint;
    private final Integer fractionDigits;
    private final Status status;
    private final String units;
    private final Object defaultValue;

    private UnknownType(Builder builder) {
        this.name = builder.name;
        this.path = builder.path;
        this.description = builder.description;
        this.reference = builder.reference;
        this.lengthStatements = builder.lengthStatements;
        this.patterns = builder.patterns;
        this.rangeStatements = builder.rangeStatements;
        this.extensions = builder.extensions;
        this.lengthConstraint = builder.lengthConstraint;
        this.status = builder.status;
        this.units = builder.units;
        this.defaultValue = builder.defaultValue;
        this.fractionDigits = builder.fractionDigits;
    }

    public UnknownTypeDefinition getBaseType() {
        return this;
    }

    public String getUnits() {
        return this.units;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public QName getQName() {
        return this.name;
    }

    public SchemaPath getPath() {
        return this.path;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReference() {
        return this.reference;
    }

    public Status getStatus() {
        return this.status;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.extensions;
    }

    public List<RangeConstraint> getRangeConstraints() {
        return this.rangeStatements;
    }

    public List<LengthConstraint> getLengthConstraints() {
        return this.lengthStatements;
    }

    public List<PatternConstraint> getPatternConstraints() {
        return this.patterns;
    }

    public Integer getFractionDigits() {
        return this.fractionDigits;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.extensions == null ? 0 : this.extensions.hashCode());
        result = 31 * result + (this.lengthConstraint == null ? 0 : this.lengthConstraint.hashCode());
        result = 31 * result + (this.lengthStatements == null ? 0 : this.lengthStatements.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.patterns == null ? 0 : this.patterns.hashCode());
        result = 31 * result + (this.rangeStatements == null ? 0 : this.rangeStatements.hashCode());
        result = 31 * result + (this.reference == null ? 0 : this.reference.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.units == null ? 0 : this.units.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnknownType other = (UnknownType)obj;
        if (this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.extensions == null ? other.extensions != null : !this.extensions.equals(other.extensions)) {
            return false;
        }
        if (this.lengthConstraint == null ? other.lengthConstraint != null : !this.lengthConstraint.equals(other.lengthConstraint)) {
            return false;
        }
        if (this.lengthStatements == null ? other.lengthStatements != null : !this.lengthStatements.equals(other.lengthStatements)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals((Object)other.name)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals((Object)other.path)) {
            return false;
        }
        if (this.patterns == null ? other.patterns != null : !this.patterns.equals(other.patterns)) {
            return false;
        }
        if (this.rangeStatements == null ? other.rangeStatements != null : !this.rangeStatements.equals(other.rangeStatements)) {
            return false;
        }
        if (this.reference == null ? other.reference != null : !this.reference.equals(other.reference)) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        return !(this.units == null ? other.units != null : !this.units.equals(other.units));
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("UnknownType [name=");
        builder2.append(this.name);
        builder2.append(", path=");
        builder2.append(this.path);
        builder2.append(", description=");
        builder2.append(this.description);
        builder2.append(", reference=");
        builder2.append(this.reference);
        builder2.append(", lengthStatements=");
        builder2.append(this.lengthStatements);
        builder2.append(", patterns=");
        builder2.append(this.patterns);
        builder2.append(", rangeStatements=");
        builder2.append(this.rangeStatements);
        builder2.append(", extensions=");
        builder2.append(this.extensions);
        builder2.append(", lengthConstraint=");
        builder2.append(this.lengthConstraint);
        builder2.append(", status=");
        builder2.append(this.status);
        builder2.append(", units=");
        builder2.append(this.units);
        builder2.append(", defaultValue=");
        builder2.append(this.defaultValue);
        builder2.append("]");
        return builder2.toString();
    }

    public static class Builder {
        private final QName name;
        private final SchemaPath path;
        private String description;
        private String reference;
        private List<LengthConstraint> lengthStatements = Collections.emptyList();
        private List<PatternConstraint> patterns = Collections.emptyList();
        private List<RangeConstraint> rangeStatements = Collections.emptyList();
        private List<UnknownSchemaNode> extensions = Collections.emptyList();
        private LengthConstraint lengthConstraint = null;
        private Integer fractionDigits = null;
        private Status status = Status.CURRENT;
        private String units = "";
        private Object defaultValue = null;

        public Builder(QName name, String description, String reference) {
            this.name = name;
            this.path = BaseTypes.schemaPath(name);
            this.description = description;
            this.reference = reference;
        }

        public Builder(QName name) {
            this.name = name;
            this.path = BaseTypes.schemaPath(name);
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder reference(String reference) {
            this.reference = reference;
            return this;
        }

        public Builder lengthStatements(List<LengthConstraint> lengthStatements) {
            this.lengthStatements = lengthStatements;
            return this;
        }

        public Builder patterns(List<PatternConstraint> patterns) {
            this.patterns = patterns;
            return this;
        }

        public Builder rangeStatements(List<RangeConstraint> rangeStatements) {
            this.rangeStatements = rangeStatements;
            return this;
        }

        public Builder extensions(List<UnknownSchemaNode> extensions) {
            this.extensions = extensions;
            return this;
        }

        public Builder lengthConstraint(LengthConstraint lengthConstraint) {
            this.lengthConstraint = lengthConstraint;
            return this;
        }

        public Builder fractionDigits(Integer fractionDigits) {
            this.fractionDigits = fractionDigits;
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder units(String units) {
            this.units = units;
            return this;
        }

        public Builder defaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public UnknownTypeDefinition build() {
            return new UnknownType(this);
        }
    }
}

