/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.BaseTypes;

public final class UnionType
implements UnionTypeDefinition {
    private final QName name = BaseTypes.constructQName("union");
    private final SchemaPath path = BaseTypes.schemaPath(this.name);
    private static final String DESCRIPTION = "The union built-in type represents a value that corresponds to one of its member types.";
    private static final String REFERENCE = "https://tools.ietf.org/html/rfc6020#section-9.12";
    private final List<TypeDefinition<?>> types;

    public UnionType(List<TypeDefinition<?>> types) {
        if (types == null) {
            throw new IllegalArgumentException("When the type is 'union', the 'type' statement MUST be present.");
        }
        this.types = types;
    }

    public UnionTypeDefinition getBaseType() {
        return null;
    }

    public String getUnits() {
        return null;
    }

    public Object getDefaultValue() {
        return null;
    }

    public QName getQName() {
        return this.name;
    }

    public SchemaPath getPath() {
        return this.path;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getReference() {
        return REFERENCE;
    }

    public Status getStatus() {
        return Status.CURRENT;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return Collections.emptyList();
    }

    public List<TypeDefinition<?>> getTypes() {
        return this.types;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.types == null ? 0 : this.types.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnionType other = (UnionType)obj;
        return this.types.equals(other.types);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("type ");
        builder.append(this.name);
        builder.append(" (types=[");
        for (TypeDefinition<?> td : this.types) {
            builder.append(", " + td.getQName().getLocalName());
        }
        builder.append("]");
        return builder.toString();
    }
}

