/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.BaseConstraints;
import org.opendaylight.yangtools.yang.model.util.BaseTypes;

public final class StringType
implements StringTypeDefinition {
    private static final StringType INSTANCE = new StringType();
    private final QName name = BaseTypes.constructQName("string");
    private final SchemaPath path = new SchemaPath(Collections.singletonList(this.name), true);
    private static final String DEFAULT_VALUE = "";
    private static final String DESCRIPTION = "";
    private static final String REFERENCE = "";
    private final List<LengthConstraint> lengthStatements;
    private final List<PatternConstraint> patterns;
    private static final String UNITS = "";

    private StringType() {
        ArrayList<LengthConstraint> constraints = new ArrayList<LengthConstraint>();
        constraints.add(BaseConstraints.lengthConstraint(0, Integer.MAX_VALUE, "", ""));
        this.lengthStatements = Collections.unmodifiableList(constraints);
        this.patterns = Collections.emptyList();
    }

    public static StringType getInstance() {
        return INSTANCE;
    }

    public StringTypeDefinition getBaseType() {
        return null;
    }

    public String getUnits() {
        return "";
    }

    public Object getDefaultValue() {
        return "";
    }

    public QName getQName() {
        return this.name;
    }

    public SchemaPath getPath() {
        return this.path;
    }

    public String getDescription() {
        return "";
    }

    public String getReference() {
        return "";
    }

    public Status getStatus() {
        return Status.CURRENT;
    }

    public List<LengthConstraint> getLengthConstraints() {
        return this.lengthStatements;
    }

    public List<PatternConstraint> getPatternConstraints() {
        return this.patterns;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return Collections.emptyList();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lengthStatements == null ? 0 : this.lengthStatements.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.patterns == null ? 0 : this.patterns.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringType other = (StringType)obj;
        if (this.lengthStatements == null ? other.lengthStatements != null : !this.lengthStatements.equals(other.lengthStatements)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals((Object)other.name)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.getPath().equals(other.path.getPath())) {
            return false;
        }
        return !(this.patterns == null ? other.patterns != null : !this.patterns.equals(other.patterns));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("StringType [name=");
        builder.append(this.name);
        builder.append(", path=");
        builder.append(this.path);
        builder.append(", defaultValue=");
        builder.append("");
        builder.append(", description=");
        builder.append("");
        builder.append(", reference=");
        builder.append("");
        builder.append(", lengthStatements=");
        builder.append(this.lengthStatements);
        builder.append(", patterns=");
        builder.append(this.patterns);
        builder.append(", units=");
        builder.append("");
        builder.append("]");
        return builder.toString();
    }
}

