/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import com.google.common.base.Objects;
import java.net.URI;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public class SchemaContextUtil {
    private SchemaContextUtil() {
    }

    public static SchemaNode findDataSchemaNode(SchemaContext context, SchemaPath schemaPath) {
        boolean _notEquals;
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        boolean bl = _tripleEquals = context == null;
        if (_tripleEquals) {
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException("Schema Context reference cannot be NULL!");
            throw _illegalArgumentException;
        }
        boolean bl2 = _tripleEquals_1 = schemaPath == null;
        if (_tripleEquals_1) {
            IllegalArgumentException _illegalArgumentException_1 = new IllegalArgumentException("Schema Path reference cannot be NULL");
            throw _illegalArgumentException_1;
        }
        List prefixedPath = schemaPath.getPath();
        boolean bl3 = _notEquals = !Objects.equal((Object)prefixedPath, null);
        if (_notEquals) {
            return SchemaContextUtil.findNodeInSchemaContext(context, prefixedPath);
        }
        return null;
    }

    public static SchemaNode findDataSchemaNode(SchemaContext context, Module module, RevisionAwareXPath nonCondXPath) {
        boolean _notEquals;
        boolean _tripleEquals_2;
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        boolean bl = _tripleEquals = context == null;
        if (_tripleEquals) {
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException("Schema Context reference cannot be NULL!");
            throw _illegalArgumentException;
        }
        boolean bl2 = _tripleEquals_1 = module == null;
        if (_tripleEquals_1) {
            IllegalArgumentException _illegalArgumentException_1 = new IllegalArgumentException("Module reference cannot be NULL!");
            throw _illegalArgumentException_1;
        }
        boolean bl3 = _tripleEquals_2 = nonCondXPath == null;
        if (_tripleEquals_2) {
            IllegalArgumentException _illegalArgumentException_2 = new IllegalArgumentException("Non Conditional Revision Aware XPath cannot be NULL!");
            throw _illegalArgumentException_2;
        }
        String strXPath = nonCondXPath.toString();
        boolean bl4 = _notEquals = !Objects.equal((Object)strXPath, null);
        if (_notEquals) {
            boolean _contains = strXPath.contains("[");
            if (_contains) {
                IllegalArgumentException _illegalArgumentException_3 = new IllegalArgumentException("Revision Aware XPath cannot contains condition!");
                throw _illegalArgumentException_3;
            }
            boolean _isAbsolute = nonCondXPath.isAbsolute();
            if (_isAbsolute) {
                boolean _notEquals_1;
                LinkedList<QName> qnamedPath = SchemaContextUtil.xpathToQNamePath(context, module, strXPath);
                boolean bl5 = _notEquals_1 = !Objects.equal(qnamedPath, null);
                if (_notEquals_1) {
                    return SchemaContextUtil.findNodeInSchemaContext(context, qnamedPath);
                }
            }
        }
        return null;
    }

    public static SchemaNode findDataSchemaNodeForRelativeXPath(SchemaContext context, Module module, SchemaNode actualSchemaNode, RevisionAwareXPath relativeXPath) {
        boolean _notEquals;
        boolean _tripleEquals_3;
        boolean _tripleEquals_2;
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        boolean bl = _tripleEquals = context == null;
        if (_tripleEquals) {
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException("Schema Context reference cannot be NULL!");
            throw _illegalArgumentException;
        }
        boolean bl2 = _tripleEquals_1 = module == null;
        if (_tripleEquals_1) {
            IllegalArgumentException _illegalArgumentException_1 = new IllegalArgumentException("Module reference cannot be NULL!");
            throw _illegalArgumentException_1;
        }
        boolean bl3 = _tripleEquals_2 = actualSchemaNode == null;
        if (_tripleEquals_2) {
            IllegalArgumentException _illegalArgumentException_2 = new IllegalArgumentException("Actual Schema Node reference cannot be NULL!");
            throw _illegalArgumentException_2;
        }
        boolean bl4 = _tripleEquals_3 = relativeXPath == null;
        if (_tripleEquals_3) {
            IllegalArgumentException _illegalArgumentException_3 = new IllegalArgumentException("Non Conditional Revision Aware XPath cannot be NULL!");
            throw _illegalArgumentException_3;
        }
        boolean _isAbsolute = relativeXPath.isAbsolute();
        if (_isAbsolute) {
            String _plus = "Revision Aware XPath MUST be relative i.e. MUST contains ../, for non relative Revision Aware XPath use findDataSchemaNode method!";
            IllegalArgumentException _illegalArgumentException_4 = new IllegalArgumentException(_plus);
            throw _illegalArgumentException_4;
        }
        SchemaPath actualNodePath = actualSchemaNode.getPath();
        boolean bl5 = _notEquals = !Objects.equal((Object)actualNodePath, null);
        if (_notEquals) {
            boolean _notEquals_1;
            LinkedList<QName> qnamePath = SchemaContextUtil.resolveRelativeXPath(context, module, relativeXPath, actualSchemaNode);
            boolean bl6 = _notEquals_1 = !Objects.equal(qnamePath, null);
            if (_notEquals_1) {
                return SchemaContextUtil.findNodeInSchemaContext(context, qnamePath);
            }
        }
        return null;
    }

    public static Module findParentModule(SchemaContext context, SchemaNode schemaNode) {
        boolean _tripleEquals_3;
        boolean _tripleEquals_2;
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        boolean bl = _tripleEquals = context == null;
        if (_tripleEquals) {
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException("Schema Context reference cannot be NULL!");
            throw _illegalArgumentException;
        }
        boolean bl2 = _tripleEquals_1 = schemaNode == null;
        if (_tripleEquals_1) {
            IllegalArgumentException _illegalArgumentException_1 = new IllegalArgumentException("Schema Node cannot be NULL!");
            throw _illegalArgumentException_1;
        }
        SchemaPath schemaPath = schemaNode.getPath();
        boolean bl3 = _tripleEquals_2 = schemaPath == null;
        if (_tripleEquals_2) {
            String _plus = "Schema Path for Schema Node is not set properly (Schema Path is NULL)";
            IllegalStateException _illegalStateException = new IllegalStateException(_plus);
            throw _illegalStateException;
        }
        List qnamedPath = schemaPath.getPath();
        boolean _or = false;
        boolean bl4 = _tripleEquals_3 = qnamedPath == null;
        if (_tripleEquals_3) {
            _or = true;
        } else {
            boolean _isEmpty = qnamedPath.isEmpty();
            boolean bl5 = _or = _tripleEquals_3 || _isEmpty;
        }
        if (_or) {
            String _plus_1 = "Schema Path contains invalid state of path parts.The Schema Path MUST contain at least ONE QName which defines namespace and Local name";
            String _plus_2 = _plus_1 + "of path.";
            IllegalStateException _illegalStateException_1 = new IllegalStateException(_plus_2);
            throw _illegalStateException_1;
        }
        int _size = qnamedPath.size();
        int _minus = _size - 1;
        QName qname = (QName)qnamedPath.get(_minus);
        URI _namespace = qname.getNamespace();
        Date _revision = qname.getRevision();
        return context.findModuleByNamespaceAndRevision(_namespace, _revision);
    }

    private static SchemaNode findSchemaNodeForGivenPath(SchemaContext context, Module module, Queue<QName> qnamedPath) {
        boolean _notEquals;
        boolean _tripleEquals_3;
        boolean _tripleEquals_2;
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        boolean bl = _tripleEquals = context == null;
        if (_tripleEquals) {
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException("Schema Context reference cannot be NULL!");
            throw _illegalArgumentException;
        }
        boolean bl2 = _tripleEquals_1 = module == null;
        if (_tripleEquals_1) {
            IllegalArgumentException _illegalArgumentException_1 = new IllegalArgumentException("Module reference cannot be NULL!");
            throw _illegalArgumentException_1;
        }
        URI _namespace = module.getNamespace();
        boolean bl3 = _tripleEquals_2 = _namespace == null;
        if (_tripleEquals_2) {
            IllegalArgumentException _illegalArgumentException_2 = new IllegalArgumentException("Namespace for Module cannot contains NULL reference!");
            throw _illegalArgumentException_2;
        }
        boolean _or = false;
        boolean bl4 = _tripleEquals_3 = qnamedPath == null;
        if (_tripleEquals_3) {
            _or = true;
        } else {
            boolean _isEmpty = qnamedPath.isEmpty();
            boolean bl5 = _or = _tripleEquals_3 || _isEmpty;
        }
        if (_or) {
            String _plus = "Schema Path contains invalid state of path parts.The Schema Path MUST contain at least ONE QName which defines namespace and Local name";
            String _plus_1 = _plus + "of path.";
            IllegalStateException _illegalStateException = new IllegalStateException(_plus_1);
            throw _illegalStateException;
        }
        Module nextNode = module;
        URI moduleNamespace = module.getNamespace();
        QName childNodeQName = null;
        DataSchemaNode schemaNode = null;
        boolean _and = false;
        boolean bl6 = _notEquals = !Objects.equal((Object)nextNode, null);
        if (!_notEquals) {
            _and = false;
        } else {
            boolean _isEmpty_1 = qnamedPath.isEmpty();
            boolean _not = !_isEmpty_1;
            _and = _notEquals && _not;
        }
        boolean _while = _and;
        while (_while) {
            boolean _notEquals_1;
            QName _peek = qnamedPath.peek();
            childNodeQName = _peek;
            boolean bl7 = _notEquals_1 = !Objects.equal((Object)childNodeQName, null);
            if (_notEquals_1) {
                boolean _notEquals_2;
                boolean _tripleEquals_5;
                boolean _tripleEquals_4;
                DataSchemaNode _dataChildByName;
                String _localName = childNodeQName.getLocalName();
                schemaNode = _dataChildByName = nextNode.getDataChildByName(_localName);
                boolean _and_1 = false;
                boolean bl8 = _tripleEquals_4 = schemaNode == null;
                if (!_tripleEquals_4) {
                    _and_1 = false;
                } else {
                    boolean bl9 = _and_1 = _tripleEquals_4 && nextNode instanceof Module;
                }
                if (_and_1) {
                    NotificationDefinition _notificationByName = SchemaContextUtil.getNotificationByName(nextNode, childNodeQName);
                    schemaNode = _notificationByName;
                }
                boolean _and_2 = false;
                boolean bl10 = _tripleEquals_5 = schemaNode == null;
                if (!_tripleEquals_5) {
                    _and_2 = false;
                } else {
                    boolean bl11 = _and_2 = _tripleEquals_5 && nextNode instanceof Module;
                }
                if (_and_2) {
                    // empty if block
                }
                URI childNamespace = childNodeQName.getNamespace();
                Date childRevision = childNodeQName.getRevision();
                boolean bl12 = _notEquals_2 = !Objects.equal((Object)schemaNode, null);
                if (_notEquals_2) {
                    if (schemaNode instanceof ContainerSchemaNode) {
                        nextNode = (ContainerSchemaNode)schemaNode;
                    } else if (schemaNode instanceof ListSchemaNode) {
                        nextNode = (ListSchemaNode)schemaNode;
                    } else if (schemaNode instanceof ChoiceNode) {
                        boolean _not_1;
                        ChoiceNode choice = (ChoiceNode)schemaNode;
                        qnamedPath.poll();
                        boolean _isEmpty_2 = qnamedPath.isEmpty();
                        boolean bl13 = _not_1 = !_isEmpty_2;
                        if (_not_1) {
                            QName _peek_1;
                            childNodeQName = _peek_1 = qnamedPath.peek();
                            ChoiceCaseNode _caseNodeByName = choice.getCaseNodeByName(childNodeQName);
                            nextNode = _caseNodeByName;
                            schemaNode = (DataSchemaNode)nextNode;
                        }
                    } else {
                        nextNode = null;
                    }
                } else {
                    boolean _not_2;
                    boolean _equals = childNamespace.equals(moduleNamespace);
                    boolean bl14 = _not_2 = !_equals;
                    if (_not_2) {
                        Module nextModule = context.findModuleByNamespaceAndRevision(childNamespace, childRevision);
                        SchemaNode _findSchemaNodeForGivenPath = SchemaContextUtil.findSchemaNodeForGivenPath(context, nextModule, qnamedPath);
                        schemaNode = _findSchemaNodeForGivenPath;
                        return schemaNode;
                    }
                }
                qnamedPath.poll();
            }
            boolean _and_1 = false;
            boolean bl15 = _notEquals_1 = !Objects.equal((Object)nextNode, null);
            if (!_notEquals_1) {
                _and_1 = false;
            } else {
                boolean _isEmpty_2 = qnamedPath.isEmpty();
                boolean _not_1 = !_isEmpty_2;
                _and_1 = _notEquals_1 && _not_1;
            }
            _while = _and_1;
        }
        return schemaNode;
    }

    public static SchemaNode findNodeInSchemaContext(SchemaContext context, List<QName> path) {
        boolean _tripleEquals;
        Date _revision;
        QName current = path.get(0);
        URI _namespace = current.getNamespace();
        Module module = context.findModuleByNamespaceAndRevision(_namespace, _revision = current.getRevision());
        boolean bl = _tripleEquals = module == null;
        if (_tripleEquals) {
            return null;
        }
        return SchemaContextUtil.findNodeInModule(module, path);
    }

    public static GroupingDefinition findGrouping(SchemaContext context, Module module, List<QName> path) {
        Module m;
        QName first = path.get(0);
        URI _namespace = first.getNamespace();
        Set _findModuleByNamespace = context.findModuleByNamespace(_namespace);
        Iterator _iterator = _findModuleByNamespace.iterator();
        Module currentParent = m = (Module)_iterator.next();
        for (QName qname : path) {
            boolean _not;
            boolean found = false;
            String _localName = qname.getLocalName();
            DataSchemaNode _dataChildByName = currentParent.getDataChildByName(_localName);
            DataNodeContainer node = (DataNodeContainer)_dataChildByName;
            boolean _equals = Objects.equal((Object)node, null);
            if (_equals) {
                Set groupings = currentParent.getGroupings();
                for (GroupingDefinition gr : groupings) {
                    String _localName_2;
                    QName _qName = gr.getQName();
                    String _localName_1 = _qName.getLocalName();
                    boolean _equals_1 = _localName_1.equals(_localName_2 = qname.getLocalName());
                    if (!_equals_1) continue;
                    currentParent = gr;
                    found = true;
                }
            } else {
                found = true;
                currentParent = node;
            }
            if (!(_not = !found)) continue;
            String _plus = "Failed to find referenced grouping: " + path;
            String _plus_1 = _plus + "(";
            String _localName_3 = qname.getLocalName();
            String _plus_2 = _plus_1 + _localName_3;
            String _plus_3 = _plus_2 + ")";
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException(_plus_3);
            throw _illegalArgumentException;
        }
        return (GroupingDefinition)currentParent;
    }

    private static SchemaNode findNodeInModule(Module module, List<QName> path) {
        boolean _notEquals_3;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        QName current = path.get(0);
        DataSchemaNode node = module.getDataChildByName(current);
        boolean bl = _notEquals = !Objects.equal((Object)node, null);
        if (_notEquals) {
            List<QName> _nextLevel = SchemaContextUtil.nextLevel(path);
            return SchemaContextUtil.findNode(node, _nextLevel);
        }
        RpcDefinition _rpcByName = SchemaContextUtil.getRpcByName(module, current);
        node = _rpcByName;
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)node, null);
        if (_notEquals_1) {
            List<QName> _nextLevel_1 = SchemaContextUtil.nextLevel(path);
            return SchemaContextUtil.findNodeInRpc((RpcDefinition)node, _nextLevel_1);
        }
        NotificationDefinition _notificationByName = SchemaContextUtil.getNotificationByName(module, current);
        node = _notificationByName;
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)node, null);
        if (_notEquals_2) {
            List<QName> _nextLevel_2 = SchemaContextUtil.nextLevel(path);
            return SchemaContextUtil.findNodeInNotification((NotificationDefinition)node, _nextLevel_2);
        }
        GroupingDefinition _groupingByName = SchemaContextUtil.getGroupingByName(module, current);
        node = _groupingByName;
        boolean bl4 = _notEquals_3 = !Objects.equal((Object)node, null);
        if (_notEquals_3) {
            List<QName> _nextLevel_3 = SchemaContextUtil.nextLevel(path);
            return SchemaContextUtil.findNodeInGrouping((GroupingDefinition)node, _nextLevel_3);
        }
        return node;
    }

    private static SchemaNode findNodeInGrouping(GroupingDefinition grouping, List<QName> path) {
        boolean _notEquals;
        boolean _isEmpty = path.isEmpty();
        if (_isEmpty) {
            return grouping;
        }
        QName current = path.get(0);
        DataSchemaNode node = grouping.getDataChildByName(current);
        boolean bl = _notEquals = !Objects.equal((Object)node, null);
        if (_notEquals) {
            List<QName> _nextLevel = SchemaContextUtil.nextLevel(path);
            return SchemaContextUtil.findNode(node, _nextLevel);
        }
        return null;
    }

    private static SchemaNode findNodeInRpc(RpcDefinition rpc, List<QName> path) {
        String _localName;
        boolean _isEmpty = path.isEmpty();
        if (_isEmpty) {
            return rpc;
        }
        QName current = path.get(0);
        String _switchValue = _localName = current.getLocalName();
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)_switchValue, (Object)"input")) {
            _matched = true;
            ContainerSchemaNode _input = rpc.getInput();
            List<QName> _nextLevel = SchemaContextUtil.nextLevel(path);
            return SchemaContextUtil.findNode((DataSchemaNode)_input, _nextLevel);
        }
        if (!_matched && Objects.equal((Object)_switchValue, (Object)"output")) {
            _matched = true;
            ContainerSchemaNode _output = rpc.getOutput();
            List<QName> _nextLevel_1 = SchemaContextUtil.nextLevel(path);
            return SchemaContextUtil.findNode((DataSchemaNode)_output, _nextLevel_1);
        }
        return null;
    }

    private static SchemaNode findNodeInNotification(NotificationDefinition rpc, List<QName> path) {
        boolean _notEquals;
        boolean _isEmpty = path.isEmpty();
        if (_isEmpty) {
            return rpc;
        }
        QName current = path.get(0);
        DataSchemaNode node = rpc.getDataChildByName(current);
        boolean bl = _notEquals = !Objects.equal((Object)node, null);
        if (_notEquals) {
            List<QName> _nextLevel = SchemaContextUtil.nextLevel(path);
            return SchemaContextUtil.findNode(node, _nextLevel);
        }
        return null;
    }

    private static SchemaNode _findNode(ChoiceNode parent, List<QName> path) {
        boolean _notEquals;
        boolean _isEmpty = path.isEmpty();
        if (_isEmpty) {
            return parent;
        }
        QName current = path.get(0);
        ChoiceCaseNode node = parent.getCaseNodeByName(current);
        boolean bl = _notEquals = !Objects.equal((Object)node, null);
        if (_notEquals) {
            List<QName> _nextLevel = SchemaContextUtil.nextLevel(path);
            return SchemaContextUtil.findNodeInCase(node, _nextLevel);
        }
        return null;
    }

    private static SchemaNode _findNode(ContainerSchemaNode parent, List<QName> path) {
        boolean _notEquals;
        boolean _isEmpty = path.isEmpty();
        if (_isEmpty) {
            return parent;
        }
        QName current = path.get(0);
        DataSchemaNode node = parent.getDataChildByName(current);
        boolean bl = _notEquals = !Objects.equal((Object)node, null);
        if (_notEquals) {
            List<QName> _nextLevel = SchemaContextUtil.nextLevel(path);
            return SchemaContextUtil.findNode(node, _nextLevel);
        }
        return null;
    }

    private static SchemaNode _findNode(ListSchemaNode parent, List<QName> path) {
        boolean _notEquals;
        boolean _isEmpty = path.isEmpty();
        if (_isEmpty) {
            return parent;
        }
        QName current = path.get(0);
        DataSchemaNode node = parent.getDataChildByName(current);
        boolean bl = _notEquals = !Objects.equal((Object)node, null);
        if (_notEquals) {
            List<QName> _nextLevel = SchemaContextUtil.nextLevel(path);
            return SchemaContextUtil.findNode(node, _nextLevel);
        }
        return null;
    }

    private static SchemaNode _findNode(DataSchemaNode parent, List<QName> path) {
        boolean _isEmpty = path.isEmpty();
        if (_isEmpty) {
            return parent;
        }
        IllegalArgumentException _illegalArgumentException = new IllegalArgumentException("Path nesting violation");
        throw _illegalArgumentException;
    }

    public static SchemaNode findNodeInCase(ChoiceCaseNode parent, List<QName> path) {
        boolean _notEquals;
        boolean _isEmpty = path.isEmpty();
        if (_isEmpty) {
            return parent;
        }
        QName current = path.get(0);
        DataSchemaNode node = parent.getDataChildByName(current);
        boolean bl = _notEquals = !Objects.equal((Object)node, null);
        if (_notEquals) {
            List<QName> _nextLevel = SchemaContextUtil.nextLevel(path);
            return SchemaContextUtil.findNode(node, _nextLevel);
        }
        return null;
    }

    public static RpcDefinition getRpcByName(Module module, QName name) {
        Set _rpcs = module.getRpcs();
        for (RpcDefinition rpc : _rpcs) {
            QName _qName = rpc.getQName();
            boolean _equals = _qName.equals((Object)name);
            if (!_equals) continue;
            return rpc;
        }
        return null;
    }

    private static List<QName> nextLevel(List<QName> path) {
        int _size = path.size();
        return path.subList(1, _size);
    }

    public static NotificationDefinition getNotificationByName(Module module, QName name) {
        Set _notifications = module.getNotifications();
        for (NotificationDefinition notification : _notifications) {
            QName _qName = notification.getQName();
            boolean _equals = _qName.equals((Object)name);
            if (!_equals) continue;
            return notification;
        }
        return null;
    }

    public static GroupingDefinition getGroupingByName(Module module, QName name) {
        Set _groupings = module.getGroupings();
        for (GroupingDefinition grouping : _groupings) {
            QName _qName = grouping.getQName();
            boolean _equals = _qName.equals((Object)name);
            if (!_equals) continue;
            return grouping;
        }
        return null;
    }

    private static LinkedList<QName> xpathToQNamePath(SchemaContext context, Module parentModule, String xpath) {
        String[] prefixedPath;
        LinkedList<QName> _linkedList;
        boolean _tripleEquals_2;
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        boolean bl = _tripleEquals = context == null;
        if (_tripleEquals) {
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException("Schema Context reference cannot be NULL!");
            throw _illegalArgumentException;
        }
        boolean bl2 = _tripleEquals_1 = parentModule == null;
        if (_tripleEquals_1) {
            IllegalArgumentException _illegalArgumentException_1 = new IllegalArgumentException("Parent Module reference cannot be NULL!");
            throw _illegalArgumentException_1;
        }
        boolean bl3 = _tripleEquals_2 = xpath == null;
        if (_tripleEquals_2) {
            IllegalArgumentException _illegalArgumentException_2 = new IllegalArgumentException("XPath string reference cannot be NULL!");
            throw _illegalArgumentException_2;
        }
        LinkedList<QName> path = _linkedList = new LinkedList<QName>();
        for (String pathComponent : prefixedPath = xpath.split("/")) {
            boolean _not;
            boolean _isEmpty = pathComponent.isEmpty();
            boolean bl4 = _not = !_isEmpty;
            if (!_not) continue;
            QName _stringPathPartToQName = SchemaContextUtil.stringPathPartToQName(context, parentModule, pathComponent);
            path.add(_stringPathPartToQName);
        }
        return path;
    }

    private static QName stringPathPartToQName(SchemaContext context, Module parentModule, String prefixedPathPart) {
        boolean _tripleEquals_2;
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        boolean bl = _tripleEquals = context == null;
        if (_tripleEquals) {
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException("Schema Context reference cannot be NULL!");
            throw _illegalArgumentException;
        }
        boolean bl2 = _tripleEquals_1 = parentModule == null;
        if (_tripleEquals_1) {
            IllegalArgumentException _illegalArgumentException_1 = new IllegalArgumentException("Parent Module reference cannot be NULL!");
            throw _illegalArgumentException_1;
        }
        boolean bl3 = _tripleEquals_2 = prefixedPathPart == null;
        if (_tripleEquals_2) {
            IllegalArgumentException _illegalArgumentException_2 = new IllegalArgumentException("Prefixed Path Part cannot be NULL!");
            throw _illegalArgumentException_2;
        }
        boolean _contains = prefixedPathPart.contains(":");
        if (_contains) {
            String[] prefixedName = prefixedPathPart.split(":");
            String _get = prefixedName[0];
            Module module = SchemaContextUtil.resolveModuleForPrefix(context, parentModule, _get);
            boolean _equals = Objects.equal((Object)module, null);
            if (_equals) {
                String _get_1 = prefixedName[0];
                String _plus = "Failed to resolve xpath: no module found for prefix " + _get_1;
                String _plus_1 = _plus + " in module ";
                String _name = parentModule.getName();
                String _plus_2 = _plus_1 + _name;
                IllegalArgumentException _illegalArgumentException_3 = new IllegalArgumentException(_plus_2);
                throw _illegalArgumentException_3;
            }
            URI _namespace = module.getNamespace();
            Date _revision = module.getRevision();
            String _get_2 = prefixedName[1];
            QName _qName = new QName(_namespace, _revision, _get_2);
            return _qName;
        }
        URI _namespace_1 = parentModule.getNamespace();
        Date _revision_1 = parentModule.getRevision();
        QName _qName_1 = new QName(_namespace_1, _revision_1, prefixedPathPart);
        return _qName_1;
    }

    private static Module resolveModuleForPrefix(SchemaContext context, Module module, String prefix) {
        boolean _tripleEquals_2;
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        boolean bl = _tripleEquals = context == null;
        if (_tripleEquals) {
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException("Schema Context reference cannot be NULL!");
            throw _illegalArgumentException;
        }
        boolean bl2 = _tripleEquals_1 = module == null;
        if (_tripleEquals_1) {
            IllegalArgumentException _illegalArgumentException_1 = new IllegalArgumentException("Module reference cannot be NULL!");
            throw _illegalArgumentException_1;
        }
        boolean bl3 = _tripleEquals_2 = prefix == null;
        if (_tripleEquals_2) {
            IllegalArgumentException _illegalArgumentException_2 = new IllegalArgumentException("Prefix string cannot be NULL!");
            throw _illegalArgumentException_2;
        }
        String _prefix = module.getPrefix();
        boolean _equals = prefix.equals(_prefix);
        if (_equals) {
            return module;
        }
        Set imports = module.getImports();
        for (ModuleImport mi : imports) {
            String _prefix_1 = mi.getPrefix();
            boolean _equals_1 = prefix.equals(_prefix_1);
            if (!_equals_1) continue;
            String _moduleName = mi.getModuleName();
            Date _revision = mi.getRevision();
            return context.findModuleByName(_moduleName, _revision);
        }
        return null;
    }

    private static LinkedList<QName> resolveRelativeXPath(final SchemaContext context, final Module module, RevisionAwareXPath relativeXPath, SchemaNode leafrefParentNode) {
        boolean _notEquals;
        LinkedList<QName> _linkedList;
        boolean _tripleEquals_3;
        boolean _tripleEquals_2;
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        boolean bl = _tripleEquals = context == null;
        if (_tripleEquals) {
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException("Schema Context reference cannot be NULL!");
            throw _illegalArgumentException;
        }
        boolean bl2 = _tripleEquals_1 = module == null;
        if (_tripleEquals_1) {
            IllegalArgumentException _illegalArgumentException_1 = new IllegalArgumentException("Module reference cannot be NULL!");
            throw _illegalArgumentException_1;
        }
        boolean bl3 = _tripleEquals_2 = relativeXPath == null;
        if (_tripleEquals_2) {
            IllegalArgumentException _illegalArgumentException_2 = new IllegalArgumentException("Non Conditional Revision Aware XPath cannot be NULL!");
            throw _illegalArgumentException_2;
        }
        boolean _isAbsolute = relativeXPath.isAbsolute();
        if (_isAbsolute) {
            String _plus = "Revision Aware XPath MUST be relative i.e. MUST contains ../, for non relative Revision Aware XPath use findDataSchemaNode method!";
            IllegalArgumentException _illegalArgumentException_3 = new IllegalArgumentException(_plus);
            throw _illegalArgumentException_3;
        }
        SchemaPath _path = leafrefParentNode.getPath();
        boolean bl4 = _tripleEquals_3 = _path == null;
        if (_tripleEquals_3) {
            IllegalArgumentException _illegalArgumentException_4 = new IllegalArgumentException("Schema Path reference for Leafref cannot be NULL!");
            throw _illegalArgumentException_4;
        }
        LinkedList<QName> absolutePath = _linkedList = new LinkedList<QName>();
        String strXPath = relativeXPath.toString();
        boolean bl5 = _notEquals = !Objects.equal((Object)strXPath, null);
        if (_notEquals) {
            boolean _notEquals_1;
            String[] xpaths = strXPath.split("/");
            boolean bl6 = _notEquals_1 = !Objects.equal((Object)xpaths, null);
            if (_notEquals_1) {
                boolean _notEquals_2;
                boolean _contains;
                int colCount = 0;
                String _get = xpaths[colCount];
                boolean _while = _contains = _get.contains("..");
                while (_while) {
                    boolean _contains_1;
                    int _plus_1;
                    colCount = _plus_1 = colCount + 1;
                    String _get_1 = xpaths[colCount];
                    _while = _contains_1 = _get_1.contains("..");
                }
                SchemaPath _path_1 = leafrefParentNode.getPath();
                List path = _path_1.getPath();
                boolean bl7 = _notEquals_2 = !Objects.equal((Object)path, null);
                if (_notEquals_2) {
                    int _size = path.size();
                    int lenght = _size - colCount;
                    List _subList = path.subList(0, lenght);
                    absolutePath.addAll(_subList);
                    int _length = xpaths.length;
                    List _subList_1 = ((List)Conversions.doWrapArray((Object)xpaths)).subList(colCount, _length);
                    Functions.Function1<String, QName> _function = new Functions.Function1<String, QName>(){

                        public QName apply(String it) {
                            QName _stringPathPartToQName = SchemaContextUtil.stringPathPartToQName(context, module, it);
                            return _stringPathPartToQName;
                        }
                    };
                    List sublist = ListExtensions.map(_subList_1, (Functions.Function1)_function);
                    absolutePath.addAll(sublist);
                }
            }
        }
        return absolutePath;
    }

    private static SchemaNode findNode(DataSchemaNode parent, List<QName> path) {
        if (parent instanceof ChoiceNode) {
            return SchemaContextUtil._findNode((ChoiceNode)parent, path);
        }
        if (parent instanceof ContainerSchemaNode) {
            return SchemaContextUtil._findNode((ContainerSchemaNode)parent, path);
        }
        if (parent instanceof ListSchemaNode) {
            return SchemaContextUtil._findNode((ListSchemaNode)parent, path);
        }
        if (parent != null) {
            return SchemaContextUtil._findNode(parent, path);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(parent, path).toString());
    }
}

