/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.BaseTypes;

public final class Leafref
implements LeafrefTypeDefinition {
    private static final QName NAME = BaseTypes.constructQName("leafref");
    private static final SchemaPath PATH = BaseTypes.schemaPath(NAME);
    private static final String DESCRIPTION = "The leafref type is used to reference a particular leaf instance in the data tree.";
    private static final String REF = "https://tools.ietf.org/html/rfc6020#section-9.9";
    private final RevisionAwareXPath xpath;

    public Leafref(RevisionAwareXPath xpath) {
        this.xpath = xpath;
    }

    public LeafrefTypeDefinition getBaseType() {
        return null;
    }

    public String getUnits() {
        return "";
    }

    public Object getDefaultValue() {
        return this;
    }

    public QName getQName() {
        return NAME;
    }

    public SchemaPath getPath() {
        return PATH;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getReference() {
        return REF;
    }

    public Status getStatus() {
        return Status.CURRENT;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return Collections.emptyList();
    }

    public RevisionAwareXPath getPathStatement() {
        return this.xpath;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.xpath == null ? 0 : this.xpath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Leafref other = (Leafref)obj;
        return !(this.xpath == null ? other.xpath != null : !this.xpath.equals(other.xpath));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("type ");
        builder.append(NAME);
        builder.append(" [xpath=");
        builder.append(this.xpath);
        builder.append("]");
        return builder.toString();
    }
}

