/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.BaseTypes;

public final class InstanceIdentifier
implements InstanceIdentifierTypeDefinition {
    private static final QName NAME = BaseTypes.constructQName("instance-identifier");
    private static final SchemaPath PATH = new SchemaPath(Collections.singletonList(NAME), true);
    private static final String DESCRIPTION = "The instance-identifier built-in type is used to uniquely identify a particular instance node in the data tree.";
    private static final String REFERENCE = "https://tools.ietf.org/html/rfc6020#section-9.13";
    private final RevisionAwareXPath xpath;
    private static final String UNITS = "";
    private boolean requireInstance = true;
    private static final int HASH_BOOLEAN_TRUE = 1231;
    private static final int HASH_BOOLEAN_FALSE = 1237;

    public InstanceIdentifier(RevisionAwareXPath xpath) {
        this.xpath = xpath;
    }

    public InstanceIdentifier(RevisionAwareXPath xpath, boolean requireInstance) {
        this.xpath = xpath;
        this.requireInstance = requireInstance;
    }

    public InstanceIdentifierTypeDefinition getBaseType() {
        return null;
    }

    public String getUnits() {
        return UNITS;
    }

    public Object getDefaultValue() {
        return this.xpath;
    }

    public QName getQName() {
        return NAME;
    }

    public SchemaPath getPath() {
        return PATH;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getReference() {
        return REFERENCE;
    }

    public Status getStatus() {
        return Status.CURRENT;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return Collections.emptyList();
    }

    public RevisionAwareXPath getPathStatement() {
        return this.xpath;
    }

    public boolean requireInstance() {
        return this.requireInstance;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.requireInstance ? 1231 : 1237);
        result = 31 * result + (this.xpath == null ? 0 : this.xpath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InstanceIdentifier other = (InstanceIdentifier)obj;
        if (this.requireInstance != other.requireInstance) {
            return false;
        }
        return !(this.xpath == null ? other.xpath != null : !this.xpath.equals(other.xpath));
    }
}

