/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.BaseTypes;

public final class IdentityrefType
implements IdentityrefTypeDefinition {
    private final QName name = BaseTypes.constructQName("identityref");
    private final SchemaPath path;
    private static final String DESCRIPTION = "The identityref type is used to reference an existing identity.";
    private static final String REFERENCE = "https://tools.ietf.org/html/rfc6020#section-9.10";
    private final IdentitySchemaNode identity;
    private static final String UNITS = "";

    public IdentityrefType(IdentitySchemaNode identity, SchemaPath schemaPath) {
        this.identity = identity;
        this.path = schemaPath;
    }

    public String getUnits() {
        return UNITS;
    }

    public Object getDefaultValue() {
        return this.identity;
    }

    public QName getQName() {
        return this.name;
    }

    public SchemaPath getPath() {
        return this.path;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getReference() {
        return REFERENCE;
    }

    public Status getStatus() {
        return Status.CURRENT;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return Collections.emptyList();
    }

    public IdentitySchemaNode getIdentity() {
        return this.identity;
    }

    public IdentityrefTypeDefinition getBaseType() {
        return null;
    }

    public String toString() {
        return "identityref " + this.identity.getQName().getLocalName();
    }
}

