/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;
import org.opendaylight.yangtools.yang.model.util.BaseTypes;

public class ExtendedType
implements TypeDefinition<TypeDefinition<?>> {
    private final QName typeName;
    private final TypeDefinition<?> baseType;
    private final SchemaPath path;
    private final String description;
    private final String reference;
    private final List<UnknownSchemaNode> unknownSchemaNodes;
    private List<RangeConstraint> ranges = Collections.emptyList();
    private List<LengthConstraint> lengths = Collections.emptyList();
    private List<PatternConstraint> patterns = Collections.emptyList();
    private Integer fractionDigits = null;
    private Status status;
    private String units;
    private Object defaultValue;
    private boolean addedByUses;

    private ExtendedType(Builder builder) {
        this.typeName = builder.typeName;
        this.baseType = builder.baseType;
        this.path = builder.path;
        this.description = builder.description;
        this.reference = builder.reference;
        this.unknownSchemaNodes = builder.unknownSchemaNodes;
        this.status = builder.status;
        this.units = builder.units;
        this.defaultValue = builder.defaultValue;
        this.addedByUses = builder.addedByUses;
        this.ranges = builder.ranges;
        this.lengths = builder.lengths;
        this.patterns = builder.patterns;
        this.fractionDigits = builder.fractionDigits;
    }

    public TypeDefinition<?> getBaseType() {
        return this.baseType;
    }

    public String getUnits() {
        return this.units;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isAddedByUses() {
        return this.addedByUses;
    }

    public QName getQName() {
        return this.typeName;
    }

    public SchemaPath getPath() {
        return this.path;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReference() {
        return this.reference;
    }

    public Status getStatus() {
        return this.status;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownSchemaNodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExtendedType)) {
            return false;
        }
        ExtendedType that = (ExtendedType)o;
        if (this.path != null ? !this.path.equals((Object)that.path) : that.path != null) {
            return false;
        }
        return !(this.typeName != null ? !this.typeName.equals((Object)that.typeName) : that.typeName != null);
    }

    public int hashCode() {
        int result = this.typeName != null ? this.typeName.hashCode() : 0;
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ExtendedType [typeName=");
        builder.append(this.typeName);
        builder.append(", baseType=");
        builder.append(this.baseType);
        builder.append(", path=");
        builder.append(this.path);
        builder.append(", description=");
        builder.append(this.description);
        builder.append(", reference=");
        builder.append(this.reference);
        builder.append(", unknownSchemaNodes=");
        builder.append(this.unknownSchemaNodes);
        builder.append(", status=");
        builder.append(this.status);
        builder.append(", units=");
        builder.append(this.units);
        builder.append(", defaultValue=");
        builder.append(this.defaultValue);
        builder.append("]");
        return builder.toString();
    }

    public List<RangeConstraint> getRangeConstraints() {
        return this.ranges;
    }

    public List<LengthConstraint> getLengthConstraints() {
        return this.lengths;
    }

    public List<PatternConstraint> getPatternConstraints() {
        return this.patterns;
    }

    public Integer getFractionDigits() {
        return this.fractionDigits;
    }

    public static class Builder {
        private final QName typeName;
        private final TypeDefinition<?> baseType;
        private final SchemaPath path;
        private final String description;
        private final String reference;
        private List<UnknownSchemaNode> unknownSchemaNodes = Collections.emptyList();
        private Status status = Status.CURRENT;
        private String units = null;
        private Object defaultValue = null;
        private boolean addedByUses;
        private List<RangeConstraint> ranges = Collections.emptyList();
        private List<LengthConstraint> lengths = Collections.emptyList();
        private List<PatternConstraint> patterns = Collections.emptyList();
        private Integer fractionDigits = null;

        public Builder(List<String> actualPath, URI namespace, Date revision, QName typeName, TypeDefinition<?> baseType, String description, String reference) {
            this.typeName = typeName;
            this.baseType = baseType;
            this.path = BaseTypes.schemaPath(actualPath, namespace, revision);
            this.description = description;
            this.reference = reference;
        }

        public Builder(QName typeName, TypeDefinition<?> baseType, String description, String reference, SchemaPath path) {
            this.typeName = typeName;
            this.baseType = baseType;
            this.path = path;
            this.description = description;
            this.reference = reference;
        }

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder units(String units) {
            this.units = units;
            return this;
        }

        public Builder defaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder addedByUses(boolean addedByUses) {
            this.addedByUses = addedByUses;
            return this;
        }

        public Builder unknownSchemaNodes(List<UnknownSchemaNode> unknownSchemaNodes) {
            this.unknownSchemaNodes = unknownSchemaNodes;
            return this;
        }

        public Builder ranges(List<RangeConstraint> ranges) {
            if (ranges != null) {
                this.ranges = ranges;
            }
            return this;
        }

        public Builder lengths(List<LengthConstraint> lengths) {
            if (lengths != null) {
                this.lengths = lengths;
            }
            return this;
        }

        public Builder patterns(List<PatternConstraint> patterns) {
            if (patterns != null) {
                this.patterns = patterns;
            }
            return this;
        }

        public Builder fractionDigits(Integer fractionDigits) {
            this.fractionDigits = fractionDigits;
            return this;
        }

        public ExtendedType build() {
            return new ExtendedType(this);
        }
    }
}

