/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.BaseTypes;

public final class EnumerationType
implements EnumTypeDefinition {
    private final QName name = BaseTypes.constructQName("enumeration");
    private final SchemaPath path;
    private static final String DESCRIPTION = "The enumeration built-in type represents values from a set of assigned names.";
    private static final String REFERENCE = "https://tools.ietf.org/html/rfc6020#section-9.6";
    private final EnumTypeDefinition.EnumPair defaultEnum;
    private final List<EnumTypeDefinition.EnumPair> enums;
    private static final String UNITS = "";

    public EnumerationType(SchemaPath path, List<EnumTypeDefinition.EnumPair> enums) {
        this.path = path;
        this.enums = Collections.unmodifiableList(enums);
        this.defaultEnum = null;
    }

    public EnumerationType(SchemaPath path, EnumTypeDefinition.EnumPair defaultEnum, List<EnumTypeDefinition.EnumPair> enums) {
        this.path = path;
        this.defaultEnum = defaultEnum;
        this.enums = Collections.unmodifiableList(enums);
    }

    public EnumTypeDefinition getBaseType() {
        return null;
    }

    public String getUnits() {
        return UNITS;
    }

    public Object getDefaultValue() {
        return this.defaultEnum;
    }

    public QName getQName() {
        return this.name;
    }

    public SchemaPath getPath() {
        return this.path;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getReference() {
        return REFERENCE;
    }

    public Status getStatus() {
        return Status.CURRENT;
    }

    public List<EnumTypeDefinition.EnumPair> getValues() {
        return this.enums;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return Collections.emptyList();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.defaultEnum == null ? 0 : this.defaultEnum.hashCode());
        result = 31 * result + (this.enums == null ? 0 : this.enums.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnumerationType other = (EnumerationType)obj;
        if (this.defaultEnum == null ? other.defaultEnum != null : !this.defaultEnum.equals(other.defaultEnum)) {
            return false;
        }
        if (this.enums == null ? other.enums != null : !this.enums.equals(other.enums)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals((Object)other.name)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("EnumerationType [name=");
        builder.append(this.name);
        builder.append(", path=");
        builder.append(this.path);
        builder.append(", description=");
        builder.append(DESCRIPTION);
        builder.append(", reference=");
        builder.append(REFERENCE);
        builder.append(", defaultEnum=");
        builder.append(this.defaultEnum);
        builder.append(", enums=");
        builder.append(this.enums);
        builder.append(", units=");
        builder.append(UNITS);
        builder.append("]");
        return builder.toString();
    }
}

