/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.BaseTypes;

public final class EmptyType
implements EmptyTypeDefinition {
    private static EmptyType instance;
    private static final QName NAME;
    private static final SchemaPath PATH;
    private static final String DESCRIPTION = "The empty built-in type represents a leaf that does not have any value, it conveys information by its presence or absence.";
    private static final String REFERENCE = "https://tools.ietf.org/html/rfc6020#page-131";

    private EmptyType() {
    }

    public static EmptyType getInstance() {
        if (instance == null) {
            instance = new EmptyType();
        }
        return instance;
    }

    public EmptyTypeDefinition getBaseType() {
        return null;
    }

    public String getUnits() {
        return null;
    }

    public Object getDefaultValue() {
        return null;
    }

    public QName getQName() {
        return NAME;
    }

    public SchemaPath getPath() {
        return PATH;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getReference() {
        return REFERENCE;
    }

    public Status getStatus() {
        return Status.CURRENT;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return Collections.emptyList();
    }

    public String toString() {
        return "type empty " + NAME;
    }

    static {
        NAME = BaseTypes.constructQName("empty");
        PATH = new SchemaPath(Collections.singletonList(NAME), true);
    }
}

