/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;
import org.opendaylight.yangtools.yang.model.util.BaseConstraints;
import org.opendaylight.yangtools.yang.model.util.BaseTypes;

public final class Decimal64
implements DecimalTypeDefinition {
    private final QName name = BaseTypes.constructQName("decimal64");
    private final SchemaPath path;
    private static final String UNITS = "";
    private static final BigDecimal DEFAULT_VALUE = null;
    private final String description = "The decimal64 type represents a subset of the real numbers, which can be represented by decimal numerals. The value space of decimal64 is the set of numbers that can be obtained by multiplying a 64-bit signed integer by a negative power of ten, i.e., expressible as 'i x 10^-n' where i is an integer64 and n is an integer between 1 and 18, inclusively.";
    private static final String REFERENCE = "https://tools.ietf.org/html/rfc6020#section-9.3";
    private final List<RangeConstraint> rangeStatements;
    private final Integer fractionDigits;
    private static final int MAX_NUMBER_OF_FRACTION_DIGITS = 18;

    public Decimal64(SchemaPath path, Integer fractionDigits) {
        if (fractionDigits < 1 || fractionDigits > 18) {
            throw new IllegalArgumentException("The fraction digits outside of boundaries. Fraction digits MUST be integer between 1 and 18 inclusively");
        }
        this.fractionDigits = fractionDigits;
        this.rangeStatements = this.defaultRangeStatements();
        this.path = path;
    }

    private List<RangeConstraint> defaultRangeStatements() {
        ArrayList<RangeConstraint> rangeStmts = new ArrayList<RangeConstraint>();
        BigDecimal min = new BigDecimal("-922337203685477580.8");
        BigDecimal max = new BigDecimal("922337203685477580.7");
        String rangeDescription = "Integer values between " + min + " and " + max + ", inclusively.";
        rangeStmts.add(BaseConstraints.rangeConstraint(min, max, rangeDescription, "https://tools.ietf.org/html/rfc6020#section-9.2.4"));
        return Collections.unmodifiableList(rangeStmts);
    }

    public DecimalTypeDefinition getBaseType() {
        return null;
    }

    public String getUnits() {
        return UNITS;
    }

    public Object getDefaultValue() {
        return DEFAULT_VALUE;
    }

    public QName getQName() {
        return this.name;
    }

    public SchemaPath getPath() {
        return this.path;
    }

    public String getDescription() {
        return "The decimal64 type represents a subset of the real numbers, which can be represented by decimal numerals. The value space of decimal64 is the set of numbers that can be obtained by multiplying a 64-bit signed integer by a negative power of ten, i.e., expressible as 'i x 10^-n' where i is an integer64 and n is an integer between 1 and 18, inclusively.";
    }

    public String getReference() {
        return REFERENCE;
    }

    public Status getStatus() {
        return Status.CURRENT;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return Collections.emptyList();
    }

    public List<RangeConstraint> getRangeConstraints() {
        return this.rangeStatements;
    }

    public Integer getFractionDigits() {
        return this.fractionDigits;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Decimal64 other = (Decimal64)obj;
        if (this.name == null ? other.name != null : !this.name.equals((Object)other.name)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
    }

    public String toString() {
        return Decimal64.class.getSimpleName() + "[qname=" + this.name + ", fractionDigits=" + this.fractionDigits + "]";
    }
}

