/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;

public class DataNodeIterator
implements Iterator<DataSchemaNode> {
    private final DataNodeContainer container;
    private final List<ListSchemaNode> allLists;
    private final List<ContainerSchemaNode> allContainers;
    private final List<ChoiceNode> allChoices;
    private final List<DataSchemaNode> allChilds;
    private final List<GroupingDefinition> allGroupings;
    private final List<TypeDefinition<?>> allTypedefs;

    public DataNodeIterator(DataNodeContainer container) {
        if (container == null) {
            throw new IllegalArgumentException("Data Node Container MUST be specified and cannot be NULL!");
        }
        this.allContainers = new ArrayList<ContainerSchemaNode>();
        this.allLists = new ArrayList<ListSchemaNode>();
        this.allChilds = new ArrayList<DataSchemaNode>();
        this.allChoices = new ArrayList<ChoiceNode>();
        this.allGroupings = new ArrayList<GroupingDefinition>();
        this.allTypedefs = new ArrayList();
        this.container = container;
        this.traverse(this.container);
    }

    public List<ContainerSchemaNode> allContainers() {
        return this.allContainers;
    }

    public List<ListSchemaNode> allLists() {
        return this.allLists;
    }

    public List<ChoiceNode> allChoices() {
        return this.allChoices;
    }

    public List<GroupingDefinition> allGroupings() {
        return this.allGroupings;
    }

    public List<TypeDefinition<?>> allTypedefs() {
        return this.allTypedefs;
    }

    private void traverse(DataNodeContainer dataNode) {
        if (dataNode == null) {
            return;
        }
        Set childNodes = dataNode.getChildNodes();
        if (childNodes != null) {
            for (DataSchemaNode childNode : childNodes) {
                if (childNode.isAugmenting()) continue;
                this.allChilds.add(childNode);
                if (childNode instanceof ContainerSchemaNode) {
                    ContainerSchemaNode containerNode = (ContainerSchemaNode)childNode;
                    this.allContainers.add(containerNode);
                    this.traverse((DataNodeContainer)containerNode);
                    continue;
                }
                if (childNode instanceof ListSchemaNode) {
                    ListSchemaNode list = (ListSchemaNode)childNode;
                    this.allLists.add(list);
                    this.traverse((DataNodeContainer)list);
                    continue;
                }
                if (!(childNode instanceof ChoiceNode)) continue;
                ChoiceNode choiceNode = (ChoiceNode)childNode;
                this.allChoices.add(choiceNode);
                Set cases = choiceNode.getCases();
                if (cases == null) continue;
                for (ChoiceCaseNode caseNode : cases) {
                    this.traverse((DataNodeContainer)caseNode);
                }
            }
        }
        this.allTypedefs.addAll(dataNode.getTypeDefinitions());
        this.traverseModule(dataNode);
        this.traverseGroupings(dataNode);
    }

    private void traverseModule(DataNodeContainer dataNode) {
        if (!(dataNode instanceof Module)) {
            return;
        }
        Module module = (Module)dataNode;
        Set notifications = module.getNotifications();
        for (NotificationDefinition notificationDefinition : notifications) {
            this.traverse((DataNodeContainer)notificationDefinition);
        }
        Set rpcs = module.getRpcs();
        for (RpcDefinition rpcDefinition : rpcs) {
            this.allTypedefs.addAll(rpcDefinition.getTypeDefinitions());
            ContainerSchemaNode input = rpcDefinition.getInput();
            if (input != null) {
                this.traverse((DataNodeContainer)input);
            }
            ContainerSchemaNode output = rpcDefinition.getInput();
            if (input == null) continue;
            this.traverse((DataNodeContainer)output);
        }
    }

    private void traverseGroupings(DataNodeContainer dataNode) {
        Set groupings = dataNode.getGroupings();
        if (groupings != null) {
            for (GroupingDefinition grouping : groupings) {
                this.allGroupings.add(grouping);
                this.traverse((DataNodeContainer)grouping);
            }
        }
    }

    @Override
    public boolean hasNext() {
        Set childNodes;
        if (this.container.getChildNodes() != null && (childNodes = this.container.getChildNodes()) != null && !childNodes.isEmpty()) {
            return childNodes.iterator().hasNext();
        }
        return false;
    }

    @Override
    public DataSchemaNode next() {
        return this.allChilds.iterator().next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

