/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.BaseTypes;

public final class BooleanType
implements BooleanTypeDefinition {
    private static final BooleanType INSTANCE = new BooleanType();
    private static final QName NAME = BaseTypes.constructQName("boolean");
    private static final SchemaPath PATH = new SchemaPath(Collections.singletonList(NAME), true);
    private static final String DESCRIPTION = "The boolean built-in type represents a boolean value.";
    private static final String REFERENCE = "https://tools.ietf.org/html/rfc6020#section-9.5";
    private static final String UNITS = "";

    private BooleanType() {
    }

    public static BooleanType getInstance() {
        return INSTANCE;
    }

    public BooleanTypeDefinition getBaseType() {
        return null;
    }

    public String getUnits() {
        return UNITS;
    }

    public Object getDefaultValue() {
        return false;
    }

    public QName getQName() {
        return NAME;
    }

    public SchemaPath getPath() {
        return PATH;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getReference() {
        return REFERENCE;
    }

    public Status getStatus() {
        return Status.CURRENT;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return Collections.emptyList();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BooleanType [name=");
        builder.append(NAME);
        builder.append(", path=");
        builder.append(PATH);
        builder.append("]");
        return builder.toString();
    }
}

