/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.BaseTypes;

public final class BitsType
implements BitsTypeDefinition {
    private final QName name = BaseTypes.constructQName("bits");
    private final SchemaPath path;
    private final String description = "The bits built-in type represents a bit set.  That is, a bits value is a set of flags identified by small integer position numbers starting at 0.  Each bit number has an assigned name.";
    private static final String REFERENCE = "https://tools.ietf.org/html/rfc6020#section-9.7";
    private final List<BitsTypeDefinition.Bit> bits;
    private static final String UNITS = "";

    public BitsType(SchemaPath path) {
        this.bits = Collections.emptyList();
        this.path = path;
    }

    public BitsType(SchemaPath path, List<BitsTypeDefinition.Bit> bits) {
        this.bits = Collections.unmodifiableList(bits);
        this.path = path;
    }

    public BitsTypeDefinition getBaseType() {
        return null;
    }

    public String getUnits() {
        return UNITS;
    }

    public Object getDefaultValue() {
        return this.bits;
    }

    public QName getQName() {
        return this.name;
    }

    public SchemaPath getPath() {
        return this.path;
    }

    public String getDescription() {
        return "The bits built-in type represents a bit set.  That is, a bits value is a set of flags identified by small integer position numbers starting at 0.  Each bit number has an assigned name.";
    }

    public String getReference() {
        return REFERENCE;
    }

    public Status getStatus() {
        return Status.CURRENT;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return Collections.emptyList();
    }

    public List<BitsTypeDefinition.Bit> getBits() {
        return this.bits;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bits == null ? 0 : this.bits.hashCode());
        result = 31 * result + ("The bits built-in type represents a bit set.  That is, a bits value is a set of flags identified by small integer position numbers starting at 0.  Each bit number has an assigned name." == null ? 0 : "The bits built-in type represents a bit set.  That is, a bits value is a set of flags identified by small integer position numbers starting at 0.  Each bit number has an assigned name.".hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitsType other = (BitsType)obj;
        if (this.bits == null ? other.bits != null : !this.bits.equals(other.bits)) {
            return false;
        }
        if ("The bits built-in type represents a bit set.  That is, a bits value is a set of flags identified by small integer position numbers starting at 0.  Each bit number has an assigned name." == null ? other.description != null : !"The bits built-in type represents a bit set.  That is, a bits value is a set of flags identified by small integer position numbers starting at 0.  Each bit number has an assigned name.".equals(other.description)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals((Object)other.name)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BitsType [name=");
        builder.append(this.name);
        builder.append(", path=");
        builder.append(this.path);
        builder.append(", description=");
        builder.append("The bits built-in type represents a bit set.  That is, a bits value is a set of flags identified by small integer position numbers starting at 0.  Each bit number has an assigned name.");
        builder.append(", reference=");
        builder.append(REFERENCE);
        builder.append(", bits=");
        builder.append(this.bits);
        builder.append(", units=");
        builder.append(UNITS);
        builder.append("]");
        return builder.toString();
    }
}

