/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.opendaylight.yangtools.yang.model.util.BaseConstraints;
import org.opendaylight.yangtools.yang.model.util.BaseTypes;

public final class BinaryType
implements BinaryTypeDefinition {
    private static final BinaryType INSTANCE = new BinaryType();
    private final QName name = BaseTypes.constructQName("binary");
    private final SchemaPath path = new SchemaPath(Collections.singletonList(this.name), true);
    private static final String DESCRIPTION = "The binary built-in type represents any binary data, i.e., a sequence of octets.";
    private static final String REFERENCE = "https://tools.ietf.org/html/rfc6020#section-9.8";
    private final List<Byte> bytes;
    private final List<LengthConstraint> lengthConstraints;
    private static final String UNITS = "";

    private BinaryType() {
        ArrayList<LengthConstraint> constraints = new ArrayList<LengthConstraint>();
        constraints.add(BaseConstraints.lengthConstraint(0, Long.MAX_VALUE, UNITS, UNITS));
        this.lengthConstraints = Collections.unmodifiableList(constraints);
        this.bytes = Collections.emptyList();
    }

    public static BinaryType getInstance() {
        return INSTANCE;
    }

    public BinaryTypeDefinition getBaseType() {
        return null;
    }

    public String getUnits() {
        return UNITS;
    }

    public Object getDefaultValue() {
        return this.bytes;
    }

    public QName getQName() {
        return this.name;
    }

    public SchemaPath getPath() {
        return this.path;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getReference() {
        return REFERENCE;
    }

    public Status getStatus() {
        return Status.CURRENT;
    }

    public List<LengthConstraint> getLengthConstraints() {
        return this.lengthConstraints;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return Collections.emptyList();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bytes == null ? 0 : this.bytes.hashCode());
        result = 31 * result + (this.lengthConstraints == null ? 0 : this.lengthConstraints.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryType other = (BinaryType)obj;
        if (this.bytes == null ? other.bytes != null : !this.bytes.equals(other.bytes)) {
            return false;
        }
        if (this.lengthConstraints == null ? other.lengthConstraints != null : !this.lengthConstraints.equals(other.lengthConstraints)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals((Object)other.name)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BinaryType [name=");
        builder.append(this.name);
        builder.append(", path=");
        builder.append(this.path);
        builder.append(", description=");
        builder.append(DESCRIPTION);
        builder.append(", reference=");
        builder.append(REFERENCE);
        builder.append(", bytes=");
        builder.append(this.bytes);
        builder.append(", lengthConstraints=");
        builder.append(this.lengthConstraints);
        builder.append(", units=");
        builder.append(UNITS);
        builder.append("]");
        return builder.toString();
    }
}

