/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public final class BaseTypes {
    public static final URI BASE_TYPES_NAMESPACE = URI.create("urn:ietf:params:xml:ns:yang:1");
    public static QName BINARY_QNAME = BaseTypes.constructQName("binary");
    public static QName BITS_QNAME = BaseTypes.constructQName("bits");
    public static QName BOOLEAN_QNAME = BaseTypes.constructQName("boolean");
    public static QName DECIMAL64_QNAME = BaseTypes.constructQName("decimal64");
    public static QName EMPTY_QNAME = BaseTypes.constructQName("empty");
    public static QName ENUMERATION_QNAME = BaseTypes.constructQName("enumeration");
    public static QName INT8_QNAME = BaseTypes.constructQName("int8");
    public static QName INT16_QNAME = BaseTypes.constructQName("int16");
    public static QName INT32_QNAME = BaseTypes.constructQName("int32");
    public static QName INT64_QNAME = BaseTypes.constructQName("int64");
    public static QName LEAFREF_QNAME = BaseTypes.constructQName("leafref");
    public static QName STRING_QNAME = BaseTypes.constructQName("string");
    public static QName UINT8_QNAME = BaseTypes.constructQName("uint8");
    public static QName UINT16_QNAME = BaseTypes.constructQName("uint16");
    public static QName UINT32_QNAME = BaseTypes.constructQName("uint32");
    public static QName UINT64_QNAME = BaseTypes.constructQName("uint64");

    private BaseTypes() {
    }

    public static QName constructQName(String typeName) {
        return new QName(BASE_TYPES_NAMESPACE, typeName);
    }

    public static SchemaPath schemaPath(QName typeName) {
        List<QName> pathList = Collections.singletonList(typeName);
        return new SchemaPath(pathList, true);
    }

    public static SchemaPath schemaPath(List<String> actualPath, URI namespace, Date revision) {
        if (actualPath == null) {
            throw new IllegalArgumentException("The actual path List MUST be specified.");
        }
        ArrayList<QName> pathList = new ArrayList<QName>();
        for (String path : actualPath) {
            QName qname = new QName(namespace, revision, path);
            if (qname == null) continue;
            pathList.add(qname);
        }
        return new SchemaPath(pathList, true);
    }
}

