/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;

public final class BaseConstraints {
    private BaseConstraints() {
    }

    public static LengthConstraint lengthConstraint(Number min, Number max, String description, String reference) {
        return new LengthConstraintImpl(min, max, description, reference);
    }

    public static RangeConstraint rangeConstraint(Number min, Number max, String description, String reference) {
        return new RangeConstraintImpl(min, max, description, reference);
    }

    public static PatternConstraint patternConstraint(String pattern, String description, String reference) {
        return new PatternConstraintImpl(pattern, description, reference);
    }

    private static final class PatternConstraintImpl
    implements PatternConstraint {
        private final String regex;
        private final String description;
        private final String reference;
        private final String errorAppTag;
        private final String errorMessage;

        public PatternConstraintImpl(String regex, String description, String reference) {
            this.regex = regex;
            this.description = description;
            this.reference = reference;
            this.errorAppTag = "invalid-regular-expression";
            this.errorMessage = "";
        }

        public String getDescription() {
            return this.description;
        }

        public String getErrorAppTag() {
            return this.errorAppTag;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getReference() {
            return this.reference;
        }

        public String getRegularExpression() {
            return this.regex;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
            result = 31 * result + (this.errorAppTag == null ? 0 : this.errorAppTag.hashCode());
            result = 31 * result + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            result = 31 * result + (this.reference == null ? 0 : this.reference.hashCode());
            result = 31 * result + (this.regex == null ? 0 : this.regex.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PatternConstraintImpl other = (PatternConstraintImpl)obj;
            if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
                return false;
            }
            if (this.errorAppTag == null ? other.errorAppTag != null : !this.errorAppTag.equals(other.errorAppTag)) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.reference == null ? other.reference != null : !this.reference.equals(other.reference)) {
                return false;
            }
            return !(this.regex == null ? other.regex != null : !this.regex.equals(other.regex));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("PatternConstraintImpl [regex=");
            builder.append(this.regex);
            builder.append(", description=");
            builder.append(this.description);
            builder.append(", reference=");
            builder.append(this.reference);
            builder.append(", errorAppTag=");
            builder.append(this.errorAppTag);
            builder.append(", errorMessage=");
            builder.append(this.errorMessage);
            builder.append("]");
            return builder.toString();
        }
    }

    private static final class RangeConstraintImpl
    implements RangeConstraint {
        private final Number min;
        private final Number max;
        private final String description;
        private final String reference;
        private final String errorAppTag;
        private final String errorMessage;

        public RangeConstraintImpl(Number min, Number max, String description, String reference) {
            this.min = min;
            this.max = max;
            this.description = description;
            this.reference = reference;
            this.errorAppTag = "range-out-of-specified-bounds";
            this.errorMessage = "The argument is out of bounds <" + min + ", " + max + ">";
        }

        public String getDescription() {
            return this.description;
        }

        public String getErrorAppTag() {
            return this.errorAppTag;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getReference() {
            return this.reference;
        }

        public Number getMin() {
            return this.min;
        }

        public Number getMax() {
            return this.max;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
            result = 31 * result + (this.errorAppTag == null ? 0 : this.errorAppTag.hashCode());
            result = 31 * result + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            result = 31 * result + (this.max == null ? 0 : this.max.hashCode());
            result = 31 * result + (this.min == null ? 0 : this.min.hashCode());
            result = 31 * result + (this.reference == null ? 0 : this.reference.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RangeConstraintImpl other = (RangeConstraintImpl)obj;
            if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
                return false;
            }
            if (this.errorAppTag == null ? other.errorAppTag != null : !this.errorAppTag.equals(other.errorAppTag)) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.max == null ? other.max != null : !this.max.equals(other.max)) {
                return false;
            }
            if (this.min == null ? other.min != null : !this.min.equals(other.min)) {
                return false;
            }
            return !(this.reference == null ? other.reference != null : !this.reference.equals(other.reference));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RangeConstraintImpl [min=");
            builder.append(this.min);
            builder.append(", max=");
            builder.append(this.max);
            builder.append(", description=");
            builder.append(this.description);
            builder.append(", reference=");
            builder.append(this.reference);
            builder.append(", errorAppTag=");
            builder.append(this.errorAppTag);
            builder.append(", errorMessage=");
            builder.append(this.errorMessage);
            builder.append("]");
            return builder.toString();
        }
    }

    private static final class LengthConstraintImpl
    implements LengthConstraint {
        private final Number min;
        private final Number max;
        private final String description;
        private final String reference;
        private final String errorAppTag;
        private final String errorMessage;

        public LengthConstraintImpl(Number min, Number max, String description, String reference) {
            this.min = min;
            this.max = max;
            this.description = description;
            this.reference = reference;
            this.errorAppTag = "length-out-of-specified-bounds";
            this.errorMessage = "The argument is out of bounds <" + min + ", " + max + ">";
        }

        public String getDescription() {
            return this.description;
        }

        public String getErrorAppTag() {
            return this.errorAppTag;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getReference() {
            return this.reference;
        }

        public Number getMin() {
            return this.min;
        }

        public Number getMax() {
            return this.max;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
            result = 31 * result + (this.errorAppTag == null ? 0 : this.errorAppTag.hashCode());
            result = 31 * result + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            result = 31 * result + (this.max == null ? 0 : this.max.hashCode());
            result = 31 * result + (this.min == null ? 0 : this.min.hashCode());
            result = 31 * result + (this.reference == null ? 0 : this.reference.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LengthConstraintImpl other = (LengthConstraintImpl)obj;
            if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
                return false;
            }
            if (this.errorAppTag == null ? other.errorAppTag != null : !this.errorAppTag.equals(other.errorAppTag)) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.max != other.max) {
                return false;
            }
            if (this.min != other.min) {
                return false;
            }
            return !(this.reference == null ? other.reference != null : !this.reference.equals(other.reference));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("LengthConstraintImpl [min=");
            builder.append(this.min);
            builder.append(", max=");
            builder.append(this.max);
            builder.append(", description=");
            builder.append(this.description);
            builder.append(", errorAppTag=");
            builder.append(this.errorAppTag);
            builder.append(", reference=");
            builder.append(this.reference);
            builder.append(", errorMessage=");
            builder.append(this.errorMessage);
            builder.append("]");
            return builder.toString();
        }
    }
}

