/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.IntegerTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;
import org.opendaylight.yangtools.yang.model.util.BaseConstraints;

abstract class AbstractSignedInteger
implements IntegerTypeDefinition {
    private final QName name;
    private final SchemaPath path;
    private final String description;
    private static final String REFERENCE = "https://tools.ietf.org/html/rfc6020#section-9.2";
    private final String units;
    private final List<RangeConstraint> rangeStatements;

    public AbstractSignedInteger(QName name, String description, Number minRange, Number maxRange, String units) {
        this.name = name;
        this.path = new SchemaPath(Collections.singletonList(name), true);
        this.description = description;
        this.units = units;
        this.rangeStatements = new ArrayList<RangeConstraint>();
        String rangeDescription = "Integer values between " + minRange + " and " + maxRange + ", inclusively.";
        this.rangeStatements.add(BaseConstraints.rangeConstraint(minRange, maxRange, rangeDescription, "https://tools.ietf.org/html/rfc6020#section-9.2.4"));
    }

    public IntegerTypeDefinition getBaseType() {
        return null;
    }

    public String getUnits() {
        return this.units;
    }

    public QName getQName() {
        return this.name;
    }

    public SchemaPath getPath() {
        return this.path;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReference() {
        return REFERENCE;
    }

    public Status getStatus() {
        return Status.CURRENT;
    }

    public List<RangeConstraint> getRangeConstraints() {
        return this.rangeStatements;
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return Collections.emptyList();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.rangeStatements == null ? 0 : this.rangeStatements.hashCode());
        result = 31 * result + (this.units == null ? 0 : this.units.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSignedInteger other = (AbstractSignedInteger)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals((Object)other.name)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals((Object)other.path)) {
            return false;
        }
        if (this.rangeStatements == null ? other.rangeStatements != null : !this.rangeStatements.equals(other.rangeStatements)) {
            return false;
        }
        return !(this.units == null ? other.units != null : !this.units.equals(other.units));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AbstractInteger [name=");
        builder.append(this.name);
        builder.append(", path=");
        builder.append(this.path);
        builder.append(", description=");
        builder.append(this.description);
        builder.append(", reference=");
        builder.append(REFERENCE);
        builder.append(", units=");
        builder.append(this.units);
        builder.append(", rangeStatements=");
        builder.append(this.rangeStatements);
        builder.append("]");
        return builder.toString();
    }
}

