/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.flowprogrammer.northbound;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.codehaus.enunciate.jaxrs.TypeHint;
import org.opendaylight.controller.containermanager.IContainerManager;
import org.opendaylight.controller.flowprogrammer.northbound.FlowConfigs;
import org.opendaylight.controller.forwardingrulesmanager.FlowConfig;
import org.opendaylight.controller.forwardingrulesmanager.IForwardingRulesManager;
import org.opendaylight.controller.northbound.commons.RestMessages;
import org.opendaylight.controller.northbound.commons.exception.InternalServerErrorException;
import org.opendaylight.controller.northbound.commons.exception.MethodNotAllowedException;
import org.opendaylight.controller.northbound.commons.exception.NotAcceptableException;
import org.opendaylight.controller.northbound.commons.exception.ResourceNotFoundException;
import org.opendaylight.controller.northbound.commons.exception.ServiceUnavailableException;
import org.opendaylight.controller.northbound.commons.exception.UnauthorizedException;
import org.opendaylight.controller.northbound.commons.utils.NorthboundUtils;
import org.opendaylight.controller.sal.authorization.Privilege;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.switchmanager.ISwitchManager;

@Path(value="/")
public class FlowProgrammerNorthbound {
    private String username;

    @Context
    public void setSecurityContext(SecurityContext context) {
        if (context != null && context.getUserPrincipal() != null) {
            this.username = context.getUserPrincipal().getName();
        }
    }

    protected String getUserName() {
        return this.username;
    }

    private IForwardingRulesManager getForwardingRulesManagerService(String containerName) {
        IContainerManager containerManager = (IContainerManager)ServiceHelper.getGlobalInstance(IContainerManager.class, (Object)this);
        if (containerManager == null) {
            throw new ServiceUnavailableException("Container " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        boolean found = false;
        List containerNames = containerManager.getContainerNames();
        for (String cName : containerNames) {
            if (!cName.trim().equalsIgnoreCase(containerName.trim())) continue;
            found = true;
        }
        if (!found) {
            throw new ResourceNotFoundException(containerName + " " + RestMessages.NOCONTAINER.toString());
        }
        IForwardingRulesManager frm = (IForwardingRulesManager)ServiceHelper.getInstance(IForwardingRulesManager.class, (String)containerName, (Object)this);
        if (frm == null) {
            throw new ServiceUnavailableException("Flow Programmer " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        return frm;
    }

    private List<FlowConfig> getStaticFlowsInternal(String containerName, Node node) {
        IForwardingRulesManager frm = this.getForwardingRulesManagerService(containerName);
        if (frm == null) {
            throw new ServiceUnavailableException("Flow Programmer " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        ArrayList<FlowConfig> flows = new ArrayList<FlowConfig>();
        if (node == null) {
            for (FlowConfig flow : frm.getStaticFlows()) {
                flows.add(flow);
            }
        } else {
            ISwitchManager sm = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
            if (sm == null) {
                throw new ServiceUnavailableException("Switch Manager " + RestMessages.SERVICEUNAVAILABLE.toString());
            }
            if (!sm.getNodes().contains(node)) {
                throw new ResourceNotFoundException(node.toString() + " : " + RestMessages.NONODE.toString());
            }
            for (FlowConfig flow : frm.getStaticFlows(node)) {
                flows.add(flow);
            }
        }
        return flows;
    }

    @Path(value="/{containerName}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @TypeHint(value=FlowConfigs.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=404, condition="The containerName is not found"), @ResponseCode(code=503, condition="One or more of Controller Services are unavailable")})
    public FlowConfigs getStaticFlows(@PathParam(value="containerName") String containerName) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.READ, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        List<FlowConfig> flowConfigs = this.getStaticFlowsInternal(containerName, null);
        return new FlowConfigs(flowConfigs);
    }

    @Path(value="/{containerName}/node/{nodeType}/{nodeId}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @TypeHint(value=FlowConfigs.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=404, condition="The containerName or nodeId is not found"), @ResponseCode(code=503, condition="One or more of Controller Services are unavailable")})
    public FlowConfigs getStaticFlows(@PathParam(value="containerName") String containerName, @PathParam(value="nodeType") String nodeType, @PathParam(value="nodeId") String nodeId) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.READ, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        Node node = Node.fromString((String)nodeType, (String)nodeId);
        if (node == null) {
            throw new ResourceNotFoundException(nodeId + " : " + RestMessages.NONODE.toString());
        }
        List<FlowConfig> flows = this.getStaticFlowsInternal(containerName, node);
        return new FlowConfigs(flows);
    }

    @Path(value="/{containerName}/node/{nodeType}/{nodeId}/staticFlow/{name}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @TypeHint(value=FlowConfig.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=404, condition="The containerName or NodeId or Configuration name is not found"), @ResponseCode(code=503, condition="One or more of Controller Services are unavailable")})
    public FlowConfig getStaticFlow(@PathParam(value="containerName") String containerName, @PathParam(value="nodeType") String nodeType, @PathParam(value="nodeId") String nodeId, @PathParam(value="name") String name) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.READ, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        IForwardingRulesManager frm = this.getForwardingRulesManagerService(containerName);
        if (frm == null) {
            throw new ServiceUnavailableException("Flow Programmer " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        Node node = this.handleNodeAvailability(containerName, nodeType, nodeId);
        FlowConfig staticFlow = frm.getStaticFlow(name, node);
        if (staticFlow == null) {
            throw new ResourceNotFoundException(RestMessages.NOFLOW.toString());
        }
        return new FlowConfig(staticFlow);
    }

    @Path(value="/{containerName}/node/{nodeType}/{nodeId}/staticFlow/{name}")
    @PUT
    @Consumes(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Static Flow modified successfully"), @ResponseCode(code=201, condition="Flow Config processed successfully"), @ResponseCode(code=400, condition="Failed to create Static Flow entry due to invalid flow configuration"), @ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=404, condition="The Container Name or nodeId is not found"), @ResponseCode(code=406, condition="Cannot operate on Default Container when other Containers are active"), @ResponseCode(code=409, condition="Failed to create Static Flow entry due to Conflicting Name or configuration"), @ResponseCode(code=500, condition="Failed to create Static Flow entry. Failure Reason included in HTTP Error response"), @ResponseCode(code=503, condition="One or more of Controller services are unavailable")})
    public Response addOrModifyFlow(@PathParam(value="containerName") String containerName, @PathParam(value="name") String name, @PathParam(value="nodeType") String nodeType, @PathParam(value="nodeId") String nodeId, @TypeHint(value=FlowConfig.class) FlowConfig flowConfig) {
        Status status;
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.WRITE, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        if (flowConfig.getNode() == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid Configuration. Node is null or empty").build();
        }
        this.handleResourceCongruence(name, flowConfig.getName());
        this.handleResourceCongruence(nodeId, flowConfig.getNode().getNodeIDString());
        this.handleDefaultDisabled(containerName);
        IForwardingRulesManager frm = this.getForwardingRulesManagerService(containerName);
        if (frm == null) {
            throw new ServiceUnavailableException("Flow Programmer " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        Node node = this.handleNodeAvailability(containerName, nodeType, nodeId);
        FlowConfig staticFlow = frm.getStaticFlow(name, node);
        if (staticFlow == null) {
            status = frm.addStaticFlow(flowConfig);
            if (status.isSuccess()) {
                NorthboundUtils.auditlog((String)"Flow Entry", (String)this.username, (String)"added", (String)(name + " on Node " + NorthboundUtils.getNodeDesc((Node)node, (String)containerName, (Object)this)), (String)containerName);
                return Response.status((Response.Status)Response.Status.CREATED).entity((Object)"Success").build();
            }
        } else {
            status = frm.modifyStaticFlow(flowConfig);
            if (status.isSuccess()) {
                NorthboundUtils.auditlog((String)"Flow Entry", (String)this.username, (String)"updated", (String)(name + " on Node " + NorthboundUtils.getNodeDesc((Node)node, (String)containerName, (Object)this)), (String)containerName);
                return NorthboundUtils.getResponse((Status)status);
            }
        }
        return NorthboundUtils.getResponse((Status)status);
    }

    @Path(value="/{containerName}/node/{nodeType}/{nodeId}/staticFlow/{name}")
    @DELETE
    @StatusCodes(value={@ResponseCode(code=204, condition="Flow Config deleted successfully"), @ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=404, condition="The Container Name or Node-id or Flow Name passed is not found"), @ResponseCode(code=406, condition="Failed to delete Flow config due to invalid operation. Failure details included in HTTP Error response"), @ResponseCode(code=500, condition="Failed to delete Flow config. Failure Reason included in HTTP Error response"), @ResponseCode(code=503, condition="One or more of Controller service is unavailable")})
    public Response deleteFlow(@PathParam(value="containerName") String containerName, @PathParam(value="name") String name, @PathParam(value="nodeType") String nodeType, @PathParam(value="nodeId") String nodeId) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.WRITE, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        this.handleDefaultDisabled(containerName);
        IForwardingRulesManager frm = this.getForwardingRulesManagerService(containerName);
        if (frm == null) {
            throw new ServiceUnavailableException("Flow Programmer " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        Node node = this.handleNodeAvailability(containerName, nodeType, nodeId);
        FlowConfig staticFlow = frm.getStaticFlow(name, node);
        if (staticFlow == null) {
            throw new ResourceNotFoundException(name + " : " + RestMessages.NOFLOW.toString());
        }
        Status status = frm.removeStaticFlow(name, node);
        if (status.isSuccess()) {
            NorthboundUtils.auditlog((String)"Flow Entry", (String)this.username, (String)"removed", (String)(name + " from Node " + NorthboundUtils.getNodeDesc((Node)node, (String)containerName, (Object)this)), (String)containerName);
            return Response.noContent().build();
        }
        return NorthboundUtils.getResponse((Status)status);
    }

    @Path(value="/{containerName}/node/{nodeType}/{nodeId}/staticFlow/{name}")
    @POST
    @Consumes(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Flow Config processed successfully"), @ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=404, condition="The Container Name or Node-id or Flow Name passed is not found"), @ResponseCode(code=406, condition="Failed to delete Flow config due to invalid operation. Failure details included in HTTP Error response"), @ResponseCode(code=500, condition="Failed to delete Flow config. Failure Reason included in HTTP Error response"), @ResponseCode(code=503, condition="One or more of Controller service is unavailable")})
    public Response toggleFlow(@PathParam(value="containerName") String containerName, @PathParam(value="nodeType") String nodeType, @PathParam(value="nodeId") String nodeId, @PathParam(value="name") String name) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.WRITE, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        this.handleDefaultDisabled(containerName);
        IForwardingRulesManager frm = this.getForwardingRulesManagerService(containerName);
        if (frm == null) {
            throw new ServiceUnavailableException("Flow Programmer " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        Node node = this.handleNodeAvailability(containerName, nodeType, nodeId);
        FlowConfig staticFlow = frm.getStaticFlow(name, node);
        if (staticFlow == null) {
            throw new ResourceNotFoundException(name + " : " + RestMessages.NOFLOW.toString());
        }
        Status status = frm.toggleStaticFlowStatus(staticFlow);
        if (status.isSuccess()) {
            NorthboundUtils.auditlog((String)"Flow Entry", (String)this.username, (String)"toggled", (String)(name + " on Node " + NorthboundUtils.getNodeDesc((Node)node, (String)containerName, (Object)this)), (String)containerName);
        }
        return NorthboundUtils.getResponse((Status)status);
    }

    private Node handleNodeAvailability(String containerName, String nodeType, String nodeId) {
        Node node = Node.fromString((String)nodeType, (String)nodeId);
        if (node == null) {
            throw new ResourceNotFoundException(nodeId + " : " + RestMessages.NONODE.toString());
        }
        ISwitchManager sm = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
        if (sm == null) {
            throw new ServiceUnavailableException("Switch Manager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (!sm.getNodes().contains(node)) {
            throw new ResourceNotFoundException(node.toString() + " : " + RestMessages.NONODE.toString());
        }
        return node;
    }

    private void handleDefaultDisabled(String containerName) {
        IContainerManager containerManager = (IContainerManager)ServiceHelper.getGlobalInstance(IContainerManager.class, (Object)this);
        if (containerManager == null) {
            throw new InternalServerErrorException(RestMessages.INTERNALERROR.toString());
        }
        if (containerName.equals(GlobalConstants.DEFAULT.toString()) && containerManager.hasNonDefaultContainer()) {
            throw new NotAcceptableException(RestMessages.DEFAULTDISABLED.toString());
        }
    }

    private void handleResourceCongruence(String resource, String configured) {
        if (!resource.equals(configured)) {
            throw new MethodNotAllowedException("Path's resource name conflicts with payload's resource name");
        }
    }
}

