/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.monitoring.xml.model;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.netconf.api.monitoring.NetconfMonitoringService;
import org.opendaylight.controller.netconf.monitoring.xml.model.MonitoringSchema;
import org.opendaylight.controller.netconf.monitoring.xml.model.MonitoringSession;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Schemas;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Sessions;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.schemas.Schema;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.sessions.Session;

@XmlRootElement(name="netconf-state")
public final class NetconfState {
    private Schemas schemas;
    private Sessions sessions;

    public NetconfState(NetconfMonitoringService monitoringService) {
        this.sessions = monitoringService.getSessions();
        this.schemas = monitoringService.getSchemas();
    }

    public NetconfState() {
    }

    @XmlElementWrapper(name="schemas")
    @XmlElement(name="schema")
    public Collection<MonitoringSchema> getSchemas() {
        return Collections2.transform((Collection)this.schemas.getSchema(), (Function)new Function<Schema, MonitoringSchema>(){

            @Nullable
            public MonitoringSchema apply(@Nullable Schema input) {
                return new MonitoringSchema(input);
            }
        });
    }

    @XmlElementWrapper(name="sessions")
    @XmlElement(name="session")
    public Collection<MonitoringSession> getSessions() {
        return Collections2.transform((Collection)this.sessions.getSession(), (Function)new Function<Session, MonitoringSession>(){

            @Nullable
            public MonitoringSession apply(@Nullable Session input) {
                return new MonitoringSession(input);
            }
        });
    }
}

