/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.monitoring.xml.model;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.extension.rev131210.Session1;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.sessions.Session;
import org.opendaylight.yangtools.yang.common.QName;

final class MonitoringSession {
    @XmlTransient
    private Session managementSession;

    public MonitoringSession(Session managementSession) {
        this.managementSession = managementSession;
    }

    public MonitoringSession() {
    }

    public void setManagementSession(Session managementSession) {
        this.managementSession = managementSession;
    }

    @XmlElement(name="session-id")
    public long getId() {
        return this.managementSession.getSessionId();
    }

    @XmlElement(name="source-host")
    public String getSourceHost() {
        return this.managementSession.getSourceHost().getDomainName().getValue();
    }

    @XmlElement(name="login-time")
    public String getLoginTime() {
        return this.managementSession.getLoginTime().getValue();
    }

    @XmlElement(name="in-bad-rpcs")
    public Long getInBadRpcs() {
        return this.managementSession.getInBadRpcs().getValue();
    }

    @XmlElement(name="in-rpcs")
    public Long getInRpcs() {
        return this.managementSession.getInRpcs().getValue();
    }

    @XmlElement(name="out-notifications")
    public Long getOutNotifications() {
        return this.managementSession.getOutNotifications().getValue();
    }

    @XmlElement(name="out-rpc-errors")
    public Long getOutRpcErrors() {
        return this.managementSession.getOutRpcErrors().getValue();
    }

    @XmlElement(name="transport")
    public String getTransport() {
        try {
            QName qName = (QName)this.managementSession.getTransport().getField("QNAME").get(null);
            return qName.getLocalName();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new IllegalArgumentException("Unknown transport type " + this.managementSession.getTransport(), e);
        }
    }

    @XmlElement(name="session-identifier")
    public String getSessionType() {
        return ((Session1)this.managementSession.getAugmentation(Session1.class)).getSessionIdentifier();
    }

    @XmlElement(name="username")
    public String getUsername() {
        return this.managementSession.getUsername();
    }
}

