/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.monitoring.xml.model;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlElement;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.Yang;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.schemas.Schema;

final class MonitoringSchema {
    private final Schema schema;

    public MonitoringSchema(Schema schema) {
        this.schema = schema;
    }

    @XmlElement(name="identifier")
    public String getIdentifier() {
        return this.schema.getIdentifier();
    }

    @XmlElement(name="namespace")
    public String getNamespace() {
        return this.schema.getNamespace().getValue().toString();
    }

    @XmlElement(name="location")
    public Collection<String> getLocation() {
        return Collections2.transform((Collection)this.schema.getLocation(), (Function)new Function<Schema.Location, String>(){

            @Nullable
            public String apply(@Nullable Schema.Location input) {
                return input.getEnumeration().toString();
            }
        });
    }

    @XmlElement(name="version")
    public String getVersion() {
        return this.schema.getVersion();
    }

    @XmlElement(name="format")
    public String getFormat() {
        Preconditions.checkState((this.schema.getFormat() == Yang.class ? 1 : 0) != 0, (String)"Only yang format permitted, but was %s", (Object[])new Object[]{this.schema.getFormat()});
        return "yang";
    }
}

