/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.monitoring.osgi;

import com.google.common.base.Preconditions;
import java.util.Hashtable;
import org.opendaylight.controller.netconf.api.monitoring.NetconfMonitoringService;
import org.opendaylight.controller.netconf.mapping.api.NetconfOperationServiceFactory;
import org.opendaylight.controller.netconf.monitoring.osgi.NetconfMonitoringActivator;
import org.opendaylight.controller.netconf.monitoring.osgi.NetconfMonitoringOperationService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfMonitoringServiceTracker
extends ServiceTracker<NetconfMonitoringService, NetconfMonitoringService> {
    private static final Logger logger = LoggerFactory.getLogger(NetconfMonitoringServiceTracker.class);
    private ServiceRegistration<NetconfOperationServiceFactory> reg;

    NetconfMonitoringServiceTracker(BundleContext context) {
        super(context, NetconfMonitoringService.class, null);
    }

    public NetconfMonitoringService addingService(ServiceReference<NetconfMonitoringService> reference) {
        Preconditions.checkState((this.reg == null ? 1 : 0) != 0, (Object)"Monitoring service was already added");
        NetconfMonitoringService netconfMonitoringService = (NetconfMonitoringService)super.addingService(reference);
        NetconfMonitoringOperationService operationService = new NetconfMonitoringOperationService(netconfMonitoringService);
        NetconfMonitoringActivator.NetconfMonitoringOperationServiceFactory factory = new NetconfMonitoringActivator.NetconfMonitoringOperationServiceFactory(operationService);
        Hashtable props = new Hashtable();
        this.reg = this.context.registerService(NetconfOperationServiceFactory.class, (Object)factory, props);
        return netconfMonitoringService;
    }

    public void removedService(ServiceReference<NetconfMonitoringService> reference, NetconfMonitoringService netconfMonitoringService) {
        if (this.reg != null) {
            try {
                this.reg.unregister();
            }
            catch (Exception e) {
                logger.warn("Ignoring exception while unregistering {}", this.reg, (Object)e);
            }
        }
    }
}

