/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.monitoring.osgi;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opendaylight.controller.netconf.api.monitoring.NetconfMonitoringService;
import org.opendaylight.controller.netconf.mapping.api.Capability;
import org.opendaylight.controller.netconf.mapping.api.NetconfOperation;
import org.opendaylight.controller.netconf.mapping.api.NetconfOperationFilter;
import org.opendaylight.controller.netconf.mapping.api.NetconfOperationService;
import org.opendaylight.controller.netconf.monitoring.Get;
import org.opendaylight.controller.netconf.monitoring.MonitoringConstants;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.netconf.monitoring.rev101004.netconf.state.Schemas;

public class NetconfMonitoringOperationService
implements NetconfOperationService {
    public static final HashSet<Capability> CAPABILITIES = Sets.newHashSet((Object[])new Capability[]{new Capability(){

        public String getCapabilityUri() {
            return MonitoringConstants.URI;
        }

        public Optional<String> getModuleNamespace() {
            return Optional.of((Object)"urn:ietf:params:xml:ns:yang:ietf-netconf-monitoring");
        }

        public Optional<String> getModuleName() {
            return Optional.of((Object)"ietf-netconf-monitoring");
        }

        public Optional<String> getRevision() {
            return Optional.of((Object)"2010-10-04");
        }

        public Optional<String> getCapabilitySchema() {
            return Optional.absent();
        }

        public Optional<List<String>> getLocation() {
            return Optional.absent();
        }
    }});
    private final NetconfMonitoringService monitor;

    public NetconfMonitoringOperationService(NetconfMonitoringService monitor) {
        this.monitor = monitor;
    }

    private static String readSchema() {
        String schemaLocation = "/META-INF/yang/ietf-netconf-monitoring.yang";
        URL resource = Schemas.class.getClassLoader().getResource(schemaLocation);
        Preconditions.checkNotNull((Object)resource, (String)"Unable to read schema content from %s", (Object[])new Object[]{schemaLocation});
        File file = new File(resource.getFile());
        try {
            return Files.toString((File)file, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load schema from " + schemaLocation, e);
        }
    }

    public Set<Capability> getCapabilities() {
        return CAPABILITIES;
    }

    public Set<NetconfOperation> getNetconfOperations() {
        return Collections.emptySet();
    }

    public Set<NetconfOperationFilter> getFilters() {
        return Sets.newHashSet((Object[])new NetconfOperationFilter[]{new Get(this.monitor)});
    }

    public void close() {
    }
}

