/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.monitoring.osgi;

import org.opendaylight.controller.netconf.mapping.api.NetconfOperationService;
import org.opendaylight.controller.netconf.mapping.api.NetconfOperationServiceFactory;
import org.opendaylight.controller.netconf.monitoring.osgi.NetconfMonitoringOperationService;
import org.opendaylight.controller.netconf.monitoring.osgi.NetconfMonitoringServiceTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfMonitoringActivator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(NetconfMonitoringActivator.class);
    private NetconfMonitoringServiceTracker monitor;

    public void start(BundleContext context) throws Exception {
        this.monitor = new NetconfMonitoringServiceTracker(context);
        this.monitor.open();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.monitor != null) {
            try {
                this.monitor.close();
            }
            catch (Exception e) {
                logger.warn("Ignoring exception while closing {}", (Object)this.monitor, (Object)e);
            }
        }
    }

    public static class NetconfMonitoringOperationServiceFactory
    implements NetconfOperationServiceFactory {
        private final NetconfMonitoringOperationService operationService;

        public NetconfMonitoringOperationServiceFactory(NetconfMonitoringOperationService operationService) {
            this.operationService = operationService;
        }

        public NetconfOperationService createService(long netconfSessionId, String netconfSessionIdForReporting) {
            return this.operationService;
        }
    }
}

