/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.monitoring;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.api.NetconfOperationRouter;
import org.opendaylight.controller.netconf.api.monitoring.NetconfMonitoringService;
import org.opendaylight.controller.netconf.mapping.api.NetconfOperationFilter;
import org.opendaylight.controller.netconf.mapping.api.NetconfOperationFilterChain;
import org.opendaylight.controller.netconf.monitoring.xml.JaxBSerializer;
import org.opendaylight.controller.netconf.monitoring.xml.model.NetconfState;
import org.opendaylight.controller.netconf.util.mapping.AbstractNetconfOperation;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Get
implements NetconfOperationFilter {
    private static final Logger logger = LoggerFactory.getLogger(Get.class);
    private final NetconfMonitoringService netconfMonitor;

    public Get(NetconfMonitoringService netconfMonitor) {
        this.netconfMonitor = netconfMonitor;
    }

    public Document doFilter(Document message, NetconfOperationRouter operationRouter, NetconfOperationFilterChain filterChain) throws NetconfDocumentedException {
        AbstractNetconfOperation.OperationNameAndNamespace operationNameAndNamespace = new AbstractNetconfOperation.OperationNameAndNamespace(message);
        if (this.canHandle(operationNameAndNamespace)) {
            return this.handle(message, operationRouter, filterChain);
        }
        return filterChain.execute(message, operationRouter);
    }

    private Document handle(Document message, NetconfOperationRouter operationRouter, NetconfOperationFilterChain filterChain) throws NetconfDocumentedException {
        try {
            Document innerResult = filterChain.execute(message, operationRouter);
            NetconfState netconfMonitoring = new NetconfState(this.netconfMonitor);
            Element monitoringXmlElement = new JaxBSerializer().toXml(netconfMonitoring);
            monitoringXmlElement = (Element)innerResult.importNode(monitoringXmlElement, true);
            Element monitoringXmlElementPlaceholder = this.getPlaceholder(innerResult);
            monitoringXmlElementPlaceholder.appendChild(monitoringXmlElement);
            return innerResult;
        }
        catch (RuntimeException e) {
            String errorMessage = "Get operation for netconf-state subtree failed";
            logger.warn(errorMessage, (Throwable)e);
            HashMap info = Maps.newHashMap();
            info.put(NetconfDocumentedException.ErrorSeverity.error.toString(), e.getMessage());
            throw new NetconfDocumentedException(errorMessage, NetconfDocumentedException.ErrorType.application, NetconfDocumentedException.ErrorTag.operation_failed, NetconfDocumentedException.ErrorSeverity.error, (Map)info);
        }
    }

    private Element getPlaceholder(Document innerResult) {
        try {
            XmlElement rootElement = XmlElement.fromDomElementWithExpected((Element)innerResult.getDocumentElement(), (String)"rpc-reply", (String)"urn:ietf:params:xml:ns:netconf:base:1.0");
            return rootElement.getOnlyChildElement("data").getDomElement();
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(String.format("Input xml in wrong format, Expecting root element %s with child element %s, but was %s", "rpc-reply", "data", XmlUtil.toString((Element)innerResult.getDocumentElement())), e);
        }
    }

    private boolean canHandle(AbstractNetconfOperation.OperationNameAndNamespace operationNameAndNamespace) {
        if (!operationNameAndNamespace.getOperationName().equals("get")) {
            return false;
        }
        return operationNameAndNamespace.getNamespace().equals("urn:ietf:params:xml:ns:netconf:base:1.0");
    }

    public int getSortingOrder() {
        return 1;
    }

    public int compareTo(NetconfOperationFilter o) {
        return Integer.compare(this.getSortingOrder(), o.getSortingOrder());
    }
}

