/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.topology.northbound;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.codehaus.enunciate.jaxrs.TypeHint;
import org.opendaylight.controller.northbound.commons.RestMessages;
import org.opendaylight.controller.northbound.commons.exception.InternalServerErrorException;
import org.opendaylight.controller.northbound.commons.exception.ResourceNotFoundException;
import org.opendaylight.controller.northbound.commons.exception.UnauthorizedException;
import org.opendaylight.controller.northbound.commons.utils.NorthboundUtils;
import org.opendaylight.controller.sal.authorization.Privilege;
import org.opendaylight.controller.sal.core.Edge;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.topology.northbound.EdgeProperties;
import org.opendaylight.controller.topology.northbound.Topology;
import org.opendaylight.controller.topology.northbound.TopologyUserLinks;
import org.opendaylight.controller.topologymanager.ITopologyManager;
import org.opendaylight.controller.topologymanager.TopologyUserLinkConfig;

@Path(value="/")
public class TopologyNorthboundJAXRS {
    private String username;

    @Context
    public void setSecurityContext(SecurityContext context) {
        if (context != null && context.getUserPrincipal() != null) {
            this.username = context.getUserPrincipal().getName();
        }
    }

    protected String getUserName() {
        return this.username;
    }

    @Path(value="/{containerName}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @TypeHint(value=Topology.class)
    @StatusCodes(value={@ResponseCode(code=404, condition="The Container Name was not found")})
    public Topology getTopology(@PathParam(value="containerName") String containerName) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.READ, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        ITopologyManager topologyManager = (ITopologyManager)ServiceHelper.getInstance(ITopologyManager.class, (String)containerName, (Object)this);
        if (topologyManager == null) {
            throw new ResourceNotFoundException(RestMessages.NOCONTAINER.toString());
        }
        Map topo = topologyManager.getEdges();
        if (topo != null) {
            ArrayList<EdgeProperties> res = new ArrayList<EdgeProperties>();
            for (Map.Entry entry : topo.entrySet()) {
                EdgeProperties el = new EdgeProperties((Edge)entry.getKey(), (Set)entry.getValue());
                res.add(el);
            }
            return new Topology(res);
        }
        return null;
    }

    @Path(value="/{containerName}/userLinks")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @TypeHint(value=TopologyUserLinks.class)
    @StatusCodes(value={@ResponseCode(code=404, condition="The Container Name was not found")})
    public TopologyUserLinks getUserLinks(@PathParam(value="containerName") String containerName) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.READ, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        ITopologyManager topologyManager = (ITopologyManager)ServiceHelper.getInstance(ITopologyManager.class, (String)containerName, (Object)this);
        if (topologyManager == null) {
            throw new ResourceNotFoundException(RestMessages.NOCONTAINER.toString());
        }
        ConcurrentMap userLinks = topologyManager.getUserLinks();
        if (userLinks != null && userLinks.values() != null) {
            ArrayList<TopologyUserLinkConfig> res = new ArrayList<TopologyUserLinkConfig>(userLinks.values());
            return new TopologyUserLinks(res);
        }
        return null;
    }

    @Path(value="/{containerName}/userLink/{name}")
    @PUT
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=201, condition="User Link added successfully"), @ResponseCode(code=404, condition="The Container Name was not found"), @ResponseCode(code=409, condition="Failed to add User Link due to Conflicting Name"), @ResponseCode(code=500, condition="Failed to add User Link. Failure Reason included in HTTP Error response"), @ResponseCode(code=503, condition="One or more of Controller services are unavailable")})
    public Response addUserLink(@PathParam(value="containerName") String containerName, @PathParam(value="name") String name, @TypeHint(value=TopologyUserLinkConfig.class) TopologyUserLinkConfig userLinkConfig) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.WRITE, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        ITopologyManager topologyManager = (ITopologyManager)ServiceHelper.getInstance(ITopologyManager.class, (String)containerName, (Object)this);
        if (topologyManager == null) {
            throw new ResourceNotFoundException(RestMessages.NOCONTAINER.toString());
        }
        Status status = topologyManager.addUserLink(userLinkConfig);
        if (status.isSuccess()) {
            NorthboundUtils.auditlog((String)"User Link", (String)this.username, (String)"added", (String)(userLinkConfig.getName() + " from " + NorthboundUtils.getPortName((NodeConnector)NodeConnector.fromString((String)userLinkConfig.getSrcNodeConnector()), (String)containerName, (Object)this) + " to " + NorthboundUtils.getPortName((NodeConnector)NodeConnector.fromString((String)userLinkConfig.getDstNodeConnector()), (String)containerName, (Object)this)), (String)containerName);
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        throw new InternalServerErrorException(status.getDescription());
    }

    @Path(value="/{containerName}/userLink/{name}")
    @DELETE
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @StatusCodes(value={@ResponseCode(code=204, condition="User link removed successfully"), @ResponseCode(code=404, condition="The Container Name or Link Configuration Name was not found"), @ResponseCode(code=503, condition="One or more of Controller services are unavailable")})
    public Response deleteUserLink(@PathParam(value="containerName") String containerName, @PathParam(value="name") String name) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.WRITE, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        ITopologyManager topologyManager = (ITopologyManager)ServiceHelper.getInstance(ITopologyManager.class, (String)containerName, (Object)this);
        if (topologyManager == null) {
            throw new ResourceNotFoundException(RestMessages.NOCONTAINER.toString());
        }
        Status ret = topologyManager.deleteUserLink(name);
        if (ret.isSuccess()) {
            NorthboundUtils.auditlog((String)"User Link", (String)this.username, (String)"removed", (String)name, (String)containerName);
            return Response.noContent().build();
        }
        return NorthboundUtils.getResponse((Status)ret);
    }
}

